% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crypto_global_quotes.R
\name{crypto_global_quotes}
\alias{crypto_global_quotes}
\title{Retrieves historical quotes for the global aggregate market}
\usage{
crypto_global_quotes(
  which = "latest",
  convert = "USD",
  start_date = NULL,
  end_date = NULL,
  interval = "daily",
  quote = FALSE,
  finalWait = FALSE
)
}
\arguments{
\item{which}{string Shall the code retrieve the latest listing or a historic listing?}

\item{convert}{string (default: USD) to one or more of available fiat or precious metals prices (\code{fiat_list()}). If more
than one are selected please separate by comma (e.g. "USD,BTC"), only necessary if 'quote=TRUE'}

\item{start_date}{string Start date to retrieve data from, format 'yyyymmdd'}

\item{end_date}{string End date to retrieve data from, format 'yyyymmdd', if not provided, today will be assumed}

\item{interval}{string Interval with which to sample data, default 'daily'. Must be one of \verb{"hourly" "daily" "weekly" "monthly" "yearly" "1d" "2d" "3d" "7d" "14d" "15d" "30d" "60d" "90d" "365d"}}

\item{quote}{logical set to TRUE if you want to include price data (FALSE=default)}

\item{finalWait}{to avoid calling the web-api again with another command before 60s are over (TRUE=default)}
}
\value{
List of latest/new/historic listings of crypto currencies in a tibble (depending on the "which"-switch and
whether "quote" is requested, the result may only contain some of the following variables):
\item{btc_dominance}{number Bitcoin's market dominance percentage by market cap.}
\item{eth_dominance}{number Ethereum's market dominance percentage by market cap.}
\item{active_cryptocurrencies}{number Count of active crypto currencies tracked by CMC
This includes all crypto currencies with a listing_status of "active" or "listed".}
\item{total_cryptocurrencies}{number Count of all crypto currencies tracked by CMC
This includes "inactive" listing_status crypto currencies.}
\item{active_market_pairs}{number Count of active market pairs tracked by CoinMarketCap across all exchanges.}#'
\item{active_exchanges}{number Count of active exchanges tracked by CMC This includes all
exchanges with a listing_status of "active" or "listed".}
\item{total_exchanges}{number Count of all exchanges tracked by CMC
This includes "inactive" listing_status exchanges.}
\item{last_updated}{Timestamp of when this record was last updated.}
\item{total_market_cap}{number The sum of all individual cryptocurrency market capitalizations in the requested currency.}
\item{total_volume_24h}{number The sum of rolling 24 hour adjusted volume (as outlined in our methodology) for all
crypto currencies in the requested currency.}
\item{total_volume_24h_reported}{number The sum of rolling 24 hour reported volume for all crypto currencies in the requested currency.}#'
\item{altcoin_volume_24h}{number The sum of rolling 24 hour adjusted volume (as outlined in our methodology) for
all crypto currencies excluding Bitcoin in the requested currency.}
\item{altcoin_volume_24h_reported}{number The sum of rolling 24 hour reported volume for
all crypto currencies excluding Bitcoin in the requested currency.}
\item{altcoin_market_cap	}{number The sum of all individual cryptocurrency market capitalizations excluding Bitcoin in the requested currency.}
}
\description{
This code uses the web api. It retrieves global quote data (latest/historic) and does not require an 'API' key.
}
\examples{
\dontrun{
# return new listings from the last 30 days
new_quotes <- crypto_global_quotes(which="latest", quote=FALSE)
new_quotes2 <- crypto_global_quotes(which="latest", quote=TRUE, convert="BTC,USD")
# return all global quotes in the first week of January 2014
quotes_2014w1 <- crypto_global_quotes(which="historical", quote=TRUE,
start_date = "20140101", end_date="20140107", interval="daily")

# report in two different currencies
listings_2014w1_USDBTC <- crypto_global_quotes(which="historical", quote=TRUE,
start_date = "20140101", end_date="20140107", interval="daily", convert="USD,BTC")
}

}
