% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{fetch}
\alias{fetch}
\title{Fetch time-based API-endpoint responses}
\usage{
fetch(ticker, source, futures, interval, type, to, from, ...)
}
\arguments{
\item{ticker}{An \link{character}-vector of \link{length} 1. See \code{\link[=available_tickers]{available_tickers()}} for available tickers.}

\item{source}{A \link{character}-vector of \link{length} 1. \code{binance} by default. See \code{\link[=available_exchanges]{available_exchanges()}} for available exchanges.}

\item{futures}{A \link{logical}-vector of \link{length} 1. \link{TRUE} by default. Returns futures market if \link{TRUE}, spot market otherwise.}

\item{interval}{A \link{character}-vector of \link{length} 1. \verb{1d} by default. See \code{\link[=available_intervals]{available_intervals()}} for available intervals.}

\item{type}{\link{character}-vector of length 1. See details}

\item{to}{An optional \link{character}, \link{date} or \link{POSIXct} vector of \link{length} 1. \link{NULL} by default.}

\item{from}{An optional \link{character}, \link{date} or \link{POSIXct} vector of \link{length} 1. \link{NULL} by default.}

\item{...}{additional parameters passed down the endpoint}
}
\value{
It returns an \link{xts}-object from the desired endpoint.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function is a high-level wrapper around the development tools available
and should reduce the amount of coding.
}
\details{
This function can only be used to fetch time-based objects, and can therefore
not be used to get, for example, \code{\link[=available_tickers]{available_tickers()}}.
}
\seealso{
Other development tools: 
\code{\link{GET}()},
\code{\link{convert_date}()},
\code{\link{default_dates}()},
\code{\link{flatten}()},
\code{\link{is.date}()}
}
\author{
Serkan Korkmaz
}
\concept{development tools}
\keyword{internal}
