% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crypto_pie.R
\name{crypto_pie}
\alias{crypto_pie}
\title{Make a pie chart of your crypto revenues}
\usage{
crypto_pie(table.revenues, by = "exchange")
}
\arguments{
\item{table.revenues}{The revenue table to plot}

\item{by}{To plot by which element, one of \code{c("exchange", "revenue.type")}.}
}
\value{
A ggplot2 object in the form of a pie chart.
}
\description{
Format a .csv file from Newton for later ACB processing.
}
\examples{
shakepay <- format_shakepay(data_shakepay)
newton <- format_newton(data_newton)
all.data <- merge_exchanges(shakepay, newton)
formatted.ACB <- format_ACB(all.data, verbose = FALSE)
table.revenues <- report_revenues(formatted.ACB)
crypto_pie(table.revenues)
crypto_pie(table.revenues, by = "revenue.type")
}
