/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph;

import com.vividsolutions.jts.geom.Coordinate;

public class Quadrant {
    public static int quadrant(double dx, double dy) {
        if (dx == 0.0 && dy == 0.0) {
            throw new IllegalArgumentException("Cannot compute the quadrant for point ( " + dx + ", " + dy + " )");
        }
        if (dx >= 0.0) {
            if (dy >= 0.0) {
                return 0;
            }
            return 3;
        }
        if (dy >= 0.0) {
            return 1;
        }
        return 2;
    }

    public static int quadrant(Coordinate p0, Coordinate p1) {
        double dx = p1.x - p0.x;
        double dy = p1.y - p0.y;
        if (dx == 0.0 && dy == 0.0) {
            throw new IllegalArgumentException("Cannot compute the quadrant for two identical points " + p0);
        }
        return Quadrant.quadrant(dx, dy);
    }

    public static boolean isOpposite(int quad1, int quad2) {
        if (quad1 == quad2) {
            return false;
        }
        int diff = (quad1 - quad2 + 4) % 4;
        return diff == 2;
    }

    public static int commonHalfPlane(int quad1, int quad2) {
        int max;
        if (quad1 == quad2) {
            return quad1;
        }
        int diff = (quad1 - quad2 + 4) % 4;
        if (diff == 2) {
            return -1;
        }
        int min = quad1 < quad2 ? quad1 : quad2;
        int n = max = quad1 > quad2 ? quad1 : quad2;
        if (min == 0 && max == 3) {
            return 3;
        }
        return min;
    }

    public static boolean isInHalfPlane(int quad, int halfPlane) {
        if (halfPlane == 3) {
            return quad == 3 || quad == 0;
        }
        return quad == halfPlane || quad == halfPlane + 1;
    }

    public static boolean isNorthern(int quad) {
        return quad == 0 || quad == 1;
    }
}

