/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.chain;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geomgraph.Quadrant;
import com.vividsolutions.jts.index.chain.MonotoneChain;
import java.util.ArrayList;
import java.util.List;

public class MonotoneChainBuilder {
    public static int[] toIntArray(List list) {
        int[] array = new int[list.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (Integer)list.get(i);
        }
        return array;
    }

    public static List getChains(Coordinate[] pts) {
        return MonotoneChainBuilder.getChains(pts, null);
    }

    public static List getChains(Coordinate[] pts, Object context) {
        ArrayList<MonotoneChain> mcList = new ArrayList<MonotoneChain>();
        int[] startIndex = MonotoneChainBuilder.getChainStartIndices(pts);
        for (int i = 0; i < startIndex.length - 1; ++i) {
            MonotoneChain mc = new MonotoneChain(pts, startIndex[i], startIndex[i + 1], context);
            mcList.add(mc);
        }
        return mcList;
    }

    public static int[] getChainStartIndices(Coordinate[] pts) {
        int last;
        int start = 0;
        ArrayList<Integer> startIndexList = new ArrayList<Integer>();
        startIndexList.add(new Integer(start));
        do {
            last = MonotoneChainBuilder.findChainEnd(pts, start);
            startIndexList.add(new Integer(last));
        } while ((start = last) < pts.length - 1);
        int[] startIndex = MonotoneChainBuilder.toIntArray(startIndexList);
        return startIndex;
    }

    private static int findChainEnd(Coordinate[] pts, int start) {
        int quad;
        int last;
        int chainQuad = Quadrant.quadrant(pts[start], pts[start + 1]);
        for (last = start + 1; last < pts.length && (quad = Quadrant.quadrant(pts[last - 1], pts[last])) == chainQuad; ++last) {
        }
        return last - 1;
    }
}

