% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clinicaltrials_gov_dates.R
\name{clinicaltrials_gov_dates}
\alias{clinicaltrials_gov_dates}
\title{Download a vector of dates on which a ClinicalTrials.gov registry
entry was updated}
\usage{
clinicaltrials_gov_dates(nctid, status_change_only = FALSE, polite = TRUE)
}
\arguments{
\item{nctid}{A character string including a well-formed
ClinicalTrials.gov NCT Number, e.g. "NCT00942747". (A
capitalized "NCT" followed by eight numerals with no spaces or
hyphens.)}

\item{status_change_only}{If TRUE, returns only the dates marked
with a Recruitment Status change, default FALSE.}

\item{polite}{If TRUE, this function uses the \code{polite} package to
download data, if FALSE, this function uses the \code{rvest}
package, default TRUE.}
}
\value{
A character vector of ISO-8601 formatted dates
corresponding to the dates on which there were clinical trial
history version updates.
}
\description{
Download a vector of dates on which a ClinicalTrials.gov registry
entry was updated
}
\examples{

\donttest{
versions <- clinicaltrials_gov_dates("NCT00942747")
}

}
