% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_isUniqueTrial.R
\name{f.isUniqueTrial}
\alias{f.isUniqueTrial}
\title{Calculate if record is unique for a study}
\usage{
f.isUniqueTrial(df = NULL)
}
\arguments{
\item{df}{data frame such as from \link{dbGetFieldsIntoDf}. If `NULL`,
prints fields needed in `df` for calculating this trial concept, which can
be used with \link{dbGetFieldsIntoDf}.}
}
\value{
data frame with columns `_id` and `.isUniqueTrial`, a logical.
}
\description{
Trial concept calculated: Applies function dbFindIdsUniqueTrials() with
its defaults.
}
\examples{
# fields needed
f.isUniqueTrial()

# apply trial concept when creating data frame
dbc <- nodbi::src_sqlite(
  dbname = system.file("extdata", "demo.sqlite", package = "ctrdata"),
  collection = "my_trials", flags = RSQLite::SQLITE_RO)
trialsDf <- dbGetFieldsIntoDf(
  calculate = "f.isUniqueTrial",
  con = dbc)
trialsDf

}
