% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemical-APIs-batch.R
\name{get_public_chemical_list_by_name_batch}
\alias{get_public_chemical_list_by_name_batch}
\title{Get chemical list by name batch}
\usage{
get_public_chemical_list_by_name_batch(
  name_list = NULL,
  Projection = "",
  API_key = NULL,
  rate_limit = 0L,
  verbose = FALSE
)
}
\arguments{
\item{name_list}{A list of chemical list names.}

\item{Projection}{Optional parameter controlling return type. It takes values
'chemicallistall' and 'chemicallistname' with the former as the default
value.}

\item{API_key}{The user-specific API key.}

\item{rate_limit}{Number of seconds to wait between each request}

\item{verbose}{A logical indicating if some “progress report” should be given.}
}
\value{
A named list of data.frames containing information about the chemical
lists. Note, these are not the chemical lists themselves. To access the
chemicals in a given list, use \code{\link{get_chemicals_in_list}}.
}
\description{
Get chemical list by name batch
}
\examples{
\dontshow{if (has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Pull chemical list information by list names
list_info <- get_public_chemical_list_by_name_batch(name_list = c('CCL4',
                                                                  'NATADB'))
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{get_chemicals_in_list}}
}
