% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemical-APIs.R
\name{get_all_public_chemical_lists}
\alias{get_all_public_chemical_lists}
\title{Get all public chemical lists}
\usage{
get_all_public_chemical_lists(
  Projection = "",
  API_key = NULL,
  Server = chemical_api_server,
  verbose = FALSE
)
}
\arguments{
\item{Projection}{Optional parameter controlling return type. It takes values
chemicallistall' and 'chemicallistname' with the former as the default
value.}

\item{API_key}{The user-specific api key}

\item{Server}{The root address for the API endpoint}

\item{verbose}{A logical indicating if some “progress report” should be given.}
}
\value{
A data.frame containing information on all public chemical lists
available from the CTX chemical api.
}
\description{
Get all public chemical lists
}
\examples{
\dontshow{if (has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Pull all chemical lists
all_lists <- get_all_public_chemical_lists()
\dontshow{\}) # examplesIf}
}
