% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hazard-APIs.R
\name{get_genetox_summary}
\alias{get_genetox_summary}
\title{Get genetox summary}
\usage{
get_genetox_summary(
  DTXSID = NULL,
  API_key = NULL,
  Server = hazard_api_server,
  verbose = FALSE
)
}
\arguments{
\item{DTXSID}{The chemical identifier DTXSID}

\item{API_key}{The user-specific API key}

\item{Server}{The root address for the API endpoint}

\item{verbose}{A logical indicating if some “progress report” should be given.}
}
\value{
A data.frame of genetox summary data related to the input DTXSID.
}
\description{
Get genetox summary
}
\examples{
\dontshow{if (has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Pull genetox summary for BPA
bpa_genetox_summary <- get_genetox_summary(DTXSID = 'DTXSID7020182')
\dontshow{\}) # examplesIf}
}
