% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codon_weight.R
\name{est_rscu}
\alias{est_rscu}
\title{Estimate RSCU}
\usage{
est_rscu(cf, weight = 1, pseudo_cnt = 1, codon_table = get_codon_table())
}
\arguments{
\item{cf}{matrix of codon frequencies as calculated by `count_codons()`.}

\item{weight}{a vector of the same length as `seqs` that gives different weights
to CDSs when count codons. for example, it could be gene expression levels.}

\item{pseudo_cnt}{pseudo count to avoid dividing by zero. This may occur when
only a few sequences are available for RSCU calculation.}

\item{codon_table}{a table of genetic code derived from `get_codon_table` or
`create_codon_table`.}
}
\value{
a data.table of codon info. RSCU values are reported in the last column.
}
\description{
\code{est_rscu} returns the RSCU value of codons
}
\examples{
# compute RSCU of all yeast genes
cf_all <- count_codons(yeast_cds)
est_rscu(cf_all)

# compute RSCU of highly expressed (top 500) yeast genes
heg <- head(yeast_exp[order(-yeast_exp$fpkm), ], n = 500)
cf_heg <- count_codons(yeast_cds[heg$gene_id])
est_rscu(cf_heg)

}
\references{
Sharp PM, Tuohy TM, Mosurski KR. 1986. Codon usage in yeast: cluster analysis clearly differentiates highly and lowly expressed genes. Nucleic Acids Res 14:5125-5143.
}
