
###################################################

# getStickerCube getCubieCube

###################################################

# get patterned cubes for each representation
# isolated other than single call to as.cubieCube in getCubieCube
# 52 patterns including solved case 

getStickerCube <- function(pattern = c("solved", "superflip","checker","easychecker","wire","tablecloth",
                                       "spiral","logo","vstripe","ocorners","cross1","cross2","cinc",
                                       "cincinc", "anaconda","python","bmamba","gmamba","fourspot",
                                       "sixspot","twister","cec","tetris","henryzz","fchecker","exduckfeet",
                                       "strdotsolved","picnic","percent","mirror","ochecker","fourp2d","rockets",
                                       "slash","pillars","twduckfeet","roncinc","headlights","csnake","tomparks",
                                       "fourcrosses","edgehex3","edgehex2","twrings","exrings","twchickfeet",
                                       "exchickfeet","twpeaks4","twpeaks2","expeaks","six2one","yinyang",
                                       "henrysnake"))
{
  pattern <- match.arg(pattern)
  out <- switch(EXPR = pattern,
                "solved" = c("U", "U", "U", "U", "U", "U", "U", "U", "U", "R", "R", "R", 
                             "R", "R", "R", "R", "R", "R", "F", "F", "F", "F", "F", "F", "F", 
                             "F", "F", "D", "D", "D", "D", "D", "D", "D", "D", "D", "L", "L", 
                             "L", "L", "L", "L", "L", "L", "L", "B", "B", "B", "B", "B", "B", 
                             "B", "B", "B"),
                "superflip" = c("U","B","U","L","U","R","U","F","U","R","U","R","F","R","B",
                                "R","D","R","F","U","F","L","F","R","F","D","F",
                                "D","F","D","L","D","R","D","B","D","L","U","L","B","L","F",
                                "L","D","L","B","U","B","R","B","L","B","D","B"),
                "checker" = c("U", "F", "U", "F", "U", "F", "U", "F", "U", "R", "U", "R", 
                              "U", "R", "U", "R", "U", "R", "F", "R", "F", "R", "F", "R", "F", 
                              "R", "F", "D", "B", "D", "B", "D", "B", "D", "B", "D", "L", "D", 
                              "L", "D", "L", "D", "L", "D", "L", "B", "L", "B", "L", "B", "L", 
                              "B", "L", "B"),
                "easychecker" = c("U", "D", "U", "D", "U", "D", "U", "D", "U", "R", "L", "R", 
                                  "L", "R", "L", "R", "L", "R", "F", "B", "F", "B", "F", "B", "F", 
                                  "B", "F", "D", "U", "D", "U", "D", "U", "D", "U", "D", "L", "R", 
                                  "L", "R", "L", "R", "L", "R", "L", "B", "F", "B", "F", "B", "F", 
                                  "B", "F", "B"),
                "wire" = c("U", "U", "U", "U", "U", "U", "U", "U", "U", "R", "L", "L", 
                           "R", "R", "R", "L", "L", "R", "B", "B", "F", "F", "F", "F", "F", 
                           "B", "B", "D", "D", "D", "D", "D", "D", "D", "D", "D", "L", "R", 
                           "R", "L", "L", "L", "R", "R", "L", "F", "F", "B", "B", "B", "B", 
                           "B", "F", "F"),
                "tablecloth" = c("B", "F", "B", "R", "U", "R", "B", "F", "B", "R", "U", "R", 
                                 "U", "R", "U", "R", "U", "R", "U", "R", "U", "B", "F", "B", "U", 
                                 "R", "U", "F", "B", "F", "L", "D", "L", "F", "B", "F", "L", "D", 
                                 "L", "D", "L", "D", "L", "D", "L", "D", "L", "D", "F", "B", "F", 
                                 "D", "L", "D"),
                "spiral" = c("F", "F", "F", "F", "U", "F", "F", "U", "U", "R", "R", "U", 
                             "U", "R", "U", "U", "U", "U", "R", "R", "F", "R", "F", "F", "R", 
                             "R", "R", "B", "B", "B", "B", "D", "B", "D", "D", "B", "D", "D", 
                             "D", "D", "L", "D", "L", "L", "D", "L", "L", "L", "L", "B", "B", 
                             "L", "L", "B"),
                "logo" = c("D", "U", "D", "U", "U", "U", "D", "U", "D", "R", "R", "L", 
                           "L", "R", "L", "L", "R", "R", "F", "F", "B", "B", "F", "B", "B", 
                           "F", "F", "U", "D", "U", "D", "D", "D", "U", "D", "U", "L", "L", 
                           "R", "R", "L", "R", "R", "L", "L", "B", "B", "F", "F", "B", "F", 
                           "F", "B", "B"),
                "vstripe" = c("U", "U", "U", "U", "U", "U", "U", "U", "U", "B", "R", "F", 
                              "B", "R", "F", "B", "R", "F", "L", "F", "R", "L", "F", "R", "L", 
                              "F", "R", "D", "D", "D", "D", "D", "D", "D", "D", "D", "F", "L", 
                              "B", "F", "L", "B", "F", "L", "B", "R", "B", "L", "R", "B", "L", 
                              "R", "B", "L"),
                "ocorners" = c("D", "D", "D", "D", "U", "D", "D", "D", "D", "L", "R", "R", 
                               "R", "R", "R", "R", "R", "L", "B", "F", "F", "F", "F", "F", "F", 
                               "F", "B", "U", "U", "U", "U", "D", "U", "U", "U", "U", "R", "L", 
                               "L", "L", "L", "L", "L", "L", "R", "F", "B", "B", "B", "B", "B", 
                               "B", "B", "F"),
                "cross1" = c("D", "U", "D", "U", "U", "U", "D", "U", "D", "F", "R", "F", 
                             "R", "R", "R", "F", "R", "F", "R", "F", "R", "F", "F", "F", "R", 
                             "F", "R", "U", "D", "U", "D", "D", "D", "U", "D", "U", "B", "L", 
                             "B", "L", "L", "L", "B", "L", "B", "L", "B", "L", "B", "B", "B", 
                             "L", "B", "L"),
                "cross2" = c("R", "U", "R", "U", "U", "U", "R", "U", "R", "F", "R", "F", 
                             "R", "R", "R", "F", "R", "F", "U", "F", "U", "F", "F", "F", "U", 
                             "F", "U", "L", "D", "L", "D", "D", "D", "L", "D", "L", "B", "L", 
                             "B", "L", "L", "L", "B", "L", "B", "D", "B", "D", "B", "B", "B", 
                             "D", "B", "D"),
                "cinc" = c("F", "F", "F", "F", "U", "U", "F", "U", "U", "R", "R", "U", 
                           "R", "R", "U", "U", "U", "U", "R", "F", "F", "R", "F", "F", "R", 
                           "R", "R", "B", "B", "B", "D", "D", "B", "D", "D", "B", "D", "D", 
                           "D", "L", "L", "D", "L", "L", "D", "L", "L", "L", "L", "B", "B", 
                           "L", "B", "B"),
                "cincinc" = c("R", "R", "R", "R", "U", "U", "R", "U", "F", "U", "R", "F", 
                              "R", "R", "F", "F", "F", "F", "U", "F", "R", "U", "F", "F", "U", 
                              "U", "U", "L", "L", "L", "D", "D", "L", "B", "D", "L", "B", "B", 
                              "B", "L", "L", "B", "D", "L", "B", "D", "D", "D", "D", "B", "B", 
                              "D", "B", "L"),
                "anaconda" = c("F", "U", "F", "U", "U", "F", "F", "F", "F", "U", "U", "U", 
                               "U", "R", "R", "U", "R", "U", "R", "R", "R", "F", "F", "R", "R", 
                               "F", "R", "B", "D", "B", "B", "D", "D", "B", "B", "B", "D", "L", 
                               "D", "D", "L", "L", "D", "D", "D", "L", "B", "L", "B", "B", "L", 
                               "L", "L", "L"),
                "python" = c("D", "U", "D", "D", "U", "D", "D", "U", "D", "F", "F", "F", 
                             "F", "R", "R", "F", "R", "F", "R", "F", "R", "F", "F", "R", "R", 
                             "R", "R", "U", "U", "U", "D", "D", "D", "U", "U", "U", "B", "B", 
                             "B", "B", "L", "L", "B", "L", "B", "L", "B", "L", "B", "B", "L", 
                             "L", "L", "L"),
                "bmamba" = c("R", "U", "R", "U", "U", "R", "R", "R", "R", "B", "B", "B", 
                             "R", "R", "R", "B", "B", "B", "D", "D", "D", "F", "F", "F", "D", 
                             "D", "D", "L", "L", "L", "D", "D", "L", "L", "D", "L", "F", "L", 
                             "F", "F", "L", "L", "F", "F", "F", "U", "B", "U", "U", "B", "U", 
                             "U", "B", "U"),
                "gmamba" = c("R", "R", "R", "U", "U", "U", "R", "R", "R", "B", "B", "B", 
                             "R", "R", "R", "B", "B", "B", "D", "D", "D", "F", "F", "F", "D", 
                             "D", "D", "L", "L", "L", "D", "D", "L", "L", "D", "L", "F", "L", 
                             "F", "F", "L", "L", "F", "F", "F", "U", "U", "U", "B", "B", "U", 
                             "U", "B", "U"),
                "fourspot" = c("U", "U", "U", "U", "U", "U", "U", "U", "U", "L", "L", "L", 
                               "L", "R", "L", "L", "L", "L", "B", "B", "B", "B", "F", "B", "B", 
                               "B", "B", "D", "D", "D", "D", "D", "D", "D", "D", "D", "R", "R", 
                               "R", "R", "L", "R", "R", "R", "R", "F", "F", "F", "F", "B", "F", 
                               "F", "F", "F"),
                "sixspot" = c("F", "F", "F", "F", "U", "F", "F", "F", "F", "U", "U", "U", 
                              "U", "R", "U", "U", "U", "U", "R", "R", "R", "R", "F", "R", "R", 
                              "R", "R", "B", "B", "B", "B", "D", "B", "B", "B", "B", "D", "D", 
                              "D", "D", "L", "D", "D", "D", "D", "L", "L", "L", "L", "B", "L", 
                              "L", "L", "L"),
                "twister" = c("R", "U", "R", "R", "U", "U", "R", "U", "U", "R", "R", "F", 
                              "R", "R", "F", "F", "R", "F", "U", "F", "F", "F", "F", "F", "U", 
                              "U", "U", "L", "L", "L", "D", "D", "D", "D", "D", "L", "B", "B", 
                              "B", "L", "L", "L", "L", "L", "B", "D", "B", "D", "D", "B", "B", 
                              "D", "B", "B"),
                "cec" = c("R", "F", "R", "F", "U", "F", "R", "F", "R", "F", "U", "F", 
                          "U", "R", "U", "F", "U", "F", "U", "R", "U", "R", "F", "R", "U", 
                          "R", "U", "L", "B", "L", "B", "D", "B", "L", "B", "L", "B", "D", 
                          "B", "D", "L", "D", "B", "D", "B", "D", "L", "D", "L", "B", "L", 
                          "D", "L", "D"),
                "tetris" = c("F", "F", "B", "F", "U", "B", "F", "B", "B", "U", "D", "D", 
                             "U", "R", "D", "U", "U", "D", "R", "L", "L", "R", "F", "L", "R", 
                             "R", "L", "B", "B", "F", "B", "D", "F", "B", "F", "F", "U", "D", 
                             "D", "U", "L", "D", "U", "U", "D", "L", "R", "R", "L", "B", "R", 
                             "L", "L", "R"),
                "henryzz" = c("U", "D", "U", "D", "U", "D", "U", "D", "U", "R", "L", "R", 
                              "L", "R", "L", "R", "R", "R", "F", "F", "F", "B", "F", "B", "F", 
                              "B", "F", "D", "U", "D", "U", "D", "U", "D", "U", "D", "L", "R", 
                              "L", "R", "L", "R", "L", "L", "L", "B", "B", "B", "F", "B", "F", 
                              "B", "F", "B"),
                "fchecker" = c("U", "U", "U", "U", "U", "U", "U", "U", "U", "R", "L", "R", 
                               "L", "R", "L", "R", "L", "R", "F", "F", "F", "F", "F", "F", "F", 
                               "F", "F", "D", "D", "D", "D", "D", "D", "D", "D", "D", "L", "R", 
                               "L", "R", "L", "R", "L", "R", "L", "B", "B", "B", "B", "B", "B", 
                               "B", "B", "B"),
                "exduckfeet" = c("D", "U", "D", "U", "U", "D", "D", "D", "U", "R", "B", "B", 
                                 "B", "R", "R", "B", "R", "B", "L", "L", "F", "F", "F", "L", "L", 
                                 "F", "L", "U", "D", "U", "U", "D", "D", "D", "U", "U", "F", "L", 
                                 "F", "F", "L", "L", "L", "F", "F", "R", "B", "R", "B", "B", "R", 
                                 "R", "R", "B"),
                "strdotsolved" = c("D", "U", "D", "D", "U", "D", "D", "U", "D", "L", "L", "L", 
                                   "L", "R", "L", "L", "L", "L", "F", "F", "F", "F", "F", "F", "F", 
                                   "F", "F", "U", "D", "U", "U", "D", "U", "U", "D", "U", "R", "R", 
                                   "R", "R", "L", "R", "R", "R", "R", "B", "B", "B", "B", "B", "B", 
                                   "B", "B", "B"),
                "picnic" = c("U", "D", "U", "D", "U", "D", "U", "D", "U", "L", "L", "L", 
                             "L", "R", "L", "R", "R", "R", "B", "B", "B", "B", "F", "B", "F", 
                             "F", "F", "D", "U", "D", "U", "D", "U", "D", "U", "D", "R", "R", 
                             "R", "R", "L", "R", "L", "L", "L", "F", "F", "F", "F", "B", "F", 
                             "B", "B", "B"),
                "percent" = c("U", "U", "D", "U", "U", "U", "D", "U", "U", "R", "L", "L", 
                              "L", "R", "L", "L", "L", "R", "F", "F", "F", "F", "F", "F", "F", 
                              "F", "F", "D", "D", "U", "D", "D", "D", "U", "D", "D", "L", "R", 
                              "R", "R", "L", "R", "R", "R", "L", "B", "B", "B", "B", "B", "B", 
                              "B", "B", "B"),
                "mirror" = c("D", "D", "D", "U", "U", "U", "U", "U", "U", "L", "L", "R", 
                             "L", "R", "R", "L", "L", "R", "B", "F", "B", "B", "F", "B", "B", 
                             "F", "B", "D", "D", "D", "D", "D", "D", "U", "U", "U", "L", "R", 
                             "R", "L", "L", "R", "L", "R", "R", "F", "B", "F", "F", "B", "F", 
                             "F", "B", "F"),
                "ochecker" = c("U", "D", "U", "D", "U", "D", "U", "D", "U", "R", "R", "R", 
                               "R", "R", "R", "R", "R", "R", "F", "F", "F", "F", "F", "F", "F", 
                               "F", "F", "D", "U", "D", "U", "D", "U", "D", "U", "D", "L", "L", 
                               "L", "L", "L", "L", "L", "L", "L", "B", "B", "B", "B", "B", "B", 
                               "B", "B", "B"),
                "fourp2d" = c("D", "R", "D", "R", "U", "R", "D", "R", "D", "F", "F", "F", 
                              "F", "R", "F", "F", "F", "F", "R", "U", "R", "U", "F", "U", "R", 
                              "U", "R", "U", "L", "U", "L", "D", "L", "U", "L", "U", "B", "B", 
                              "B", "B", "L", "B", "B", "B", "B", "L", "D", "L", "D", "B", "D", 
                              "L", "D", "L"),
                "rockets" = c("U", "U", "U", "U", "U", "U", "U", "U", "U", "L", "R", "L", 
                              "R", "R", "R", "R", "L", "R", "B", "F", "B", "F", "F", "F", "F", 
                              "B", "F", "D", "D", "D", "D", "D", "D", "D", "D", "D", "R", "L", 
                              "R", "L", "L", "L", "L", "R", "L", "F", "B", "F", "B", "B", "B", 
                              "B", "F", "B"),
                "slash" = c("U", "U", "U", "U", "U", "U", "U", "U", "U", "L", "L", "R", 
                            "L", "R", "L", "R", "L", "L", "F", "B", "B", "B", "F", "B", "B", 
                            "B", "F", "D", "D", "D", "D", "D", "D", "D", "D", "D", "R", "R", 
                            "L", "R", "L", "R", "L", "R", "R", "B", "F", "F", "F", "B", "F", 
                            "F", "F", "B"),
                "pillars" = c("U", "D", "U", "D", "U", "D", "U", "D", "U", "L", "R", "L", 
                              "L", "R", "L", "L", "R", "L", "B", "F", "B", "B", "F", "B", "B", 
                              "F", "B", "D", "U", "D", "U", "D", "U", "D", "U", "D", "R", "L", 
                              "R", "R", "L", "R", "R", "L", "R", "F", "B", "F", "F", "B", "F", 
                              "F", "B", "F"),
                "twduckfeet" = c("R", "U", "R", "U", "U", "R", "R", "R", "U", "R", "F", "F", 
                                 "F", "R", "R", "F", "R", "F", "U", "U", "F", "F", "F", "U", "U", 
                                 "F", "U", "L", "D", "L", "L", "D", "D", "D", "L", "L", "B", "L", 
                                 "B", "B", "L", "L", "L", "B", "B", "D", "B", "D", "B", "B", "D", 
                                 "D", "D", "B"),
                "roncinc" = c("U", "U", "U", "U", "U", "U", "U", "U", "U", "R", "R", "L", 
                              "R", "R", "L", "L", "L", "L", "B", "F", "F", "B", "F", "F", "B", 
                              "B", "B", "D", "D", "D", "D", "D", "D", "D", "D", "D", "L", "L", 
                              "R", "L", "L", "R", "R", "R", "R", "F", "B", "B", "F", "B", "B", 
                              "F", "F", "F"),
                "headlights" = c("U", "U", "U", "U", "U", "U", "U", "U", "U", "R", "R", "R", 
                                 "L", "R", "L", "R", "R", "R", "F", "F", "F", "F", "F", "F", "F", 
                                 "F", "F", "D", "D", "D", "D", "D", "D", "D", "D", "D", "L", "L", 
                                 "L", "R", "L", "R", "L", "L", "L", "B", "B", "B", "B", "B", "B", 
                                 "B", "B", "B"),
                "csnake" = c("D", "D", "U", "D", "U", "D", "U", "D", "D", "L", "R", "R", 
                             "L", "R", "L", "R", "R", "L", "F", "F", "F", "F", "F", "F", "F", 
                             "F", "F", "U", "U", "D", "U", "D", "U", "D", "U", "U", "R", "L", 
                             "L", "R", "L", "R", "L", "L", "R", "B", "B", "B", "B", "B", "B", 
                             "B", "B", "B"),
                "tomparks" = c("L", "U", "D", "L", "U", "D", "L", "U", "D", "F", "R", "B", 
                               "F", "R", "B", "F", "R", "B", "B", "F", "R", "B", "F", "R", "B", 
                               "F", "R", "L", "D", "U", "L", "D", "U", "L", "D", "U", "U", "U", 
                               "U", "L", "L", "L", "D", "D", "D", "R", "B", "F", "R", "B", "F", 
                               "R", "B", "F"),
                "fourcrosses" = c("F", "U", "B", "U", "U", "U", "F", "U", "B", "R", "R", "R", 
                                  "R", "R", "R", "R", "R", "R", "D", "F", "U", "F", "F", "F", "D", 
                                  "F", "U", "B", "D", "F", "D", "D", "D", "B", "D", "F", "L", "L", 
                                  "L", "L", "L", "L", "L", "L", "L", "D", "B", "U", "B", "B", "B", 
                                  "D", "B", "U"),
                "edgehex3" = c("U", "R", "U", "R", "U", "U", "U", "U", "U", "R", "R", "R", 
                               "R", "R", "F", "R", "F", "R", "F", "F", "F", "U", "F", "F", "F", 
                               "U", "F", "D", "L", "D", "D", "D", "L", "D", "D", "D", "L", "B", 
                               "L", "L", "L", "B", "L", "L", "L", "B", "D", "B", "D", "B", "B", 
                               "B", "B", "B"),
                "edgehex2" = c("U", "D", "U", "D", "U", "U", "U", "U", "U", "R", "R", "R", 
                               "R", "R", "B", "R", "B", "R", "F", "F", "F", "L", "F", "F", "F", 
                               "L", "F", "D", "U", "D", "D", "D", "U", "D", "D", "D", "L", "F", 
                               "L", "L", "L", "F", "L", "L", "L", "B", "R", "B", "R", "B", "B", 
                               "B", "B", "B"),
                "twrings" = c("F", "F", "F", "F", "U", "U", "F", "U", "F", "U", "R", "U", 
                              "R", "R", "U", "U", "U", "U", "R", "F", "R", "R", "F", "F", "R", 
                              "R", "R", "B", "B", "B", "D", "D", "B", "B", "D", "B", "D", "D", 
                              "D", "L", "L", "D", "D", "L", "D", "L", "L", "L", "L", "B", "B", 
                              "L", "B", "L"),
                "exrings" = c("D", "D", "D", "D", "U", "U", "D", "U", "D", "B", "R", "B", 
                              "R", "R", "B", "B", "B", "B", "L", "F", "L", "L", "F", "F", "L", 
                              "L", "L", "U", "U", "U", "D", "D", "U", "U", "D", "U", "F", "F", 
                              "F", "L", "L", "F", "F", "L", "F", "R", "R", "R", "R", "B", "B", 
                              "R", "B", "R"),
                "twchickfeet" = c("R", "R", "R", "R", "U", "R", "R", "R", "U", "R", "F", "F", 
                                  "F", "R", "F", "F", "F", "F", "U", "U", "F", "U", "F", "U", "U", 
                                  "U", "U", "L", "L", "L", "L", "D", "L", "D", "L", "L", "B", "B", 
                                  "B", "B", "L", "B", "L", "B", "B", "D", "D", "D", "D", "B", "D", 
                                  "D", "D", "B"),
                "exchickfeet" = c("D", "D", "D", "D", "U", "D", "D", "D", "U", "R", "B", "B", 
                                  "B", "R", "B", "B", "B", "B", "L", "L", "F", "L", "F", "L", "L", 
                                  "L", "L", "U", "U", "U", "U", "D", "U", "D", "U", "U", "F", "F", 
                                  "F", "F", "L", "F", "L", "F", "F", "R", "R", "R", "R", "B", "R", 
                                  "R", "R", "B"),
                "twpeaks4" = c("L", "L", "U", "L", "U", "R", "U", "R", "R", "F", "F", "R", 
                               "F", "R", "D", "R", "D", "D", "F", "U", "U", "L", "F", "U", "L", 
                               "L", "F", "F", "F", "D", "F", "D", "B", "D", "B", "B", "B", "B", 
                               "L", "B", "L", "D", "L", "D", "D", "B", "U", "U", "R", "B", "U", 
                               "R", "R", "B"),
                "twpeaks2" = c("U", "U", "U", "U", "U", "F", "U", "F", "F", "U", "U", "R", 
                               "U", "R", "R", "R", "R", "R", "F", "R", "R", "F", "F", "R", "F", 
                               "F", "F", "D", "D", "D", "B", "D", "D", "B", "B", "D", "L", "L", 
                               "L", "D", "L", "L", "D", "D", "L", "B", "B", "B", "B", "B", "L", 
                               "B", "L", "L"),
                "expeaks" = c("U", "U", "U", "U", "U", "D", "U", "D", "D", "B", "B", "R", 
                              "B", "R", "R", "R", "R", "R", "F", "L", "L", "F", "F", "L", "F", 
                              "F", "F", "D", "D", "D", "U", "D", "D", "U", "U", "D", "L", "L", 
                              "L", "F", "L", "L", "F", "F", "L", "B", "B", "B", "B", "B", "R", 
                              "B", "R", "R"),
                "six2one" = c("F", "U", "U", "F", "U", "U", "L", "U", "U", "R", "R", "B", 
                              "R", "R", "U", "R", "R", "U", "F", "F", "F", "F", "F", "F", "R", 
                              "R", "D", "D", "D", "B", "D", "D", "B", "D", "D", "R", "L", "L", 
                              "D", "L", "L", "D", "L", "L", "F", "L", "L", "U", "B", "B", "B", 
                              "B", "B", "B"),
                "yinyang" = c("R", "R", "L", "R", "U", "L", "R", "L", "L", "B", "F", "F", 
                              "B", "R", "F", "B", "B", "F", "U", "U", "U", "U", "F", "D", "D", 
                              "D", "D", "R", "R", "L", "R", "D", "L", "R", "L", "L", "F", "B", 
                              "B", "F", "L", "B", "F", "F", "B", "U", "U", "U", "U", "B", "D", 
                              "D", "D", "D"),
                "henrysnake" = c("U", "U", "U", "U", "U", "U", "U", "U", "U", "R", "L", "L", 
                                 "R", "R", "R", "L", "L", "R", "B", "F", "F", "B", "F", "B", "F", 
                                 "F", "B", "D", "D", "D", "D", "D", "D", "D", "D", "D", "L", "R", 
                                 "R", "L", "L", "L", "R", "R", "L", "F", "B", "B", "F", "B", "F", 
                                 "B", "B", "F"))
  color <- c("U", "R", "F", "D", "L", "B")
  names(out) <- paste0(rep(color,each=9), rep(1:9,length(color)))
  class(out) <- c("stickerCube", "cube")
  out
}

getCubieCube <- function(pattern = c("solved", "superflip","checker","easychecker","wire","tablecloth",
                                     "spiral","logo","vstripe","ocorners","cross1","cross2","cinc",
                                     "cincinc", "anaconda","python","bmamba","gmamba","fourspot",
                                     "sixspot","twister","cec","tetris","henryzz","fchecker","exduckfeet",
                                     "strdotsolved","picnic","percent","mirror","ochecker","fourp2d","rockets",
                                     "slash","pillars","twduckfeet","roncinc","headlights","csnake","tomparks",
                                     "fourcrosses","edgehex3","edgehex2","twrings","exrings","twchickfeet",
                                     "exchickfeet","twpeaks4","twpeaks2","expeaks","six2one","yinyang",
                                     "henrysnake")) 
{
  out <- as.cubieCube(getStickerCube(pattern))
  out
}
