% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oc_youden_normal.R
\name{oc_youden_normal}
\alias{oc_youden_normal}
\title{Determine an optimal cutpoint for the Youden-Index assuming normal distributions}
\usage{
oc_youden_normal(data, x, class, pos_class = NULL, neg_class = NULL,
  direction, ...)
}
\arguments{
\item{data}{A data frame or tibble in which the columns that are given in x
and class can be found.}

\item{x}{(character) The variable name to be used for classification,
e.g. predictions or test values.}

\item{class}{(character) The variable name indicating class membership.}

\item{pos_class}{The value of class that indicates the positive class.}

\item{neg_class}{The value of class that indicates the negative class.}

\item{direction}{(character) Use ">=" or "<=" to select whether an x value
>= or <= the cutoff predicts the positive class.}

\item{...}{To capture further arguments that are always passed to the method
function by cutpointr. The cutpointr function passes data, x, class,
metric_func, direction, pos_class and neg_class to the method function.}
}
\description{
An optimal cutpoint maximizing the Youden- or J-Index
(sensitivity + specificity - 1) is calculated parametrically assuming
normal distributions per class.
}
\examples{
data(suicide)
oc_youden_normal(suicide, "dsi", "suicide",
  pos_class = "yes", neg_class = "no", direction = ">=")
cutpointr(suicide, dsi, suicide, method = oc_youden_normal)
}
\seealso{
Other method functions: \code{\link{maximize_boot_metric}},
  \code{\link{maximize_gam_metric}},
  \code{\link{maximize_loess_metric}},
  \code{\link{maximize_metric}},
  \code{\link{maximize_spline_metric}},
  \code{\link{oc_manual}}, \code{\link{oc_mean}},
  \code{\link{oc_median}}, \code{\link{oc_youden_kernel}}
}
\concept{method functions}
