context("state_digits")
test_that(
    desc = "understands the default value of digits = 1", {
        x = c(69.5363027878474, 92.3636962002316, 53.807734500996,
              35.49315129364, 43.192061672989, 60.3180744069461,
              47.9843106948398, 73.9138704112922, 69.8551241887232,
              58.5606727664028, 84.2708993271481, 48.4857688108879,
              60.9900537982725, 65.8019126527842, 41.2094397006424,
              67.1498778328713, 52.0614379895338, 67.7204373325544,
              66.2624319878151, 59.0046413348133, 64.0008914390268,
              65.8122846125018, 61.9935159050467, 61.1419383774739,
              66.4565893313334, 84.865963327446, 73.5822380765172,
              52.4848665753891, 77.4990734356392, 56.725522510645,
              67.3371586006271, 75.7376338957736, 57.2684635315752,
              24.8335982439541, 64.0264955669014, 79.2214590522685,
              53.6906695501463, 71.3704337098284, 87.8737928495259,
              62.3630542676835, 78.6870499126885, 63.6165502783025,
              84.958459422199, 89.9310890312022, 59.2490655584328,
              61.0859951034953, 72.133145165411, 73.4301840067107,
              71.6045905205008, 47.9922988697579, 94.2897651846598,
              40.4317563541754, 59.2454173094024, 58.6944129655762,
              78.5177226091321, 69.7311783956332, 69.9658611319182,
              69.9576715830038, 72.162974995665, 48.8088080601463,
              54.4803826832402, 68.8003469874, 46.7512524451755,
              59.4912061819308, 51.8310126170599, 65.3585293860652,
              65.869322292793, 36.0834744791644, 37.5994297592166,
              36.514488678355, 51.1820020801774, 76.8441237644897,
              73.0486877032327, 77.0092940448592, 55.746566814139,
              38.0939861918195, 55.2579333069481, 69.7712838578894,
              71.8979457587082, 64.9281804028175, 46.8750647044339,
              58.857100200592, 48.2500277111869, 57.227496663649,
              69.2111581668472, 73.2607417958674, 47.3829010515129,
              57.6489011489014, 47.5229334943645, 54.2885556704652,
              59.2051155639158, 54.1147966023561, 50.0896347592279,
              60.7456401020957, 99.7437158094843, 57.4691413783972,
              46.9780052669866, 66.1094016409732, 49.7707596703168,
              46.2566129505689, 48.8390863984221, 77.0889496467053,
              66.2841495221739, 73.1261212222732, 55.9509637931904,
              56.6624849079438, 80.3820760987744, 85.0656752195639,
              70.9627093449533, 73.9244214440067, 53.0684432639942,
              57.8416651354281, 75.4127577300015, 101.958494606834,
              57.6792350008474, 57.6185426806648, 67.2311093154884,
              81.1680227349802)
        expect_equal(
            nchar(
                sub('.*\\.', '', CoefVar$new(x)$est())
            ),
            1
        )
        expect_equal(
            nchar(
                sub('.*\\.', '', CoefQuartVar$new(x)$est())
            ),
            1
        )
        expect_equal(
            nchar(
                sub(
                    '.*\\.', '',
                    CoefVarCI$new(x)$kelley_ci()$statistics$est
                )
            ),
            1
        )
        expect_equal(
            nchar(
                sub(
                    '.*\\.', '',
                    CoefQuartVarCI$new(x)$norm_ci()$statistics$est
                )
            ),
            1
        )
        expect_equal(
            nchar(
                sub(
                    '.*\\.', '',
                    SampleQuantiles$new(x, probs = 0.96)$qx()
                )
            ),
            1
        )
        expect_equal(
            nchar(
                sub(
                    '.*\\.', '',
                    cv_versatile(x, method = "kelley")$statistics$est
                )
            ),
            1
        )
        expect_equal(
            nchar(
                sub(
                    '.*\\.', '',
                    cv_versatile(x)$statistics$est
                )
            ),
            1
        )
        expect_equal(
            nchar(
                sub(
                    '.*\\.', '',
                    cqv_versatile(x, method = "bonett")$statistics$est
                )
            ),
            1
        )
    }
)
test_that(
    desc = "understands the user input of digits", {
        x = c(69.5363027878474, 92.3636962002316, 53.807734500996,
              35.49315129364, 43.192061672989, 60.3180744069461,
              47.9843106948398, 73.9138704112922, 69.8551241887232,
              58.5606727664028, 84.2708993271481, 48.4857688108879,
              60.9900537982725, 65.8019126527842, 41.2094397006424,
              67.1498778328713, 52.0614379895338, 67.7204373325544,
              66.2624319878151, 59.0046413348133, 64.0008914390268,
              65.8122846125018, 61.9935159050467, 61.1419383774739,
              66.4565893313334, 84.865963327446, 73.5822380765172,
              52.4848665753891, 77.4990734356392, 56.725522510645,
              67.3371586006271, 75.7376338957736, 57.2684635315752,
              24.8335982439541, 64.0264955669014, 79.2214590522685,
              53.6906695501463, 71.3704337098284, 87.8737928495259,
              62.3630542676835, 78.6870499126885, 63.6165502783025,
              84.958459422199, 89.9310890312022, 59.2490655584328,
              61.0859951034953, 72.133145165411, 73.4301840067107,
              71.6045905205008, 47.9922988697579, 94.2897651846598,
              40.4317563541754, 59.2454173094024, 58.6944129655762,
              78.5177226091321, 69.7311783956332, 69.9658611319182,
              69.9576715830038, 72.162974995665, 48.8088080601463,
              54.4803826832402, 68.8003469874, 46.7512524451755,
              59.4912061819308, 51.8310126170599, 65.3585293860652,
              65.869322292793, 36.0834744791644, 37.5994297592166,
              36.514488678355, 51.1820020801774, 76.8441237644897,
              73.0486877032327, 77.0092940448592, 55.746566814139,
              38.0939861918195, 55.2579333069481, 69.7712838578894,
              71.8979457587082, 64.9281804028175, 46.8750647044339,
              58.857100200592, 48.2500277111869, 57.227496663649,
              69.2111581668472, 73.2607417958674, 47.3829010515129,
              57.6489011489014, 47.5229334943645, 54.2885556704652,
              59.2051155639158, 54.1147966023561, 50.0896347592279,
              60.7456401020957, 99.7437158094843, 57.4691413783972,
              46.9780052669866, 66.1094016409732, 49.7707596703168,
              46.2566129505689, 48.8390863984221, 77.0889496467053,
              66.2841495221739, 73.1261212222732, 55.9509637931904,
              56.6624849079438, 80.3820760987744, 85.0656752195639,
              70.9627093449533, 73.9244214440067, 53.0684432639942,
              57.8416651354281, 75.4127577300015, 101.958494606834,
              57.6792350008474, 57.6185426806648, 67.2311093154884,
              81.1680227349802)
        expect_equal(
            nchar(
                sub('.*\\.', '', CoefVar$new(x, digits = 3)$est())
            ),
            3
        )
        expect_equal(
            nchar(
                sub('.*\\.', '', CoefQuartVar$new(x, digits = 2)$est())
            ),
            2
        )
        expect_equal(
            nchar(
                sub(
                    '.*\\.', '',
                    CoefVarCI$new(x, digits = 3)$kelley_ci()$statistics$est
                    )
            ),
            3
        )
        expect_equal(
            nchar(
                sub(
                    '.*\\.', '',
                    CoefQuartVarCI$new(x, digits = 2)$bonett_ci()$statistics$est
                )
            ),
            2
        )
        expect_equal(
            nchar(
                sub(
                    '.*\\.', '',
                    SampleQuantiles$new(x, digits = 2, probs = 0.91)$qx()
                )
            ),
            2
        )
        expect_equal(
            nchar(
                sub(
                    '.*\\.', '',
                    cv_versatile(x, digits = 3, method = "kelley")$statistics$est
                )
            ),
            3
        )
        expect_equal(
            nchar(
                sub(
                    '.*\\.', '',
                    cqv_versatile(
                        x, digits = 3, method = "bonett"
                        )$statistics$est
                )
            ),
            3
        )
    }
)
