% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvd_api_functions.R
\name{cvd_time_period_list}
\alias{cvd_time_period_list}
\title{List time periods}
\usage{
cvd_time_period_list(indicator_type_id)
}
\arguments{
\item{indicator_type_id}{integer - Indicator type ID, e.g. standard or outcome indicator type. If passed will show time periods containing data of the given type (optional)}
}
\value{
Tibble of time period details
}
\description{
Returns all available time periods
}
\details{
CVD Prevent API documentation:
\href{https://bmchealthdocs.atlassian.net/wiki/spaces/CP/pages/317882369/CVDPREVENT+API+Documentation#\%2FtimePeriod}{Time period}
}
\examples{
# NB, the following examples are not tested because they take longer than
# expected to return the results

# get a tibble of all periods
\donttest{cvd_time_periods <- cvd_time_period_list()}

# filter for the latest four periods
\donttest{cvd_time_period_list() |>
  dplyr::filter(IndicatorTypeName == 'Standard') |>
  dplyr::slice_max(order_by = TimePeriodID, n = 4) |>
  dplyr::select(TimePeriodID, TimePeriodName)}
}
\seealso{
\code{\link[=cvd_indicator_types]{cvd_indicator_types()}}, \code{\link[=cvd_time_period_system_levels]{cvd_time_period_system_levels()}}
}
