library(cvms)
context("most_challenging()")

test_that("binomial model works with most_challenging()", {

  # TODO Save the data and cross-validation to disk
  # So we save time and can run on CRAN
  testthat::skip_on_cran()

  # Load data and fold it
  xpectr::set_test_seed(1)
  dat_ready <- participant.scores %>%
    dplyr::mutate(diagnosis = as.factor(diagnosis))
  dat_list <- groupdata2::fold(dat_ready,
    k = 4,
    num_fold_cols = 8,
    cat_col = "diagnosis",
    id_col = "participant"
  )

  CV_binom <- cross_validate(
    dat_list,
    formulas = c("diagnosis ~ score", "diagnosis ~ score + age"),
    fold_cols = paste0(".folds_", 1:8),
    family = "binomial"
  )

  collected_preds <- dplyr::bind_rows(CV_binom$Predictions, .id = "Model") %>%
    dplyr::group_by(.data$Model)

  hard_to_predict_perc <- most_challenging(
    collected_preds,
    prediction_cols = "Predicted Class",
    threshold = 0.25,
    threshold_is = "percentage",
    type = "binomial"
  )

  # Passing Predicted Class

  ## Testing 'hard_to_predict_perc'                                         ####
  ## Initially generated by xpectr
  # Testing class
  expect_equal(
    class(hard_to_predict_perc),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    hard_to_predict_perc[["Model"]],
    c("1", "1", "1", "1", "1", "1", "1", "1", "2", "2", "2", "2",
      "2", "2", "2", "2", "2", "2"),
    fixed = TRUE)
  expect_equal(
    hard_to_predict_perc[["Observation"]],
    c(1, 4, 5, 7, 10, 20, 21, 15, 1, 4, 7, 10, 20, 21, 30, 5, 11,
      15),
    tolerance = 1e-4)
  expect_equal(
    hard_to_predict_perc[["Correct"]],
    c(0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2),
    tolerance = 1e-4)
  expect_equal(
    hard_to_predict_perc[["Incorrect"]],
    c(8, 8, 8, 8, 8, 8, 8, 2, 8, 8, 8, 8, 8, 8, 8, 6, 6, 6),
    tolerance = 1e-4)
  expect_equal(
    hard_to_predict_perc[["Accuracy"]],
    c(0, 0, 0, 0, 0, 0, 0, 0.75, 0, 0, 0, 0, 0, 0, 0, 0.25, 0.25,
      0.25),
    tolerance = 1e-4)
  expect_equal(
    hard_to_predict_perc[["<="]],
    c(0.78125, 0.78125, 0.78125, 0.78125, 0.78125, 0.78125, 0.78125,
      0.78125, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25,
      0.25),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(hard_to_predict_perc),
    c("Model", "Observation", "Correct", "Incorrect", "Accuracy",
      "<="),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(hard_to_predict_perc),
    c("character", "integer", "integer", "integer", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(hard_to_predict_perc),
    c("character", "integer", "integer", "integer", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(hard_to_predict_perc),
    c(18L, 6L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(hard_to_predict_perc)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'hard_to_predict_perc'                                ####

  hard_to_predict_score <- most_challenging(
    collected_preds, threshold = 0.30,
    threshold_is = "score",
    prediction_cols = "Predicted Class",
    type = "binomial")

  ## Testing 'hard_to_predict_score'                                        ####
  ## Initially generated by xpectr
  # Testing class
  expect_equal(
    class(hard_to_predict_score),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    hard_to_predict_score[["Model"]],
    c("1", "1", "1", "1", "1", "1", "1", "2", "2", "2", "2", "2",
      "2", "2", "2", "2", "2"),
    fixed = TRUE)
  expect_equal(
    hard_to_predict_score[["Observation"]],
    c(1, 4, 5, 7, 10, 20, 21, 1, 4, 7, 10, 20, 21, 30, 5, 11, 15),
    tolerance = 1e-4)
  expect_equal(
    hard_to_predict_score[["Correct"]],
    c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2),
    tolerance = 1e-4)
  expect_equal(
    hard_to_predict_score[["Incorrect"]],
    c(8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 6, 6, 6),
    tolerance = 1e-4)
  expect_equal(
    hard_to_predict_score[["Accuracy"]],
    c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.25, 0.25, 0.25),
    tolerance = 1e-4)
  expect_equal(
    hard_to_predict_score[["<="]],
    c(0.3, 0.3, 0.3, 0.3, 0.3, 0.3, 0.3, 0.3, 0.3, 0.3, 0.3, 0.3,
      0.3, 0.3, 0.3, 0.3, 0.3),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(hard_to_predict_score),
    c("Model", "Observation", "Correct", "Incorrect", "Accuracy",
      "<="),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(hard_to_predict_score),
    c("character", "integer", "integer", "integer", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(hard_to_predict_score),
    c("character", "integer", "integer", "integer", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(hard_to_predict_score),
    c(17L, 6L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(hard_to_predict_score)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'hard_to_predict_score'                               ####


  # Passing Predicted Probabilities

  hard_to_predict_perc <- most_challenging(
    collected_preds,
    threshold = 0.25,
    prediction_cols = "Prediction",
    threshold_is = "percentage",
    type = "binomial"
  )


  ## Testing 'hard_to_predict_perc'                                         ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(hard_to_predict_perc),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    hard_to_predict_perc[["Model"]],
    c("1", "1", "1", "1", "1", "1", "1", "1", "2", "2", "2", "2", "2",
      "2", "2", "2"),
    fixed = TRUE)
  expect_equal(
    hard_to_predict_perc[["Observation"]],
    c(21, 4, 20, 1, 10, 7, 5, 15, 21, 4, 10, 1, 20, 30, 7, 5),
    tolerance = 1e-4)
  expect_equal(
    hard_to_predict_perc[["Correct"]],
    c(0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 2),
    tolerance = 1e-4)
  expect_equal(
    hard_to_predict_perc[["Incorrect"]],
    c(8, 8, 8, 8, 8, 8, 8, 2, 8, 8, 8, 8, 8, 8, 8, 6),
    tolerance = 1e-4)
  expect_equal(
    hard_to_predict_perc[["Accuracy"]],
    c(0, 0, 0, 0, 0, 0, 0, 0.75, 0, 0, 0, 0, 0, 0, 0, 0.25),
    tolerance = 1e-4)
  expect_equal(
    hard_to_predict_perc[["MAE"]],
    c(0.9113, 0.87466, 0.80773, 0.74735, 0.70434, 0.67745, 0.59302,
      0.51221, 0.90214, 0.88203, 0.82707, 0.79774, 0.79396, 0.67362,
      0.62222, 0.61037),
    tolerance = 1e-4)
  expect_equal(
    hard_to_predict_perc[["Cross Entropy"]],
    c(2.46602, 2.10844, 1.66741, 1.37893, 1.22152, 1.13429, 0.90603,
      0.73089, 2.43574, 2.15931, 1.7743, 1.6262, 1.63953, 1.14048,
      0.98703, 0.96459),
    tolerance = 1e-4)
  expect_equal(
    hard_to_predict_perc[["<="]],
    c(0.50617, 0.50617, 0.50617, 0.50617, 0.50617, 0.50617, 0.50617,
      0.50617, 0.60168, 0.60168, 0.60168, 0.60168, 0.60168, 0.60168,
      0.60168, 0.60168),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(hard_to_predict_perc),
    c("Model", "Observation", "Correct", "Incorrect", "Accuracy", "MAE",
      "Cross Entropy", "<="),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(hard_to_predict_perc),
    c("character", "integer", "integer", "integer", "numeric", "numeric",
      "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(hard_to_predict_perc),
    c("character", "integer", "integer", "integer", "double", "double",
      "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(hard_to_predict_perc),
    c(16L, 8L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(hard_to_predict_perc)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'hard_to_predict_perc'                                ####



  hard_to_predict_score <- most_challenging(
    collected_preds,
    threshold = 0.25,
    prediction_cols = "Prediction",
    threshold_is = "score",
    type = "binomial",
    metric = "Cross Entropy"
  )


  ## Testing 'hard_to_predict_score'                                        ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(hard_to_predict_score),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    xpectr::smpl(hard_to_predict_score[["Model"]], n = 30),
    c("1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1",
      "2", "2", "2", "2", "2", "2", "2", "2", "2", "2", "2", "2",
      "2", "2", "2", "2", "2"),
    fixed = TRUE)
  expect_equal(
    xpectr::smpl(hard_to_predict_score[["Observation"]], n = 30),
    c(4, 20, 10, 5, 15, 8, 27, 18, 11, 2, 29, 17, 24, 4, 10, 20, 1,
      30, 7, 5, 15, 11, 29, 26, 18, 2, 12, 17, 24, 28),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(hard_to_predict_score[["Correct"]], n = 30),
    c(0, 0, 0, 0, 6, 8, 7, 8, 8, 8, 8, 8, 8, 0, 0, 0, 0, 0, 0, 2, 2,
      2, 6, 4, 8, 8, 8, 8, 8, 8),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(hard_to_predict_score[["Incorrect"]], n = 30),
    c(8, 8, 8, 8, 2, 0, 1, 0, 0, 0, 0, 0, 0, 8, 8, 8, 8, 8, 8, 6, 6,
      6, 2, 4, 0, 0, 0, 0, 0, 0),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(hard_to_predict_score[["Accuracy"]], n = 30),
    c(0, 0, 0, 0, 0.75, 1, 0.875, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      0.25, 0.25, 0.25, 0.75, 0.5, 1, 1, 1, 1, 1, 1),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(hard_to_predict_score[["MAE"]], n = 30),
    c(0.87466, 0.80773, 0.70434, 0.59302, 0.51221, 0.45766, 0.43, 0.41295,
      0.3802, 0.30993, 0.29584, 0.2832, 0.25713, 0.88203, 0.82707,
      0.79396, 0.79774, 0.67362, 0.62222, 0.61037, 0.57563, 0.53746,
      0.46669, 0.40979, 0.42615, 0.36338, 0.32969, 0.28782, 0.23427,
      0.21972),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(hard_to_predict_score[["Cross Entropy"]], n = 30),
    c(2.10844, 1.66741, 1.22152, 0.90603, 0.73089, 0.61251, 0.56596,
      0.53306, 0.48395, 0.37905, 0.35128, 0.33321, 0.29811, 2.15931,
      1.7743, 1.63953, 1.6262, 1.14048, 0.98703, 0.96459, 0.88959,
      0.7947, 0.63471, 0.60267, 0.55752, 0.47048, 0.41274, 0.34032,
      0.26926, 0.25096),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(hard_to_predict_score[["<="]], n = 30),
    c(0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25,
      0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25,
      0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(hard_to_predict_score),
    c("Model", "Observation", "Correct", "Incorrect", "Accuracy", "MAE",
      "Cross Entropy", "<="),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(hard_to_predict_score),
    c("character", "integer", "integer", "integer", "numeric", "numeric",
      "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(hard_to_predict_score),
    c("character", "integer", "integer", "integer", "double", "double",
      "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(hard_to_predict_score),
    c(38L, 8L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(hard_to_predict_score)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'hard_to_predict_score'                               ####





})

test_that("multinomial model works with most_challenging()", {

  # TODO Save the data and cross-validation to disk
  # So we save time and can run on CRAN
  testthat::skip_on_cran()

  # Load data and fold it
  xpectr::set_test_seed(1)

  # # Create and fold dataset
  data_mc <- multiclass_probability_tibble(
    num_classes = 3, num_observations = 50,
    apply_softmax = TRUE, FUN = runif,
    class_name = "predictor_"
  )
  class_names <- paste0("class_", c(1, 2, 3))
  data_mc[["target"]] <- factor(sample(
    x = class_names,
    size = 50, replace = TRUE
  ))
  dat <- groupdata2::fold(data_mc, k = 4, num_fold_cols = 8)

  multinom_model_fn <- function(train_data, formula, hyperparameters) {
    nnet::multinom(
      formula = formula, # converted to formula object within fit_model()
      data = train_data
    )
  }

  random_predict_fn <- function(test_data, model, formula, hyperparameters, train_data) {
    multiclass_probability_tibble(
      num_classes = 3, num_observations = nrow(test_data),
      apply_softmax = TRUE, FUN = runif,
      class_name = "class_"
    )
  }

  CVmultinomlist <- cross_validate_fn(dat,
    model_fn = multinom_model_fn,
    predict_fn = random_predict_fn,
    formulas = c(
      "target ~ predictor_1 + predictor_2 + predictor_3",
      "target ~ predictor_1"
    ),
    fold_cols = paste0(".folds_", 1:8),
    type = "multinomial"
  )

  collected_preds <- dplyr::bind_rows(CVmultinomlist$Predictions, .id = "Model") %>%
    dplyr::group_by(.data$Model)

  # Passing Predicted Class

  hard_to_predict <- most_challenging(
    collected_preds,
    threshold = 0.15,
    threshold_is = "percentage",
    type = "multinomial"
  )

  ## Testing 'hard_to_predict'                                              ####
  ## Initially generated by xpectr
  # Testing class
  expect_equal(
    class(hard_to_predict),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    xpectr::smpl(hard_to_predict[["Model"]], n = 30),
    c("1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "2",
      "2", "2", "2", "2", "2", "2", "2", "2", "2", "2", "2", "2",
      "2", "2", "2", "2", "2", "2"),
    fixed = TRUE)
  expect_equal(
    xpectr::smpl(hard_to_predict[["Observation"]], n = 30),
    c(4, 10, 11, 12, 35, 8, 28, 31, 39, 47, 48, 33, 50, 2, 7, 10,
      11, 16, 18, 21, 23, 25, 27, 28, 29, 31, 37, 41, 43, 45),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(hard_to_predict[["Correct"]], n = 30),
    c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2, 2, 2, 2),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(hard_to_predict[["Incorrect"]], n = 30),
    c(8, 8, 8, 8, 8, 7, 7, 7, 7, 7, 7, 8, 8, 6, 6, 6, 6, 6, 6, 6,
      6, 6, 6, 6, 6, 6, 6, 6, 6, 6),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(hard_to_predict[["Accuracy"]], n = 30),
    c(0, 0, 0, 0, 0, 0.125, 0.125, 0.125, 0.125, 0.125, 0.125, 0,
      0, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25,
      0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(hard_to_predict[["<="]], n = 30),
    c(0.125, 0.125, 0.125, 0.125, 0.125, 0.125, 0.125, 0.125, 0.125,
      0.125, 0.125, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25,
      0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25,
      0.25),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(hard_to_predict),
    c("Model", "Observation", "Correct", "Incorrect", "Accuracy",
      "<="),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(hard_to_predict),
    c("character", "integer", "integer", "integer", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(hard_to_predict),
    c("character", "integer", "integer", "integer", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(hard_to_predict),
    c(35L, 6L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(hard_to_predict)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'hard_to_predict'                                     ####

  hard_to_predict_score <- most_challenging(collected_preds,
                                            threshold = 0.15,
                                            threshold_is = "score",
                                            type = "multinomial")

  ## Testing 'hard_to_predict_score'                                        ####
  ## Initially generated by xpectr
  # Testing class
  expect_equal(
    class(hard_to_predict_score),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    hard_to_predict_score[["Model"]],
    c("1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1",
      "1", "1", "2", "2", "2"),
    fixed = TRUE)
  expect_equal(
    hard_to_predict_score[["Observation"]],
    c(4, 10, 11, 12, 17, 35, 6, 8, 28, 31, 33, 39, 47, 48, 5, 33,
      50),
    tolerance = 1e-4)
  expect_equal(
    hard_to_predict_score[["Correct"]],
    c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0),
    tolerance = 1e-4)
  expect_equal(
    hard_to_predict_score[["Incorrect"]],
    c(8, 8, 8, 8, 8, 8, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8),
    tolerance = 1e-4)
  expect_equal(
    hard_to_predict_score[["Accuracy"]],
    c(0, 0, 0, 0, 0, 0, 0.125, 0.125, 0.125, 0.125, 0.125, 0.125,
      0.125, 0.125, 0, 0, 0),
    tolerance = 1e-4)
  expect_equal(
    hard_to_predict_score[["<="]],
    c(0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15,
      0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(hard_to_predict_score),
    c("Model", "Observation", "Correct", "Incorrect", "Accuracy",
      "<="),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(hard_to_predict_score),
    c("character", "integer", "integer", "integer", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(hard_to_predict_score),
    c("character", "integer", "integer", "integer", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(hard_to_predict_score),
    c(17L, 6L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(hard_to_predict_score)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'hard_to_predict_score'                               ####

  # Passing Predicted Probabilities

  collected_preds <- collected_preds %>%
    legacy_unnest(Prediction)

  hard_to_predict_perc <- most_challenging(
    collected_preds,
    prediction_cols = c("class_1", "class_2", "class_3"),
    threshold = 0.10,
    threshold_is = "percentage",
    type = "multinomial"
  )


  ## Testing 'hard_to_predict_perc'                                         ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(hard_to_predict_perc),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    hard_to_predict_perc[["Model"]],
    c("1", "1", "1", "1", "1", "2", "2", "2", "2", "2"),
    fixed = TRUE)
  expect_equal(
    hard_to_predict_perc[["Observation"]],
    c(35, 4, 48, 10, 12, 33, 5, 8, 50, 27),
    tolerance = 1e-4)
  expect_equal(
    hard_to_predict_perc[["Correct"]],
    c(0, 0, 1, 0, 0, 0, 0, 3, 0, 2),
    tolerance = 1e-4)
  expect_equal(
    hard_to_predict_perc[["Incorrect"]],
    c(8, 8, 7, 8, 8, 8, 8, 5, 8, 6),
    tolerance = 1e-4)
  expect_equal(
    hard_to_predict_perc[["Accuracy"]],
    c(0, 0, 0.125, 0, 0, 0, 0, 0.375, 0, 0.25),
    tolerance = 1e-4)
  expect_equal(
    hard_to_predict_perc[["MAE"]],
    c(0.74404, 0.72037, 0.71569, 0.7139, 0.71158, 0.73233, 0.71303,
      0.70669, 0.70591, 0.705),
    tolerance = 1e-4)
  expect_equal(
    hard_to_predict_perc[["Cross Entropy"]],
    c(1.37509, 1.28895, 1.28523, 1.2706, 1.256, 1.33695, 1.25709, 1.26747,
      1.23764, 1.2666),
    tolerance = 1e-4)
  expect_equal(
    hard_to_predict_perc[["<="]],
    c(0.70761, 0.70761, 0.70761, 0.70761, 0.70761, 0.70348, 0.70348,
      0.70348, 0.70348, 0.70348),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(hard_to_predict_perc),
    c("Model", "Observation", "Correct", "Incorrect", "Accuracy", "MAE",
      "Cross Entropy", "<="),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(hard_to_predict_perc),
    c("character", "integer", "integer", "integer", "numeric", "numeric",
      "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(hard_to_predict_perc),
    c("character", "integer", "integer", "integer", "double", "double",
      "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(hard_to_predict_perc),
    c(10L, 8L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(hard_to_predict_perc)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'hard_to_predict_perc'                                ####


  hard_to_predict_score <- most_challenging(
    collected_preds,
    prediction_cols = c("class_1", "class_2", "class_3"),
    threshold = 1.25,
    threshold_is = "score",
    type = "multinomial",
    metric = "Cross Entropy"
  )


  ## Testing 'hard_to_predict_score'                                        ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(hard_to_predict_score),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    hard_to_predict_score[["Model"]],
    c("1", "1", "1", "1", "1", "1", "1", "2", "2", "2", "2", "2"),
    fixed = TRUE)
  expect_equal(
    hard_to_predict_score[["Observation"]],
    c(35, 4, 48, 10, 12, 30, 8, 33, 8, 27, 11, 5),
    tolerance = 1e-4)
  expect_equal(
    hard_to_predict_score[["Correct"]],
    c(0, 0, 1, 0, 0, 2, 1, 0, 3, 2, 2, 0),
    tolerance = 1e-4)
  expect_equal(
    hard_to_predict_score[["Incorrect"]],
    c(8, 8, 7, 8, 8, 6, 7, 8, 5, 6, 6, 8),
    tolerance = 1e-4)
  expect_equal(
    hard_to_predict_score[["Accuracy"]],
    c(0, 0, 0.125, 0, 0, 0.25, 0.125, 0, 0.375, 0.25, 0.25, 0),
    tolerance = 1e-4)
  expect_equal(
    hard_to_predict_score[["MAE"]],
    c(0.74404, 0.72037, 0.71569, 0.7139, 0.71158, 0.70273, 0.70717,
      0.73233, 0.70669, 0.705, 0.70331, 0.71303),
    tolerance = 1e-4)
  expect_equal(
    hard_to_predict_score[["Cross Entropy"]],
    c(1.37509, 1.28895, 1.28523, 1.2706, 1.256, 1.25488, 1.25065, 1.33695,
      1.26747, 1.2666, 1.2619, 1.25709),
    tolerance = 1e-4)
  expect_equal(
    hard_to_predict_score[["<="]],
    c(1.25, 1.25, 1.25, 1.25, 1.25, 1.25, 1.25, 1.25, 1.25, 1.25, 1.25,
      1.25),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(hard_to_predict_score),
    c("Model", "Observation", "Correct", "Incorrect", "Accuracy", "MAE",
      "Cross Entropy", "<="),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(hard_to_predict_score),
    c("character", "integer", "integer", "integer", "numeric", "numeric",
      "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(hard_to_predict_score),
    c("character", "integer", "integer", "integer", "double", "double",
      "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(hard_to_predict_score),
    c(12L, 8L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(hard_to_predict_score)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'hard_to_predict_score'                               ####



})

test_that("multinomial - predicted.musicians works with most_challenging()", {

  # TODO Save the data and cross-validation to disk
  # So we save time and can run on CRAN
  testthat::skip_on_cran()

  xpectr::set_test_seed(1)

  ### Passing Predicted Class ####

  hard_to_predict <- most_challenging(
    predicted.musicians %>% dplyr::group_by(.data$Classifier),
    obs_id_col = "ID",
    threshold = 0.15,
    threshold_is = "percentage",
    type = "multinomial"
  )


  ## Testing 'hard_to_predict'                                              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(hard_to_predict),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    xpectr::smpl(hard_to_predict[["Classifier"]], n = 30),
    c("e1071_svm", "e1071_svm", "e1071_svm", "e1071_svm", "e1071_svm",
      "e1071_svm", "e1071_svm", "e1071_svm", "e1071_svm", "nnet_multinom",
      "nnet_multinom", "nnet_multinom", "nnet_multinom", "nnet_multinom",
      "nnet_multinom", "nnet_multinom", "nnet_multinom", "nnet_multinom",
      "nnet_multinom", "nnet_multinom", "randomForest", "randomForest",
      "randomForest", "randomForest", "randomForest", "randomForest",
      "randomForest", "randomForest", "randomForest", "randomForest"),
    fixed = TRUE)
  expect_equal(
    xpectr::smpl(hard_to_predict[["ID"]], n = 30),
    structure(c(7L, 17L, 22L, 27L, 40L, 48L, 51L, 52L, 59L, 1L, 2L,
      9L, 25L, 27L, 40L, 44L, 51L, 54L, 58L, 60L, 11L, 14L, 25L, 30L,
      43L, 47L, 50L, 51L, 52L, 60L), .Label = c("1", "2", "3", "4",
      "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15",
      "16", "17", "18", "19", "20", "21", "22", "23", "24", "25",
      "26", "27", "28", "29", "30", "31", "32", "33", "34", "35",
      "36", "37", "38", "39", "40", "41", "42", "43", "44", "45",
      "46", "47", "48", "49", "50", "51", "52", "53", "54", "55",
      "56", "57", "58", "59", "60"), class = "factor"))
  expect_equal(
    xpectr::smpl(hard_to_predict[["Correct"]], n = 30),
    c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(hard_to_predict[["Incorrect"]], n = 30),
    c(3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
      3, 3, 3, 3, 3, 3, 3, 3, 3),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(hard_to_predict[["Accuracy"]], n = 30),
    c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(hard_to_predict[["<="]], n = 30),
    c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(hard_to_predict),
    c("Classifier", "ID", "Correct", "Incorrect", "Accuracy", "<="),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(hard_to_predict),
    c("character", "factor", "integer", "integer", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(hard_to_predict),
    c("character", "integer", "integer", "integer", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(hard_to_predict),
    c(67L, 6L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(hard_to_predict)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'hard_to_predict'                                     ####

  #

  hard_to_predict_perc_non_grouped <- most_challenging(
    predicted.musicians,
    obs_id_col = "ID",
    threshold = 0.30,
    threshold_is = "percentage",
    type = "multinomial"
  )


  ## Testing 'hard_to_predict_perc_non_grouped'                             ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- hard_to_predict_perc_non_grouped
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["ID"]],
    structure(c(1L, 2L, 9L, 25L, 29L, 30L, 37L, 43L, 48L, 51L, 54L,
      58L, 59L, 60L, 7L, 14L, 22L, 27L, 35L, 40L, 52L), .Label = c("1",
      "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13",
      "14", "15", "16", "17", "18", "19", "20", "21", "22", "23",
      "24", "25", "26", "27", "28", "29", "30", "31", "32", "33",
      "34", "35", "36", "37", "38", "39", "40", "41", "42", "43",
      "44", "45", "46", "47", "48", "49", "50", "51", "52", "53",
      "54", "55", "56", "57", "58", "59", "60"), class = "factor"))
  expect_equal(
    output_19148[["Correct"]],
    c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["Incorrect"]],
    c(9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 8, 8, 8, 8, 8, 8, 8),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["Accuracy"]],
    c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.11111, 0.11111, 0.11111,
      0.11111, 0.11111, 0.11111, 0.11111),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["<="]],
    c(0.11111, 0.11111, 0.11111, 0.11111, 0.11111, 0.11111, 0.11111,
      0.11111, 0.11111, 0.11111, 0.11111, 0.11111, 0.11111, 0.11111,
      0.11111, 0.11111, 0.11111, 0.11111, 0.11111, 0.11111, 0.11111),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("ID", "Correct", "Incorrect", "Accuracy", "<="),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("factor", "integer", "integer", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("integer", "integer", "integer", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(21L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'hard_to_predict_perc_non_grouped'                    ####

  #


  hard_to_predict_score_non_grouped <- most_challenging(
    predicted.musicians,
    obs_id_col = "ID",
    threshold = 0.4,
    threshold_is = "score",
    type = "multinomial"
  )


  ## Testing 'hard_to_predict_score_non_grouped'                            ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- hard_to_predict_score_non_grouped
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["ID"]],
    structure(c(1L, 2L, 9L, 25L, 29L, 30L, 37L, 43L, 48L, 51L, 54L,
      58L, 59L, 60L, 7L, 14L, 22L, 27L, 35L, 40L, 52L, 11L, 47L, 4L,
      17L, 44L, 49L, 53L), .Label = c("1", "2", "3", "4", "5", "6",
      "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17",
      "18", "19", "20", "21", "22", "23", "24", "25", "26", "27",
      "28", "29", "30", "31", "32", "33", "34", "35", "36", "37",
      "38", "39", "40", "41", "42", "43", "44", "45", "46", "47",
      "48", "49", "50", "51", "52", "53", "54", "55", "56", "57",
      "58", "59", "60"), class = "factor"))
  expect_equal(
    output_19148[["Correct"]],
    c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1,
      2, 2, 3, 3, 3, 3, 3),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["Incorrect"]],
    c(9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 8, 8, 8, 8, 8, 8, 8,
      7, 7, 6, 6, 6, 6, 6),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["Accuracy"]],
    c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.11111, 0.11111, 0.11111,
      0.11111, 0.11111, 0.11111, 0.11111, 0.22222, 0.22222, 0.33333,
      0.33333, 0.33333, 0.33333, 0.33333),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["<="]],
    c(0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4,
      0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4,
      0.4, 0.4, 0.4),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("ID", "Correct", "Incorrect", "Accuracy", "<="),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("factor", "integer", "integer", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("integer", "integer", "integer", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(28L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'hard_to_predict_score_non_grouped'                   ####

  #

  hard_to_predict_score <- most_challenging(
    predicted.musicians %>% dplyr::group_by(.data$Classifier),
    obs_id_col = "ID",
    threshold = 0.4,
    threshold_is = "score",
    type = "multinomial"
  )


  ## Testing 'hard_to_predict_score'                                        ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(hard_to_predict_score),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    xpectr::smpl(hard_to_predict_score[["Classifier"]], n = 30),
    c("e1071_svm", "e1071_svm", "e1071_svm", "e1071_svm", "e1071_svm",
      "e1071_svm", "e1071_svm", "nnet_multinom", "nnet_multinom",
      "nnet_multinom", "nnet_multinom", "nnet_multinom", "nnet_multinom",
      "nnet_multinom", "nnet_multinom", "nnet_multinom", "nnet_multinom",
      "randomForest", "randomForest", "randomForest", "randomForest",
      "randomForest", "randomForest", "randomForest", "randomForest",
      "randomForest", "randomForest", "randomForest", "randomForest",
      "randomForest"),
    fixed = TRUE)
  expect_equal(
    xpectr::smpl(hard_to_predict_score[["ID"]], n = 30),
    structure(c(22L, 29L, 30L, 37L, 59L, 26L, 50L, 17L, 22L, 24L, 30L,
      44L, 12L, 35L, 39L, 52L, 53L, 1L, 14L, 25L, 29L, 43L, 49L, 50L,
      51L, 60L, 12L, 15L, 40L, 41L), .Label = c("1", "2", "3", "4",
      "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15",
      "16", "17", "18", "19", "20", "21", "22", "23", "24", "25",
      "26", "27", "28", "29", "30", "31", "32", "33", "34", "35",
      "36", "37", "38", "39", "40", "41", "42", "43", "44", "45",
      "46", "47", "48", "49", "50", "51", "52", "53", "54", "55",
      "56", "57", "58", "59", "60"), class = "factor"))
  expect_equal(
    xpectr::smpl(hard_to_predict_score[["Correct"]], n = 30),
    c(0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 1, 1),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(hard_to_predict_score[["Incorrect"]], n = 30),
    c(3, 3, 3, 3, 3, 2, 2, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 3, 3, 3, 3,
      3, 3, 3, 3, 3, 2, 2, 2, 2),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(hard_to_predict_score[["Accuracy"]], n = 30),
    c(0, 0, 0, 0, 0, 0.33333, 0.33333, 0, 0, 0, 0, 0, 0.33333, 0.33333,
      0.33333, 0.33333, 0.33333, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.33333,
      0.33333, 0.33333, 0.33333),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(hard_to_predict_score[["<="]], n = 30),
    c(0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4,
      0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4,
      0.4, 0.4, 0.4, 0.4, 0.4),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(hard_to_predict_score),
    c("Classifier", "ID", "Correct", "Incorrect", "Accuracy", "<="),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(hard_to_predict_score),
    c("character", "factor", "integer", "integer", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(hard_to_predict_score),
    c("character", "integer", "integer", "integer", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(hard_to_predict_score),
    c(97L, 6L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(hard_to_predict_score)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'hard_to_predict_score'                               ####

  #

  ## Passing Predicted Probabilities ####

  hard_to_predict <- most_challenging(
    predicted.musicians %>% dplyr::group_by(.data$Classifier),
    prediction_cols = LETTERS[1:4],
    obs_id_col = "ID",
    threshold = 0.15,
    threshold_is = "percentage",
    type = "multinomial"
  )


  ## Testing 'hard_to_predict'                                              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(hard_to_predict),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    hard_to_predict[["Classifier"]],
    c("e1071_svm", "e1071_svm", "e1071_svm", "e1071_svm", "e1071_svm",
      "e1071_svm", "e1071_svm", "e1071_svm", "e1071_svm", "nnet_multinom",
      "nnet_multinom", "nnet_multinom", "nnet_multinom", "nnet_multinom",
      "nnet_multinom", "nnet_multinom", "nnet_multinom", "nnet_multinom",
      "randomForest", "randomForest", "randomForest", "randomForest",
      "randomForest", "randomForest", "randomForest", "randomForest",
      "randomForest"),
    fixed = TRUE)
  expect_equal(
    hard_to_predict[["ID"]],
    structure(c(9L, 37L, 1L, 40L, 22L, 60L, 51L, 48L, 7L, 9L, 40L, 43L,
      1L, 51L, 48L, 29L, 22L, 7L, 9L, 51L, 60L, 48L, 37L, 30L, 47L,
      16L, 43L), .Label = c("1", "2", "3", "4", "5", "6", "7", "8",
      "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19",
      "20", "21", "22", "23", "24", "25", "26", "27", "28", "29",
      "30", "31", "32", "33", "34", "35", "36", "37", "38", "39",
      "40", "41", "42", "43", "44", "45", "46", "47", "48", "49",
      "50", "51", "52", "53", "54", "55", "56", "57", "58", "59",
      "60"), class = "factor"))
  expect_equal(
    hard_to_predict[["Correct"]],
    c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0),
    tolerance = 1e-4)
  expect_equal(
    hard_to_predict[["Incorrect"]],
    c(3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
      3, 3, 3, 3, 3, 3),
    tolerance = 1e-4)
  expect_equal(
    hard_to_predict[["Accuracy"]],
    c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0),
    tolerance = 1e-4)
  expect_equal(
    hard_to_predict[["MAE"]],
    c(0.94594, 0.82984, 0.82262, 0.82153, 0.80893, 0.79066, 0.78733,
      0.78347, 0.75933, 1, 1, 0.99989, 0.99752, 0.977, 0.97516, 0.96666,
      0.94263, 0.92822, 0.96533, 0.948, 0.86467, 0.86333, 0.854, 0.852,
      0.84533, 0.83467, 0.83067),
    tolerance = 1e-4)
  expect_equal(
    hard_to_predict[["Cross Entropy"]],
    c(2.92738, 1.85437, 1.74839, 1.72566, 1.65783, 1.56549, 1.5627,
      1.53635, 1.4297, 29.41799, 13.24974, 10.31335, 9.85221, 3.93854,
      4.22787, 3.66716, 3.87839, 2.70825, 3.88637, 3.01404, 2.00416,
      1.99424, 1.93933, 1.91605, 1.86888, 1.83304, 1.77887),
    tolerance = 1e-4)
  expect_equal(
    hard_to_predict[["<="]],
    c(0.75263, 0.75263, 0.75263, 0.75263, 0.75263, 0.75263, 0.75263,
      0.75263, 0.75263, 0.91878, 0.91878, 0.91878, 0.91878, 0.91878,
      0.91878, 0.91878, 0.91878, 0.91878, 0.82443, 0.82443, 0.82443,
      0.82443, 0.82443, 0.82443, 0.82443, 0.82443, 0.82443),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(hard_to_predict),
    c("Classifier", "ID", "Correct", "Incorrect", "Accuracy", "MAE",
      "Cross Entropy", "<="),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(hard_to_predict),
    c("character", "factor", "integer", "integer", "numeric", "numeric",
      "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(hard_to_predict),
    c("character", "integer", "integer", "integer", "double", "double",
      "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(hard_to_predict),
    c(27L, 8L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(hard_to_predict)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'hard_to_predict'                                     ####

  #

  hard_to_predict_score <- most_challenging(
    predicted.musicians %>% dplyr::group_by(.data$Classifier),
    prediction_cols = LETTERS[1:4],
    obs_id_col = "ID",
    threshold = 0.4,
    threshold_is = "score",
    type = "multinomial"
  )


  ## Testing 'hard_to_predict_score'                                        ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(hard_to_predict_score),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    xpectr::smpl(hard_to_predict_score[["Classifier"]], n = 30),
    c("e1071_svm", "e1071_svm", "e1071_svm", "e1071_svm", "e1071_svm",
      "e1071_svm", "e1071_svm", "e1071_svm", "nnet_multinom", "nnet_multinom",
      "nnet_multinom", "nnet_multinom", "nnet_multinom", "nnet_multinom",
      "randomForest", "randomForest", "randomForest", "randomForest",
      "randomForest", "randomForest", "randomForest", "randomForest",
      "randomForest", "randomForest", "randomForest", "randomForest",
      "randomForest", "randomForest", "randomForest", "randomForest"),
    fixed = TRUE)
  expect_equal(
    xpectr::smpl(hard_to_predict_score[["ID"]], n = 30),
    structure(c(19L, 29L, 2L, 58L, 5L, 12L, 38L, 23L, 1L, 51L, 59L,
      44L, 8L, 16L, 37L, 30L, 49L, 7L, 15L, 50L, 25L, 8L, 36L, 34L,
      4L, 18L, 28L, 45L, 26L, 38L), .Label = c("1", "2", "3", "4",
      "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15",
      "16", "17", "18", "19", "20", "21", "22", "23", "24", "25",
      "26", "27", "28", "29", "30", "31", "32", "33", "34", "35",
      "36", "37", "38", "39", "40", "41", "42", "43", "44", "45",
      "46", "47", "48", "49", "50", "51", "52", "53", "54", "55",
      "56", "57", "58", "59", "60"), class = "factor"))
  expect_equal(
    xpectr::smpl(hard_to_predict_score[["Correct"]], n = 30),
    c(1, 0, 0, 0, 2, 3, 3, 3, 0, 0, 0, 0, 3, 3, 0, 0, 0, 1, 1, 0, 0,
      2, 2, 2, 2, 2, 3, 1, 2, 3),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(hard_to_predict_score[["Incorrect"]], n = 30),
    c(2, 3, 3, 3, 1, 0, 0, 0, 3, 3, 3, 3, 0, 0, 3, 3, 3, 2, 2, 3, 3,
      1, 1, 1, 1, 1, 0, 2, 1, 0),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(hard_to_predict_score[["Accuracy"]], n = 30),
    c(0.33333, 0, 0, 0, 0.66667, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0,
      0.33333, 0.33333, 0, 0, 0.66667, 0.66667, 0.66667, 0.66667,
      0.66667, 1, 0.33333, 0.66667, 1),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(hard_to_predict_score[["MAE"]], n = 30),
    c(0.74991, 0.72536, 0.70442, 0.6972, 0.65199, 0.62003, 0.55553,
      0.49974, 0.99752, 0.977, 0.87302, 0.84898, 0.48694, 0.46852,
      0.854, 0.852, 0.81667, 0.74667, 0.712, 0.68667, 0.67933, 0.642,
      0.638, 0.60267, 0.56467, 0.55, 0.52667, 0.522, 0.51533, 0.43133),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(hard_to_predict_score[["Cross Entropy"]], n = 30),
    c(1.39933, 1.29344, 1.21968, 1.19635, 1.0647, 0.97335, 0.81611,
      0.7133, 9.85221, 3.93854, 2.30786, 6.29381, 0.67218, 0.63556,
      1.93933, 1.91605, 1.71861, 1.4243, 1.30075, 1.16899, 1.13882,
      1.04058, 1.02566, 0.92832, 0.83835, 0.82444, 0.74899, 0.75197,
      0.74688, 0.56473),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(hard_to_predict_score[["<="]], n = 30),
    c(0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4,
      0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4,
      0.4, 0.4, 0.4, 0.4, 0.4),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(hard_to_predict_score),
    c("Classifier", "ID", "Correct", "Incorrect", "Accuracy", "MAE",
      "Cross Entropy", "<="),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(hard_to_predict_score),
    c("character", "factor", "integer", "integer", "numeric", "numeric",
      "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(hard_to_predict_score),
    c("character", "integer", "integer", "integer", "double", "double",
      "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(hard_to_predict_score),
    c(151L, 8L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(hard_to_predict_score)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'hard_to_predict_score'                               ####

  #

  hard_to_predict_perc_non_grouped <- most_challenging(
    predicted.musicians,
    prediction_cols = LETTERS[1:4],
    obs_id_col = "ID",
    threshold = 0.30,
    threshold_is = "percentage",
    type = "multinomial"
  )


  ## Testing 'hard_to_predict_perc_non_grouped'                             ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- hard_to_predict_perc_non_grouped
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["ID"]],
    structure(c(9L, 51L, 48L, 37L, 43L, 1L, 40L, 60L, 22L, 30L, 54L,
      29L, 7L, 59L, 27L, 53L, 2L, 47L), .Label = c("1", "2", "3",
      "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14",
      "15", "16", "17", "18", "19", "20", "21", "22", "23", "24",
      "25", "26", "27", "28", "29", "30", "31", "32", "33", "34",
      "35", "36", "37", "38", "39", "40", "41", "42", "43", "44",
      "45", "46", "47", "48", "49", "50", "51", "52", "53", "54",
      "55", "56", "57", "58", "59", "60"), class = "factor"))
  expect_equal(
    output_19148[["Correct"]],
    c(0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 3, 0, 2),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["Incorrect"]],
    c(9, 9, 9, 9, 9, 9, 8, 9, 8, 9, 9, 9, 8, 9, 8, 6, 9, 7),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["Accuracy"]],
    c(0, 0, 0, 0, 0, 0, 0.11111, 0, 0.11111, 0, 0, 0, 0.11111, 0, 0.11111,
      0.33333, 0, 0.22222),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["MAE"]],
    c(0.97042, 0.90411, 0.87398, 0.86699, 0.85718, 0.85627, 0.84629,
      0.84515, 0.83652, 0.82492, 0.81319, 0.81289, 0.8114, 0.80677,
      0.75614, 0.75145, 0.74976, 0.74795),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["Cross Entropy"]],
    c(12.077248, 2.83842, 2.58615, 2.66749, 4.49846, 4.34966, 5.41373,
      1.90328, 2.32275, 1.85526, 1.87409, 2.11388, 1.85408, 1.78562,
      1.52919, 1.5334, 1.45651, 1.50169),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["<="]],
    c(0.74787, 0.74787, 0.74787, 0.74787, 0.74787, 0.74787, 0.74787,
      0.74787, 0.74787, 0.74787, 0.74787, 0.74787, 0.74787, 0.74787,
      0.74787, 0.74787, 0.74787, 0.74787),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("ID", "Correct", "Incorrect", "Accuracy", "MAE", "Cross Entropy",
      "<="),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("factor", "integer", "integer", "numeric", "numeric", "numeric",
      "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("integer", "integer", "integer", "double", "double", "double",
      "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(18L, 7L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'hard_to_predict_perc_non_grouped'                    ####

  #

  hard_to_predict_score_non_grouped <- most_challenging(
    predicted.musicians,
    prediction_cols = LETTERS[1:4],
    obs_id_col = "ID",
    threshold = 0.4,
    threshold_is = "score",
    type = "multinomial"
  )


  ## Testing 'hard_to_predict_score_non_grouped'                            ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- hard_to_predict_score_non_grouped
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    xpectr::smpl(output_19148[["ID"]], n = 30),
    structure(c(51L, 37L, 1L, 22L, 29L, 7L, 59L, 53L, 2L, 52L, 39L,
      44L, 11L, 16L, 19L, 4L, 14L, 12L, 17L, 49L, 8L, 24L, 36L, 20L,
      5L, 15L, 31L, 26L, 34L, 38L), .Label = c("1", "2", "3", "4",
      "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15",
      "16", "17", "18", "19", "20", "21", "22", "23", "24", "25",
      "26", "27", "28", "29", "30", "31", "32", "33", "34", "35",
      "36", "37", "38", "39", "40", "41", "42", "43", "44", "45",
      "46", "47", "48", "49", "50", "51", "52", "53", "54", "55",
      "56", "57", "58", "59", "60"), class = "factor"))
  expect_equal(
    xpectr::smpl(output_19148[["Correct"]], n = 30),
    c(0, 0, 0, 1, 0, 1, 0, 3, 0, 1, 6, 3, 2, 6, 4, 3, 1, 5, 3, 3, 7,
      5, 6, 5, 6, 7, 8, 6, 8, 9),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_19148[["Incorrect"]], n = 30),
    c(9, 9, 9, 8, 9, 8, 9, 6, 9, 8, 3, 6, 7, 3, 5, 6, 8, 4, 6, 6, 2,
      4, 3, 4, 3, 2, 1, 3, 1, 0),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_19148[["Accuracy"]], n = 30),
    c(0, 0, 0, 0.11111, 0, 0.11111, 0, 0.33333, 0, 0.11111, 0.66667,
      0.33333, 0.22222, 0.66667, 0.44444, 0.33333, 0.11111, 0.55556,
      0.33333, 0.33333, 0.77778, 0.55556, 0.66667, 0.55556, 0.66667,
      0.77778, 0.88889, 0.66667, 0.88889, 1),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_19148[["MAE"]], n = 30),
    c(0.90411, 0.86699, 0.85627, 0.83652, 0.81289, 0.8114, 0.80677,
      0.75145, 0.74976, 0.74784, 0.71534, 0.71224, 0.70637, 0.66505,
      0.65404, 0.64442, 0.64079, 0.63437, 0.61959, 0.61227, 0.60506,
      0.59498, 0.59076, 0.57244, 0.5412, 0.53106, 0.51219, 0.48922,
      0.46877, 0.41346),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_19148[["Cross Entropy"]], n = 30),
    c(2.83842, 2.66749, 4.34966, 2.32275, 2.11388, 1.85408, 1.78562,
      1.5334, 1.45651, 1.41654, 2.78017, 2.80152, 1.28184, 1.21538,
      1.1141, 1.10637, 1.03592, 1.21712, 1.00873, 1.10823, 0.95958,
      0.93607, 1.01602, 0.93509, 0.89446, 0.86248, 0.76559, 0.73508,
      0.68229, 0.55837),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_19148[["<="]], n = 30),
    c(0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4,
      0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4,
      0.4, 0.4, 0.4, 0.4, 0.4),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("ID", "Correct", "Incorrect", "Accuracy", "MAE", "Cross Entropy",
      "<="),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("factor", "integer", "integer", "numeric", "numeric", "numeric",
      "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("integer", "integer", "integer", "double", "double", "double",
      "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(47L, 7L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'hard_to_predict_score_non_grouped'                   ####

  #

})

test_that("gaussian model works with most_challenging()", {

  # TODO Save the data and cross-validation to disk
  # So we save time and can run on CRAN
  testthat::skip_on_cran()

  # Load data and fold it
  xpectr::set_test_seed(1)
  dat_ready <- participant.scores %>%
    dplyr::mutate(diagnosis = as.factor(diagnosis))
  dat_list <- groupdata2::fold(dat_ready,
    k = 4,
    num_fold_cols = 8,
    cat_col = "diagnosis",
    id_col = "participant"
  )

  CV_gauss <- cross_validate(
    dat_list,
    formulas = c(
      "score ~ diagnosis + session",
      "score ~ diagnosis + age + session"
    ),
    fold_cols = paste0(".folds_", 1:8),
    family = "gaussian"
  )

  collected_preds <- dplyr::bind_rows(CV_gauss$Predictions, .id = "Model") %>%
    dplyr::group_by(.data$Model)

  hard_to_predict_perc <- most_challenging(collected_preds,
    type = "gaussian",
    threshold = 0.2, threshold_is = "percentage"
  )

  ## Testing 'hard_to_predict_perc'                                         ####
  ## Initially generated by xpectr
  # Testing class
  expect_equal(
    class(hard_to_predict_perc),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    hard_to_predict_perc[["Model"]],
    c("1", "1", "1", "1", "1", "1", "2", "2", "2", "2", "2", "2"),
    fixed = TRUE)
  expect_equal(
    hard_to_predict_perc[["Observation"]],
    c(20, 24, 21, 3, 5, 19, 20, 24, 21, 27, 3, 9),
    tolerance = 1e-4)
  expect_equal(
    hard_to_predict_perc[["MAE"]],
    c(26.61042, 20.93735, 18.2131, 14.77034, 13.33333, 13.00774, 26.76931,
      21.74228, 18.37199, 13.48558, 13.89225, 13.74331),
    tolerance = 1e-4)
  expect_equal(
    hard_to_predict_perc[["RMSE"]],
    c(26.61253, 20.95156, 18.22234, 14.78232, 13.33333, 13.01421,
      26.77572, 21.78456, 18.39316, 14.71466, 13.953, 13.82658),
    tolerance = 1e-4)
  expect_equal(
    hard_to_predict_perc[[">="]],
    c(12.61127, 12.61127, 12.61127, 12.61127, 12.61127, 12.61127,
      13.30434, 13.30434, 13.30434, 13.30434, 13.30434, 13.30434),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(hard_to_predict_perc),
    c("Model", "Observation", "MAE", "RMSE", ">="),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(hard_to_predict_perc),
    c("character", "integer", "numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(hard_to_predict_perc),
    c("character", "integer", "double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(hard_to_predict_perc),
    c(12L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(hard_to_predict_perc)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'hard_to_predict_perc'                                ####

  hard_to_predict_score <- most_challenging(collected_preds,
    type = "gaussian",
    threshold = 13.9, threshold_is = "score"
  )

  ## Testing 'hard_to_predict_score'                                        ####
  ## Initially generated by xpectr
  # Testing class
  expect_equal(
    class(hard_to_predict_score),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    hard_to_predict_score[["Model"]],
    c("1", "1", "1", "1", "2", "2", "2", "2", "2"),
    fixed = TRUE)
  expect_equal(
    hard_to_predict_score[["Observation"]],
    c(20, 24, 21, 3, 20, 24, 21, 27, 3),
    tolerance = 1e-4)
  expect_equal(
    hard_to_predict_score[["MAE"]],
    c(26.61042, 20.93735, 18.2131, 14.77034, 26.76931, 21.74228, 18.37199,
      13.48558, 13.89225),
    tolerance = 1e-4)
  expect_equal(
    hard_to_predict_score[["RMSE"]],
    c(26.61253, 20.95156, 18.22234, 14.78232, 26.77572, 21.78456,
      18.39316, 14.71466, 13.953),
    tolerance = 1e-4)
  expect_equal(
    hard_to_predict_score[[">="]],
    c(13.9, 13.9, 13.9, 13.9, 13.9, 13.9, 13.9, 13.9, 13.9),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(hard_to_predict_score),
    c("Model", "Observation", "MAE", "RMSE", ">="),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(hard_to_predict_score),
    c("character", "integer", "numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(hard_to_predict_score),
    c("character", "integer", "double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(hard_to_predict_score),
    c(9L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(hard_to_predict_score)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'hard_to_predict_score'                               ####

})

test_that("exceeds_threshold() works", {

  df <- data.frame(
    "Grp" = rep(c(1,2), each = 5),
    "Observation" = rep(c(1,2,3,4,5), 2),
    "SomeMetric" = c(0.2,0.4,0.6,0.8,0.9,
                     0.3,0.2,0.1,0.8,0.7)
  )

  # xpectr::gxs_function(fn = exceeds_threshold,
  #                      args_values = list(
  #                        "data" = list(df, dplyr::group_by(df,.data$Grp), NA, list("a" = 3)),
  #                        "threshold" = list(0.3, 1, 0, NA, c(0.2, 0.4)),
  #                        "threshold_is" = list("percentage", "score", "hei", NA),
  #                        "metric_name" = list("SomeMetric", "no", NA, 3),
  #                        "maximize" = list(TRUE, FALSE, NA, 1, "TRUE"),
  #                        "grouping_keys" = c(data.frame(),
  #                                            dplyr::group_keys(dplyr::group_by(df,.data$Grp)),
  #                                            NA)
  #                      ))

  ## Testing 'exceeds_threshold'                                              ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing exceeds_threshold(data = dplyr::group_by(df, ....
  # Testing side effects
  expect_error(
    xpectr::strip_msg(exceeds_threshold(data = dplyr::group_by(df, .data$Grp), threshold = 0.3, threshold_is = "percentage", metric_name = "SomeMetric", maximize = TRUE, grouping_keys = data.frame())),
    xpectr::strip("1 assertions failed:\n * 'data' cannot be grouped at this stage."),
    fixed = TRUE)

  # Testing exceeds_threshold(data = df, threshold = 0.3, ...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(exceeds_threshold(data = df, threshold = 0.3, threshold_is = NA, metric_name = "SomeMetric", maximize = TRUE, grouping_keys = data.frame())),
    xpectr::strip(paste0("1 assertions failed:\n * Variable 'threshold_is': Must be el",
           "ement of set {'percentage','score'}, but is 'NA'.")),
    fixed = TRUE)

  # Testing exceeds_threshold(data = df, threshold = 0.3, ...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(exceeds_threshold(data = df, threshold = 0.3, threshold_is = "percentage", metric_name = "no", maximize = TRUE, grouping_keys = data.frame())),
    xpectr::strip(paste0("1 assertions failed:\n * Variable 'colnames(data)': Must inc",
           "lude the elements {no}.")),
    fixed = TRUE)

  # Testing exceeds_threshold(data = df, threshold = 0.3, ...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(exceeds_threshold(data = df, threshold = 0.3, threshold_is = "percentage", metric_name = NA, maximize = TRUE, grouping_keys = data.frame())),
    xpectr::strip(paste0("Assertion on 'must.include' failed. May not contain missing ",
           "values, first at position 1.")),
    fixed = TRUE)

  # Testing exceeds_threshold(data = df, threshold = 0.3, ...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(exceeds_threshold(data = df, threshold = 0.3, threshold_is = "percentage", metric_name = 3, maximize = TRUE, grouping_keys = data.frame())),
    xpectr::strip(paste0("1 assertions failed:\n * Variable 'colnames(data)': Must inc",
           "lude the elements {3}.")),
    fixed = TRUE)

  # Testing exceeds_threshold(data = df, threshold = 0.3, ...
  # Assigning output
  output_14346 <- exceeds_threshold(data = df, threshold = 0.3, threshold_is = "percentage", metric_name = "SomeMetric", maximize = FALSE, grouping_keys = data.frame())
  # Testing class
  expect_equal(
    class(output_14346),
    "data.frame",
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_14346[["Grp"]],
    c(1, 1, 2),
    tolerance = 1e-4)
  expect_equal(
    output_14346[["Observation"]],
    c(4, 5, 4),
    tolerance = 1e-4)
  expect_equal(
    output_14346[["SomeMetric"]],
    c(0.8, 0.9, 0.8),
    tolerance = 1e-4)
  expect_equal(
    output_14346[["Threshold"]],
    c(0.73, 0.73, 0.73),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_14346),
    c("Grp", "Observation", "SomeMetric", "Threshold"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_14346),
    c("numeric", "numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_14346),
    c("double", "double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_14346),
    3:4)
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_14346)),
    character(0),
    fixed = TRUE)

  # Testing exceeds_threshold(data = df, threshold = 0.3, ...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(exceeds_threshold(data = df, threshold = 0.3, threshold_is = "percentage", metric_name = "SomeMetric", maximize = NA, grouping_keys = data.frame())),
    xpectr::strip("1 assertions failed:\n * Variable 'maximize': May not be NA."),
    fixed = TRUE)

  # Testing exceeds_threshold(data = df, threshold = 0.3, ...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(exceeds_threshold(data = df, threshold = 0.3, threshold_is = "percentage", metric_name = "SomeMetric", maximize = 1, grouping_keys = data.frame())),
    xpectr::strip(paste0("1 assertions failed:\n * Variable 'maximize': Must be of typ",
           "e 'logical flag', not 'double'.")),
    fixed = TRUE)

  # Testing exceeds_threshold(data = df, threshold = 0.3, ...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(exceeds_threshold(data = df, threshold = 0.3, threshold_is = "percentage", metric_name = "SomeMetric", maximize = "TRUE", grouping_keys = data.frame())),
    xpectr::strip(paste0("1 assertions failed:\n * Variable 'maximize': Must be of typ",
           "e 'logical flag', not 'character'.")),
    fixed = TRUE)

  # Testing exceeds_threshold(data = df, threshold = 0.3, ...
  # Assigning output
  output_17124 <- exceeds_threshold(data = df, threshold = 0.3, threshold_is = "percentage", metric_name = "SomeMetric", maximize = TRUE, grouping_keys = dplyr::group_keys(dplyr::group_by(df, .data$Grp)))
  # Testing class
  expect_equal(
    class(output_17124),
    "data.frame",
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_17124[["Grp"]],
    c(1, 1, 2, 2),
    tolerance = 1e-4)
  expect_equal(
    output_17124[["Observation"]],
    c(1, 2, 2, 3),
    tolerance = 1e-4)
  expect_equal(
    output_17124[["SomeMetric"]],
    c(0.2, 0.4, 0.2, 0.1),
    tolerance = 1e-4)
  expect_equal(
    output_17124[["Threshold"]],
    c(0.44, 0.44, 0.22, 0.22),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_17124),
    c("Grp", "Observation", "SomeMetric", "Threshold"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_17124),
    c("numeric", "numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_17124),
    c("double", "double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17124),
    c(4L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_17124)),
    character(0),
    fixed = TRUE)

  # Testing exceeds_threshold(data = df, threshold = 0.3, ...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(exceeds_threshold(data = df, threshold = 0.3, threshold_is = "percentage", metric_name = "SomeMetric", maximize = TRUE, grouping_keys = NA)),
    xpectr::strip(paste0("1 assertions failed:\n * Variable 'grouping_keys': Must be o",
           "f type 'data.frame', not 'logical'.")),
    fixed = TRUE)

  # Testing exceeds_threshold(data = NA, threshold = 0.3, ...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(exceeds_threshold(data = NA, threshold = 0.3, threshold_is = "percentage", metric_name = "SomeMetric", maximize = TRUE, grouping_keys = data.frame())),
    xpectr::strip(paste0("1 assertions failed:\n * Variable 'data': Must be of type 'd",
           "ata.frame', not 'logical'.")),
    fixed = TRUE)

  # Testing exceeds_threshold(data = list(a = 3), threshol...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(exceeds_threshold(data = list(a = 3), threshold = 0.3, threshold_is = "percentage", metric_name = "SomeMetric", maximize = TRUE, grouping_keys = data.frame())),
    xpectr::strip(paste0("1 assertions failed:\n * Variable 'data': Must be of type 'd",
           "ata.frame', not 'list'.")),
    fixed = TRUE)

  # Testing exceeds_threshold(data = df, threshold = 1, th...
  # Assigning output
  output_13999 <- exceeds_threshold(data = df, threshold = 1, threshold_is = "percentage", metric_name = "SomeMetric", maximize = TRUE, grouping_keys = data.frame())
  # Testing class
  expect_equal(
    class(output_13999),
    "data.frame",
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_13999[["Grp"]],
    c(1, 1, 1, 1, 1, 2, 2, 2, 2, 2),
    tolerance = 1e-4)
  expect_equal(
    output_13999[["Observation"]],
    c(1, 2, 3, 4, 5, 1, 2, 3, 4, 5),
    tolerance = 1e-4)
  expect_equal(
    output_13999[["SomeMetric"]],
    c(0.2, 0.4, 0.6, 0.8, 0.9, 0.3, 0.2, 0.1, 0.8, 0.7),
    tolerance = 1e-4)
  expect_equal(
    output_13999[["Threshold"]],
    c(0.9, 0.9, 0.9, 0.9, 0.9, 0.9, 0.9, 0.9, 0.9, 0.9),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_13999),
    c("Grp", "Observation", "SomeMetric", "Threshold"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_13999),
    c("numeric", "numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_13999),
    c("double", "double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_13999),
    c(10L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_13999)),
    character(0),
    fixed = TRUE)

  # Testing exceeds_threshold(data = df, threshold = 0, th...
  # Assigning output
  output_13253 <- exceeds_threshold(data = df, threshold = 0, threshold_is = "percentage", metric_name = "SomeMetric", maximize = TRUE, grouping_keys = data.frame())
  # Testing class
  expect_equal(
    class(output_13253),
    "data.frame",
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_13253[["Grp"]],
    2,
    tolerance = 1e-4)
  expect_equal(
    output_13253[["Observation"]],
    3,
    tolerance = 1e-4)
  expect_equal(
    output_13253[["SomeMetric"]],
    0.1,
    tolerance = 1e-4)
  expect_equal(
    output_13253[["Threshold"]],
    0.1,
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_13253),
    c("Grp", "Observation", "SomeMetric", "Threshold"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_13253),
    c("numeric", "numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_13253),
    c("double", "double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_13253),
    c(1L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_13253)),
    character(0),
    fixed = TRUE)

  # Testing exceeds_threshold(data = df, threshold = NA, t...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(exceeds_threshold(data = df, threshold = NA, threshold_is = "percentage", metric_name = "SomeMetric", maximize = TRUE, grouping_keys = data.frame())),
    xpectr::strip("1 assertions failed:\n * Variable 'threshold': May not be NA."),
    fixed = TRUE)

  # Testing exceeds_threshold(data = df, threshold = c(0.2...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(exceeds_threshold(data = df, threshold = c(0.2, 0.4), threshold_is = "percentage", metric_name = "SomeMetric", maximize = TRUE, grouping_keys = data.frame())),
    xpectr::strip("1 assertions failed:\n * Variable 'threshold': Must have length 1."),
    fixed = TRUE)

  # Testing exceeds_threshold(data = df, threshold = 0.3, ...
  # Assigning output
  output_17570 <- exceeds_threshold(data = df, threshold = 0.3, threshold_is = "score", metric_name = "SomeMetric", maximize = TRUE, grouping_keys = data.frame())
  # Testing class
  expect_equal(
    class(output_17570),
    "data.frame",
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_17570[["Grp"]],
    c(1, 2, 2, 2),
    tolerance = 1e-4)
  expect_equal(
    output_17570[["Observation"]],
    c(1, 1, 2, 3),
    tolerance = 1e-4)
  expect_equal(
    output_17570[["SomeMetric"]],
    c(0.2, 0.3, 0.2, 0.1),
    tolerance = 1e-4)
  expect_equal(
    output_17570[["Threshold"]],
    c(0.3, 0.3, 0.3, 0.3),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_17570),
    c("Grp", "Observation", "SomeMetric", "Threshold"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_17570),
    c("numeric", "numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_17570),
    c("double", "double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17570),
    c(4L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_17570)),
    character(0),
    fixed = TRUE)

  # Testing exceeds_threshold(data = df, threshold = 0.3, ...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(exceeds_threshold(data = df, threshold = 0.3, threshold_is = "hei", metric_name = "SomeMetric", maximize = TRUE, grouping_keys = data.frame())),
    xpectr::strip(paste0("1 assertions failed:\n * Variable 'threshold_is': Must be el",
           "ement of set {'percentage','score'}, but is 'hei'.")),
    fixed = TRUE)

  # Testing exceeds_threshold(data = NULL, threshold = 0.3...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(exceeds_threshold(data = NULL, threshold = 0.3, threshold_is = "percentage", metric_name = "SomeMetric", maximize = TRUE, grouping_keys = data.frame())),
    xpectr::strip(paste0("1 assertions failed:\n * Variable 'data': Must be of type 'd",
           "ata.frame', not 'NULL'.")),
    fixed = TRUE)

  # Testing exceeds_threshold(data = df, threshold = 0.3, ...
  # Assigning output
  output_12026 <- exceeds_threshold(data = df, threshold = 0.3, threshold_is = "percentage", metric_name = "SomeMetric", maximize = TRUE, grouping_keys = data.frame())
  # Testing class
  expect_equal(
    class(output_12026),
    "data.frame",
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_12026[["Grp"]],
    c(1, 2, 2),
    tolerance = 1e-4)
  expect_equal(
    output_12026[["Observation"]],
    c(1, 2, 3),
    tolerance = 1e-4)
  expect_equal(
    output_12026[["SomeMetric"]],
    c(0.2, 0.2, 0.1),
    tolerance = 1e-4)
  expect_equal(
    output_12026[["Threshold"]],
    c(0.27, 0.27, 0.27),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_12026),
    c("Grp", "Observation", "SomeMetric", "Threshold"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_12026),
    c("numeric", "numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_12026),
    c("double", "double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_12026),
    3:4)
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_12026)),
    character(0),
    fixed = TRUE)

  # Testing exceeds_threshold(data = df, threshold = 0.3, ...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(exceeds_threshold(data = df, threshold = 0.3, threshold_is = "percentage", metric_name = "SomeMetric", maximize = TRUE, grouping_keys = NULL)),
    xpectr::strip(paste0("1 assertions failed:\n * Variable 'grouping_keys': Must be o",
           "f type 'data.frame', not 'NULL'.")),
    fixed = TRUE)

  # Testing exceeds_threshold(data = df, threshold = 0.3, ...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(exceeds_threshold(data = df, threshold = 0.3, threshold_is = "percentage", metric_name = "SomeMetric", maximize = NULL, grouping_keys = data.frame())),
    xpectr::strip(paste0("1 assertions failed:\n * Variable 'maximize': Must be of typ",
           "e 'logical flag', not 'NULL'.")),
    fixed = TRUE)

  # Testing exceeds_threshold(data = df, threshold = 0.3, ...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(exceeds_threshold(data = df, threshold = 0.3, threshold_is = "percentage", metric_name = NULL, maximize = TRUE, grouping_keys = data.frame())),
    xpectr::strip("invalid type/length (symbol/0) in vector allocation"),
    fixed = TRUE)

  # Testing exceeds_threshold(data = df, threshold = NULL,...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(exceeds_threshold(data = df, threshold = NULL, threshold_is = "percentage", metric_name = "SomeMetric", maximize = TRUE, grouping_keys = data.frame())),
    xpectr::strip(paste0("1 assertions failed:\n * Variable 'threshold': Must be of ty",
           "pe 'number', not 'NULL'.")),
    fixed = TRUE)

  # Testing exceeds_threshold(data = df, threshold = 0.3, ...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(exceeds_threshold(data = df, threshold = 0.3, threshold_is = NULL, metric_name = "SomeMetric", maximize = TRUE, grouping_keys = data.frame())),
    xpectr::strip(paste0("1 assertions failed:\n * Variable 'threshold_is': Must be a ",
           "subset of {'percentage','score'}, not 'NULL'.")),
    fixed = TRUE)

  ## Finished testing 'exceeds_threshold'                                     ####


  # Now with 'score' as baseline

  # xpectr::gxs_function(fn = exceeds_threshold,
  #                      args_values = list(
  #                        "data" = list(df, dplyr::group_by(df,.data$Grp), NA, list("a" = 3)),
  #                        "threshold" = list(7, 1, 0, NA, c(0.2, 0.4)),
  #                        "threshold_is" = list("score"),
  #                        "metric_name" = list("SomeMetric", "no", NA, 3),
  #                        "maximize" = list(TRUE, FALSE, NA, 1, "TRUE"),
  #                        "grouping_keys" = c(data.frame(),
  #                                            dplyr::group_keys(dplyr::group_by(df,.data$Grp)),
  #                                            NA)
  #                      ))

  ## Testing 'exceeds_threshold'                                              ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing exceeds_threshold(data = dplyr::group_by(df, ....
  # Testing side effects
  expect_error(
    xpectr::strip_msg(exceeds_threshold(data = dplyr::group_by(df, .data$Grp), threshold = 7, threshold_is = "score", metric_name = "SomeMetric", maximize = TRUE, grouping_keys = data.frame())),
    xpectr::strip("1 assertions failed:\n * 'data' cannot be grouped at this stage."),
    fixed = TRUE)

  # Testing exceeds_threshold(data = df, threshold = 7, th...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(exceeds_threshold(data = df, threshold = 7, threshold_is = "score", metric_name = 3, maximize = TRUE, grouping_keys = data.frame())),
    xpectr::strip(paste0("1 assertions failed:\n * Variable 'colnames(data)': Must inc",
           "lude the elements {3}.")),
    fixed = TRUE)

  # Testing exceeds_threshold(data = df, threshold = 7, th...
  # Assigning output
  output_17110 <- exceeds_threshold(data = df, threshold = 7, threshold_is = "score", metric_name = "SomeMetric", maximize = FALSE, grouping_keys = data.frame())
  # Testing class
  expect_equal(
    class(output_17110),
    "data.frame",
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_17110[["Grp"]],
    numeric(0),
    tolerance = 1e-4)
  expect_equal(
    output_17110[["Observation"]],
    numeric(0),
    tolerance = 1e-4)
  expect_equal(
    output_17110[["SomeMetric"]],
    numeric(0),
    tolerance = 1e-4)
  expect_equal(
    output_17110[["Threshold"]],
    numeric(0),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_17110),
    c("Grp", "Observation", "SomeMetric", "Threshold"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_17110),
    c("numeric", "numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_17110),
    c("double", "double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17110),
    c(0L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_17110)),
    character(0),
    fixed = TRUE)

  # Testing exceeds_threshold(data = df, threshold = 7, th...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(exceeds_threshold(data = df, threshold = 7, threshold_is = "score", metric_name = "SomeMetric", maximize = NA, grouping_keys = data.frame())),
    xpectr::strip("1 assertions failed:\n * Variable 'maximize': May not be NA."),
    fixed = TRUE)

  # Testing exceeds_threshold(data = df, threshold = 7, th...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(exceeds_threshold(data = df, threshold = 7, threshold_is = "score", metric_name = "SomeMetric", maximize = 1, grouping_keys = data.frame())),
    xpectr::strip(paste0("1 assertions failed:\n * Variable 'maximize': Must be of typ",
           "e 'logical flag', not 'double'.")),
    fixed = TRUE)

  # Testing exceeds_threshold(data = df, threshold = 7, th...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(exceeds_threshold(data = df, threshold = 7, threshold_is = "score", metric_name = "SomeMetric", maximize = "TRUE", grouping_keys = data.frame())),
    xpectr::strip(paste0("1 assertions failed:\n * Variable 'maximize': Must be of typ",
           "e 'logical flag', not 'character'.")),
    fixed = TRUE)

  # Testing exceeds_threshold(data = df, threshold = 7, th...
  # Assigning output
  output_11216 <- exceeds_threshold(data = df, threshold = 7, threshold_is = "score", metric_name = "SomeMetric", maximize = TRUE, grouping_keys = dplyr::group_keys(dplyr::group_by(df, .data$Grp)))
  # Testing class
  expect_equal(
    class(output_11216),
    "data.frame",
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_11216[["Grp"]],
    c(1, 1, 1, 1, 1, 2, 2, 2, 2, 2),
    tolerance = 1e-4)
  expect_equal(
    output_11216[["Observation"]],
    c(1, 2, 3, 4, 5, 1, 2, 3, 4, 5),
    tolerance = 1e-4)
  expect_equal(
    output_11216[["SomeMetric"]],
    c(0.2, 0.4, 0.6, 0.8, 0.9, 0.3, 0.2, 0.1, 0.8, 0.7),
    tolerance = 1e-4)
  expect_equal(
    output_11216[["Threshold"]],
    c(7, 7, 7, 7, 7, 7, 7, 7, 7, 7),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_11216),
    c("Grp", "Observation", "SomeMetric", "Threshold"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_11216),
    c("numeric", "numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_11216),
    c("double", "double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_11216),
    c(10L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_11216)),
    character(0),
    fixed = TRUE)

  # Testing exceeds_threshold(data = df, threshold = 7, th...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(exceeds_threshold(data = df, threshold = 7, threshold_is = "score", metric_name = "SomeMetric", maximize = TRUE, grouping_keys = NA)),
    xpectr::strip(paste0("1 assertions failed:\n * Variable 'grouping_keys': Must be o",
           "f type 'data.frame', not 'logical'.")),
    fixed = TRUE)

  # Testing exceeds_threshold(data = NA, threshold = 7, th...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(exceeds_threshold(data = NA, threshold = 7, threshold_is = "score", metric_name = "SomeMetric", maximize = TRUE, grouping_keys = data.frame())),
    xpectr::strip(paste0("1 assertions failed:\n * Variable 'data': Must be of type 'd",
           "ata.frame', not 'logical'.")),
    fixed = TRUE)

  # Testing exceeds_threshold(data = list(a = 3), threshol...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(exceeds_threshold(data = list(a = 3), threshold = 7, threshold_is = "score", metric_name = "SomeMetric", maximize = TRUE, grouping_keys = data.frame())),
    xpectr::strip(paste0("1 assertions failed:\n * Variable 'data': Must be of type 'd",
           "ata.frame', not 'list'.")),
    fixed = TRUE)

  # Testing exceeds_threshold(data = df, threshold = 1, th...
  # Assigning output
  output_12454 <- exceeds_threshold(data = df, threshold = 1, threshold_is = "score", metric_name = "SomeMetric", maximize = TRUE, grouping_keys = data.frame())
  # Testing class
  expect_equal(
    class(output_12454),
    "data.frame",
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_12454[["Grp"]],
    c(1, 1, 1, 1, 1, 2, 2, 2, 2, 2),
    tolerance = 1e-4)
  expect_equal(
    output_12454[["Observation"]],
    c(1, 2, 3, 4, 5, 1, 2, 3, 4, 5),
    tolerance = 1e-4)
  expect_equal(
    output_12454[["SomeMetric"]],
    c(0.2, 0.4, 0.6, 0.8, 0.9, 0.3, 0.2, 0.1, 0.8, 0.7),
    tolerance = 1e-4)
  expect_equal(
    output_12454[["Threshold"]],
    c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_12454),
    c("Grp", "Observation", "SomeMetric", "Threshold"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_12454),
    c("numeric", "numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_12454),
    c("double", "double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_12454),
    c(10L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_12454)),
    character(0),
    fixed = TRUE)

  # Testing exceeds_threshold(data = df, threshold = 0, th...
  # Assigning output
  output_11432 <- exceeds_threshold(data = df, threshold = 0, threshold_is = "score", metric_name = "SomeMetric", maximize = TRUE, grouping_keys = data.frame())
  # Testing class
  expect_equal(
    class(output_11432),
    "data.frame",
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_11432[["Grp"]],
    numeric(0),
    tolerance = 1e-4)
  expect_equal(
    output_11432[["Observation"]],
    numeric(0),
    tolerance = 1e-4)
  expect_equal(
    output_11432[["SomeMetric"]],
    numeric(0),
    tolerance = 1e-4)
  expect_equal(
    output_11432[["Threshold"]],
    numeric(0),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_11432),
    c("Grp", "Observation", "SomeMetric", "Threshold"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_11432),
    c("numeric", "numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_11432),
    c("double", "double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_11432),
    c(0L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_11432)),
    character(0),
    fixed = TRUE)

  # Testing exceeds_threshold(data = df, threshold = NA, t...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(exceeds_threshold(data = df, threshold = NA, threshold_is = "score", metric_name = "SomeMetric", maximize = TRUE, grouping_keys = data.frame())),
    xpectr::strip("1 assertions failed:\n * Variable 'threshold': May not be NA."),
    fixed = TRUE)

  # Testing exceeds_threshold(data = df, threshold = c(0.2...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(exceeds_threshold(data = df, threshold = c(0.2, 0.4), threshold_is = "score", metric_name = "SomeMetric", maximize = TRUE, grouping_keys = data.frame())),
    xpectr::strip("1 assertions failed:\n * Variable 'threshold': Must have length 1."),
    fixed = TRUE)

  # Testing exceeds_threshold(data = df, threshold = 7, th...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(exceeds_threshold(data = df, threshold = 7, threshold_is = "score", metric_name = "no", maximize = TRUE, grouping_keys = data.frame())),
    xpectr::strip(paste0("1 assertions failed:\n * Variable 'colnames(data)': Must inc",
           "lude the elements {no}.")),
    fixed = TRUE)

  # Testing exceeds_threshold(data = df, threshold = 7, th...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(exceeds_threshold(data = df, threshold = 7, threshold_is = "score", metric_name = NA, maximize = TRUE, grouping_keys = data.frame())),
    xpectr::strip(paste0("Assertion on 'must.include' failed. May not contain missing ",
           "values, first at position 1.")),
    fixed = TRUE)

  # Testing exceeds_threshold(data = NULL, threshold = 7, ...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(exceeds_threshold(data = NULL, threshold = 7, threshold_is = "score", metric_name = "SomeMetric", maximize = TRUE, grouping_keys = data.frame())),
    xpectr::strip(paste0("1 assertions failed:\n * Variable 'data': Must be of type 'd",
           "ata.frame', not 'NULL'.")),
    fixed = TRUE)

  # Testing exceeds_threshold(data = df, threshold = 7, th...
  # Assigning output
  output_12396 <- exceeds_threshold(data = df, threshold = 7, threshold_is = "score", metric_name = "SomeMetric", maximize = TRUE, grouping_keys = data.frame())
  # Testing class
  expect_equal(
    class(output_12396),
    "data.frame",
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_12396[["Grp"]],
    c(1, 1, 1, 1, 1, 2, 2, 2, 2, 2),
    tolerance = 1e-4)
  expect_equal(
    output_12396[["Observation"]],
    c(1, 2, 3, 4, 5, 1, 2, 3, 4, 5),
    tolerance = 1e-4)
  expect_equal(
    output_12396[["SomeMetric"]],
    c(0.2, 0.4, 0.6, 0.8, 0.9, 0.3, 0.2, 0.1, 0.8, 0.7),
    tolerance = 1e-4)
  expect_equal(
    output_12396[["Threshold"]],
    c(7, 7, 7, 7, 7, 7, 7, 7, 7, 7),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_12396),
    c("Grp", "Observation", "SomeMetric", "Threshold"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_12396),
    c("numeric", "numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_12396),
    c("double", "double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_12396),
    c(10L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_12396)),
    character(0),
    fixed = TRUE)

  # Testing exceeds_threshold(data = df, threshold = 7, th...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(exceeds_threshold(data = df, threshold = 7, threshold_is = "score", metric_name = "SomeMetric", maximize = TRUE, grouping_keys = NULL)),
    xpectr::strip(paste0("1 assertions failed:\n * Variable 'grouping_keys': Must be o",
           "f type 'data.frame', not 'NULL'.")),
    fixed = TRUE)

  # Testing exceeds_threshold(data = df, threshold = 7, th...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(exceeds_threshold(data = df, threshold = 7, threshold_is = "score", metric_name = "SomeMetric", maximize = NULL, grouping_keys = data.frame())),
    xpectr::strip(paste0("1 assertions failed:\n * Variable 'maximize': Must be of typ",
           "e 'logical flag', not 'NULL'.")),
    fixed = TRUE)

  # Testing exceeds_threshold(data = df, threshold = 7, th...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(exceeds_threshold(data = df, threshold = 7, threshold_is = "score", metric_name = NULL, maximize = TRUE, grouping_keys = data.frame())),
    xpectr::strip("attempt to select less than one element in get1index"),
    fixed = TRUE)

  # Testing exceeds_threshold(data = df, threshold = NULL,...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(exceeds_threshold(data = df, threshold = NULL, threshold_is = "score", metric_name = "SomeMetric", maximize = TRUE, grouping_keys = data.frame())),
    xpectr::strip(paste0("1 assertions failed:\n * Variable 'threshold': Must be of ty",
           "pe 'number', not 'NULL'.")),
    fixed = TRUE)

  # Testing exceeds_threshold(data = df, threshold = 7, th...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(exceeds_threshold(data = df, threshold = 7, threshold_is = NULL, metric_name = "SomeMetric", maximize = TRUE, grouping_keys = data.frame())),
    xpectr::strip(paste0("1 assertions failed:\n * Variable 'threshold_is': Must be a ",
           "subset of {'percentage','score'}, not 'NULL'.")),
    fixed = TRUE)

  ## Finished testing 'exceeds_threshold'                                     ####


})

test_that("prepare_predictions() works", {
  xpectr::set_test_seed(42)

  prepare_predictions_df <- function(...) prepare_predictions(...)$data

  ### Multinomial ####

  multinom_data <- predicted.musicians

  # Generate expectations for 'prepare_predictions'
  # Tip: comment out the gxs_function() call
  # so it is easy to regenerate the tests
  xpectr::set_test_seed(42)
  # xpectr::gxs_function(
  #   fn = prepare_predictions_df,
  #   args_values = list(
  #     "data" = list(multinom_data, multinom_data[,c("Target", "A")], NA),
  #     "prediction_cols" = list(c("A","B","C","D"), "Predicted Class", "A", "Target", NA),
  #     "target_col" = list("Target", "ID", "A", "Predicted Class"),
  #     "cutoff" = list(0.5),
  #     "type" = list("multinomial", "binomial", "gaussian", NA)
  #   ),
  #   indentation = 2
  # )


  ## Testing 'prepare_predictions_df'                                         ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing prepare_predictions_df(data = multinom_data,...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- prepare_predictions_df(data = multinom_data, prediction_cols = c("A", "B", "C", "D"), target_col = "Target", cutoff = 0.5, type = "multinomial")
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    xpectr::smpl(output_19148[["Classifier"]], n = 30),
    c("e1071_svm", "e1071_svm", "e1071_svm", "e1071_svm", "e1071_svm",
      "randomForest", "randomForest", "randomForest", "randomForest",
      "randomForest", "randomForest", "randomForest", "randomForest",
      "randomForest", "randomForest", "nnet_multinom", "nnet_multinom",
      "nnet_multinom", "nnet_multinom", "nnet_multinom", "nnet_multinom",
      "nnet_multinom", "nnet_multinom", "nnet_multinom", "nnet_multinom",
      "nnet_multinom", "nnet_multinom", "nnet_multinom", "nnet_multinom",
      "nnet_multinom"),
    fixed = TRUE)
  expect_equal(
    xpectr::smpl(output_19148[["Fold Column"]], n = 30),
    c(".folds_1", ".folds_2", ".folds_2", ".folds_3", ".folds_3", ".folds_1",
      ".folds_1", ".folds_2", ".folds_2", ".folds_2", ".folds_2",
      ".folds_2", ".folds_2", ".folds_3", ".folds_3", ".folds_1",
      ".folds_1", ".folds_1", ".folds_2", ".folds_2", ".folds_2",
      ".folds_2", ".folds_3", ".folds_3", ".folds_3", ".folds_3",
      ".folds_3", ".folds_3", ".folds_3", ".folds_3"),
    fixed = TRUE)
  expect_equal(
    xpectr::smpl(output_19148[["Fold"]], n = 30),
    c(4, 1, 1, 2, 3, 2, 5, 1, 1, 1, 3, 4, 5, 4, 5, 2, 2, 3, 1, 3, 4,
      5, 1, 2, 3, 3, 4, 4, 5, 5),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_19148[["ID"]], n = 30),
    structure(c(35L, 5L, 54L, 15L, 48L, 42L, 6L, 14L, 18L, 35L, 3L,
      6L, 20L, 37L, 7L, 12L, 42L, 46L, 35L, 7L, 45L, 13L, 51L, 5L,
      13L, 43L, 37L, 56L, 26L, 59L), .Label = c("1", "2", "3", "4",
      "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15",
      "16", "17", "18", "19", "20", "21", "22", "23", "24", "25",
      "26", "27", "28", "29", "30", "31", "32", "33", "34", "35",
      "36", "37", "38", "39", "40", "41", "42", "43", "44", "45",
      "46", "47", "48", "49", "50", "51", "52", "53", "54", "55",
      "56", "57", "58", "59", "60"), class = "factor"))
  expect_equal(
    xpectr::smpl(output_19148[["Target"]], n = 30),
    c("C", "A", "D", "A", "D", "C", "A", "A", "B", "C", "A", "A", "B",
      "C", "A", "A", "C", "D", "C", "A", "C", "A", "D", "A", "A",
      "C", "C", "D", "B", "D"),
    fixed = TRUE)
  expect_equal(
    xpectr::smpl(output_19148[["A"]], n = 30),
    c(0.0895, 0.28609, 0.23448, 0.36709, 0.17322, 0.218, 0.31, 0.376,
      0.386, 0.014, 0.482, 0.356, 0.084, 0.566, 0.362, 0.88443, 0.01643,
      1e-05, 0.00757, 0.05587, 0.00282, 0.99545, 0.06017, 0.81, 0.90717,
      0.03895, 0.99829, 0.00625, 0.37754, 0.87035),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_19148[["B"]], n = 30),
    c(0.16704, 0.14521, 0.33288, 0.16154, 0.40645, 0.068, 0.328, 0.056,
      0.396, 0.158, 0.108, 0.346, 0.452, 0.076, 0.25, 0.08961, 0.00046,
      0.15984, 0.00299, 0.81576, 3e-05, 6e-05, 0.01259, 0.10164, 0.00246,
      0.0054, 0, 0, 0.61474, 0.0965),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_19148[["C"]], n = 30),
    c(0.34204, 0.31543, 0.16505, 0.32249, 0.21645, 0.506, 0.144, 0.5,
      0, 0.326, 0.284, 0.058, 0.286, 0.14, 0.092, 0, 0.93693, 0.00253,
      0.47326, 0.04522, 0.9958, 0, 0.88762, 0, 0.08359, 0, 0.00171,
      0.18888, 0, 0),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_19148[["D"]], n = 30),
    c(0.40141, 0.25326, 0.26759, 0.14887, 0.20387, 0.208, 0.218, 0.068,
      0.218, 0.502, 0.126, 0.24, 0.178, 0.218, 0.296, 0.02596, 0.04618,
      0.83762, 0.51618, 0.08315, 0.00135, 0.00449, 0.03962, 0.08836,
      0.00677, 0.95565, 1e-05, 0.80487, 0.00771, 0.03316),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_19148[["Predicted Class"]], n = 30),
    c("D", "C", "B", "A", "B", "C", "B", "C", "B", "D", "A", "A", "B",
      "A", "A", "A", "C", "D", "D", "B", "C", "A", "C", "A", "A",
      "D", "A", "D", "B", "A"),
    fixed = TRUE)
  expect_equal(
    xpectr::smpl(output_19148[["predicted_class_index"]], n = 30),
    c(4, 3, 2, 1, 2, 3, 2, 3, 2, 4, 1, 1, 2, 1, 1, 1, 3, 4, 4, 2, 3,
      1, 3, 1, 1, 4, 1, 4, 2, 1),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_19148[["predicted_class"]], n = 30),
    c("D", "C", "B", "A", "B", "C", "B", "C", "B", "D", "A", "A", "B",
      "A", "A", "A", "C", "D", "D", "B", "C", "A", "C", "A", "A",
      "D", "A", "D", "B", "A"),
    fixed = TRUE)
  expect_equal(
    xpectr::smpl(output_19148[["probability_of_target"]], n = 30),
    c(0.34204, 0.28609, 0.26759, 0.36709, 0.20387, 0.506, 0.31, 0.376,
      0.396, 0.326, 0.482, 0.356, 0.452, 0.14, 0.362, 0.88443, 0.93693,
      0.83762, 0.47326, 0.05587, 0.9958, 0.99545, 0.03962, 0.81, 0.90717,
      0, 0.00171, 0.80487, 0.61474, 0.03316),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("Classifier", "Fold Column", "Fold", "ID", "Target", "A", "B",
      "C", "D", "Predicted Class", "predicted_class_index", "predicted_class",
      "probability_of_target"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("character", "character", "integer", "factor", "character", "numeric",
      "numeric", "numeric", "numeric", "character", "numeric", "character",
      "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("character", "character", "integer", "integer", "character", "double",
      "double", "double", "double", "character", "double", "character",
      "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(540L, 13L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = multinom_data[...
  # Changed from baseline: data = multinom_data[...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19370 <- xpectr::capture_side_effects(prepare_predictions_df(data = multinom_data[, c("Target", "A")], prediction_cols = c("A", "B", "C", "D"), target_col = "Target", cutoff = 0.5, type = "multinomial"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19370[['error']]),
    xpectr::strip("1 assertions failed:\n * 'data' does not include all the prediction columns."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19370[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = NA, prediction...
  # Changed from baseline: data = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12861 <- xpectr::capture_side_effects(prepare_predictions_df(data = NA, prediction_cols = c("A", "B", "C", "D"), target_col = "Target", cutoff = 0.5, type = "multinomial"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'data': Must be of type 'data.frame', not 'logical'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = NULL, predicti...
  # Changed from baseline: data = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18304 <- xpectr::capture_side_effects(prepare_predictions_df(data = NULL, prediction_cols = c("A", "B", "C", "D"), target_col = "Target", cutoff = 0.5, type = "multinomial"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'data': Must be of type 'data.frame', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = multinom_data,...
  # Changed from baseline: prediction_cols = "Pr...
  xpectr::set_test_seed(42)
  # Assigning output
  output_16417 <- prepare_predictions_df(data = multinom_data, prediction_cols = "Predicted Class", target_col = "Target", cutoff = 0.5, type = "multinomial")
  # Testing class
  expect_equal(
    class(output_16417),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    xpectr::smpl(output_16417[["Classifier"]], n = 30),
    c("e1071_svm", "e1071_svm", "e1071_svm", "e1071_svm", "e1071_svm",
      "randomForest", "randomForest", "randomForest", "randomForest",
      "randomForest", "randomForest", "randomForest", "randomForest",
      "randomForest", "randomForest", "nnet_multinom", "nnet_multinom",
      "nnet_multinom", "nnet_multinom", "nnet_multinom", "nnet_multinom",
      "nnet_multinom", "nnet_multinom", "nnet_multinom", "nnet_multinom",
      "nnet_multinom", "nnet_multinom", "nnet_multinom", "nnet_multinom",
      "nnet_multinom"),
    fixed = TRUE)
  expect_equal(
    xpectr::smpl(output_16417[["Fold Column"]], n = 30),
    c(".folds_1", ".folds_2", ".folds_2", ".folds_3", ".folds_3", ".folds_1",
      ".folds_1", ".folds_2", ".folds_2", ".folds_2", ".folds_2",
      ".folds_2", ".folds_2", ".folds_3", ".folds_3", ".folds_1",
      ".folds_1", ".folds_1", ".folds_2", ".folds_2", ".folds_2",
      ".folds_2", ".folds_3", ".folds_3", ".folds_3", ".folds_3",
      ".folds_3", ".folds_3", ".folds_3", ".folds_3"),
    fixed = TRUE)
  expect_equal(
    xpectr::smpl(output_16417[["Fold"]], n = 30),
    c(4, 1, 1, 2, 3, 2, 5, 1, 1, 1, 3, 4, 5, 4, 5, 2, 2, 3, 1, 3, 4,
      5, 1, 2, 3, 3, 4, 4, 5, 5),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_16417[["ID"]], n = 30),
    structure(c(35L, 5L, 54L, 15L, 48L, 42L, 6L, 14L, 18L, 35L, 3L,
      6L, 20L, 37L, 7L, 12L, 42L, 46L, 35L, 7L, 45L, 13L, 51L, 5L,
      13L, 43L, 37L, 56L, 26L, 59L), .Label = c("1", "2", "3", "4",
      "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15",
      "16", "17", "18", "19", "20", "21", "22", "23", "24", "25",
      "26", "27", "28", "29", "30", "31", "32", "33", "34", "35",
      "36", "37", "38", "39", "40", "41", "42", "43", "44", "45",
      "46", "47", "48", "49", "50", "51", "52", "53", "54", "55",
      "56", "57", "58", "59", "60"), class = "factor"))
  expect_equal(
    xpectr::smpl(output_16417[["Target"]], n = 30),
    c("C", "A", "D", "A", "D", "C", "A", "A", "B", "C", "A", "A", "B",
      "C", "A", "A", "C", "D", "C", "A", "C", "A", "D", "A", "A",
      "C", "C", "D", "B", "D"),
    fixed = TRUE)
  expect_equal(
    xpectr::smpl(output_16417[["A"]], n = 30),
    c(0.0895, 0.28609, 0.23448, 0.36709, 0.17322, 0.218, 0.31, 0.376,
      0.386, 0.014, 0.482, 0.356, 0.084, 0.566, 0.362, 0.88443, 0.01643,
      1e-05, 0.00757, 0.05587, 0.00282, 0.99545, 0.06017, 0.81, 0.90717,
      0.03895, 0.99829, 0.00625, 0.37754, 0.87035),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_16417[["B"]], n = 30),
    c(0.16704, 0.14521, 0.33288, 0.16154, 0.40645, 0.068, 0.328, 0.056,
      0.396, 0.158, 0.108, 0.346, 0.452, 0.076, 0.25, 0.08961, 0.00046,
      0.15984, 0.00299, 0.81576, 3e-05, 6e-05, 0.01259, 0.10164, 0.00246,
      0.0054, 0, 0, 0.61474, 0.0965),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_16417[["C"]], n = 30),
    c(0.34204, 0.31543, 0.16505, 0.32249, 0.21645, 0.506, 0.144, 0.5,
      0, 0.326, 0.284, 0.058, 0.286, 0.14, 0.092, 0, 0.93693, 0.00253,
      0.47326, 0.04522, 0.9958, 0, 0.88762, 0, 0.08359, 0, 0.00171,
      0.18888, 0, 0),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_16417[["D"]], n = 30),
    c(0.40141, 0.25326, 0.26759, 0.14887, 0.20387, 0.208, 0.218, 0.068,
      0.218, 0.502, 0.126, 0.24, 0.178, 0.218, 0.296, 0.02596, 0.04618,
      0.83762, 0.51618, 0.08315, 0.00135, 0.00449, 0.03962, 0.08836,
      0.00677, 0.95565, 1e-05, 0.80487, 0.00771, 0.03316),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_16417[["Predicted Class"]], n = 30),
    c("D", "C", "B", "A", "B", "C", "B", "C", "B", "D", "A", "A", "B",
      "A", "A", "A", "C", "D", "D", "B", "C", "A", "C", "A", "A",
      "D", "A", "D", "B", "A"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_16417),
    c("Classifier", "Fold Column", "Fold", "ID", "Target", "A", "B",
      "C", "D", "Predicted Class"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_16417),
    c("character", "character", "integer", "factor", "character", "numeric",
      "numeric", "numeric", "numeric", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_16417),
    c("character", "character", "integer", "integer", "character", "double",
      "double", "double", "double", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_16417),
    c(540L, 10L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_16417)),
    character(0),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = multinom_data,...
  # Changed from baseline: prediction_cols = "A"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15190 <- xpectr::capture_side_effects(prepare_predictions_df(data = multinom_data, prediction_cols = "A", target_col = "Target", cutoff = 0.5, type = "multinomial"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error']]),
    xpectr::strip("1 assertions failed:\n * when 'type' is 'multinomial' and prediction_cols has length 1, 'data[[prediction_cols]]' must have type\n * 'character'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = multinom_data,...
  # Changed from baseline: prediction_cols = "Ta...
  xpectr::set_test_seed(42)
  # Assigning output
  output_17365 <- prepare_predictions_df(data = multinom_data, prediction_cols = "Target", target_col = "Target", cutoff = 0.5, type = "multinomial")
  # Testing class
  expect_equal(
    class(output_17365),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    xpectr::smpl(output_17365[["Classifier"]], n = 30),
    c("e1071_svm", "e1071_svm", "e1071_svm", "e1071_svm", "e1071_svm",
      "randomForest", "randomForest", "randomForest", "randomForest",
      "randomForest", "randomForest", "randomForest", "randomForest",
      "randomForest", "randomForest", "nnet_multinom", "nnet_multinom",
      "nnet_multinom", "nnet_multinom", "nnet_multinom", "nnet_multinom",
      "nnet_multinom", "nnet_multinom", "nnet_multinom", "nnet_multinom",
      "nnet_multinom", "nnet_multinom", "nnet_multinom", "nnet_multinom",
      "nnet_multinom"),
    fixed = TRUE)
  expect_equal(
    xpectr::smpl(output_17365[["Fold Column"]], n = 30),
    c(".folds_1", ".folds_2", ".folds_2", ".folds_3", ".folds_3", ".folds_1",
      ".folds_1", ".folds_2", ".folds_2", ".folds_2", ".folds_2",
      ".folds_2", ".folds_2", ".folds_3", ".folds_3", ".folds_1",
      ".folds_1", ".folds_1", ".folds_2", ".folds_2", ".folds_2",
      ".folds_2", ".folds_3", ".folds_3", ".folds_3", ".folds_3",
      ".folds_3", ".folds_3", ".folds_3", ".folds_3"),
    fixed = TRUE)
  expect_equal(
    xpectr::smpl(output_17365[["Fold"]], n = 30),
    c(4, 1, 1, 2, 3, 2, 5, 1, 1, 1, 3, 4, 5, 4, 5, 2, 2, 3, 1, 3, 4,
      5, 1, 2, 3, 3, 4, 4, 5, 5),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_17365[["ID"]], n = 30),
    structure(c(35L, 5L, 54L, 15L, 48L, 42L, 6L, 14L, 18L, 35L, 3L,
      6L, 20L, 37L, 7L, 12L, 42L, 46L, 35L, 7L, 45L, 13L, 51L, 5L,
      13L, 43L, 37L, 56L, 26L, 59L), .Label = c("1", "2", "3", "4",
      "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15",
      "16", "17", "18", "19", "20", "21", "22", "23", "24", "25",
      "26", "27", "28", "29", "30", "31", "32", "33", "34", "35",
      "36", "37", "38", "39", "40", "41", "42", "43", "44", "45",
      "46", "47", "48", "49", "50", "51", "52", "53", "54", "55",
      "56", "57", "58", "59", "60"), class = "factor"))
  expect_equal(
    xpectr::smpl(output_17365[["Target"]], n = 30),
    c("C", "A", "D", "A", "D", "C", "A", "A", "B", "C", "A", "A", "B",
      "C", "A", "A", "C", "D", "C", "A", "C", "A", "D", "A", "A",
      "C", "C", "D", "B", "D"),
    fixed = TRUE)
  expect_equal(
    xpectr::smpl(output_17365[["A"]], n = 30),
    c(0.0895, 0.28609, 0.23448, 0.36709, 0.17322, 0.218, 0.31, 0.376,
      0.386, 0.014, 0.482, 0.356, 0.084, 0.566, 0.362, 0.88443, 0.01643,
      1e-05, 0.00757, 0.05587, 0.00282, 0.99545, 0.06017, 0.81, 0.90717,
      0.03895, 0.99829, 0.00625, 0.37754, 0.87035),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_17365[["B"]], n = 30),
    c(0.16704, 0.14521, 0.33288, 0.16154, 0.40645, 0.068, 0.328, 0.056,
      0.396, 0.158, 0.108, 0.346, 0.452, 0.076, 0.25, 0.08961, 0.00046,
      0.15984, 0.00299, 0.81576, 3e-05, 6e-05, 0.01259, 0.10164, 0.00246,
      0.0054, 0, 0, 0.61474, 0.0965),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_17365[["C"]], n = 30),
    c(0.34204, 0.31543, 0.16505, 0.32249, 0.21645, 0.506, 0.144, 0.5,
      0, 0.326, 0.284, 0.058, 0.286, 0.14, 0.092, 0, 0.93693, 0.00253,
      0.47326, 0.04522, 0.9958, 0, 0.88762, 0, 0.08359, 0, 0.00171,
      0.18888, 0, 0),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_17365[["D"]], n = 30),
    c(0.40141, 0.25326, 0.26759, 0.14887, 0.20387, 0.208, 0.218, 0.068,
      0.218, 0.502, 0.126, 0.24, 0.178, 0.218, 0.296, 0.02596, 0.04618,
      0.83762, 0.51618, 0.08315, 0.00135, 0.00449, 0.03962, 0.08836,
      0.00677, 0.95565, 1e-05, 0.80487, 0.00771, 0.03316),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_17365[["Predicted Class"]], n = 30),
    c("D", "C", "B", "A", "B", "C", "B", "C", "B", "D", "A", "A", "B",
      "A", "A", "A", "C", "D", "D", "B", "C", "A", "C", "A", "A",
      "D", "A", "D", "B", "A"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_17365),
    c("Classifier", "Fold Column", "Fold", "ID", "Target", "A", "B",
      "C", "D", "Predicted Class"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_17365),
    c("character", "character", "integer", "factor", "character", "numeric",
      "numeric", "numeric", "numeric", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_17365),
    c("character", "character", "integer", "integer", "character", "double",
      "double", "double", "double", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17365),
    c(540L, 10L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_17365)),
    character(0),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = multinom_data,...
  # Changed from baseline: prediction_cols = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11346 <- xpectr::capture_side_effects(prepare_predictions_df(data = multinom_data, prediction_cols = NA, target_col = "Target", cutoff = 0.5, type = "multinomial"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11346[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'prediction_cols': Contains missing values (element 1)."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11346[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = multinom_data,...
  # Changed from baseline: prediction_cols = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16569 <- xpectr::capture_side_effects(prepare_predictions_df(data = multinom_data, prediction_cols = NULL, target_col = "Target", cutoff = 0.5, type = "multinomial"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'prediction_cols': Must be of type 'character', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = multinom_data,...
  # Changed from baseline: target_col = "ID"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17050 <- xpectr::capture_side_effects(prepare_predictions_df(data = multinom_data, prediction_cols = c("A", "B", "C", "D"), target_col = "ID", cutoff = 0.5, type = "multinomial"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error']]),
    xpectr::strip("1 assertions failed:\n * when 'prediction_cols' has length > 1, all classes in 'data[[target_col]]' must have a prediction column."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = multinom_data,...
  # Changed from baseline: target_col = "A"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14577 <- xpectr::capture_side_effects(prepare_predictions_df(data = multinom_data, prediction_cols = c("A", "B", "C", "D"), target_col = "A", cutoff = 0.5, type = "multinomial"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14577[['error']]),
    xpectr::strip("1 assertions failed:\n * When 'type' is 'multinomial', 'data[[target_col]]' must either have type 'character' or 'factor'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14577[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = multinom_data,...
  # Changed from baseline: target_col = "Predict...
  xpectr::set_test_seed(42)
  # Assigning output
  output_17191 <- prepare_predictions_df(data = multinom_data, prediction_cols = c("A", "B", "C", "D"), target_col = "Predicted Class", cutoff = 0.5, type = "multinomial")
  # Testing class
  expect_equal(
    class(output_17191),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    xpectr::smpl(output_17191[["Classifier"]], n = 30),
    c("e1071_svm", "e1071_svm", "e1071_svm", "e1071_svm", "e1071_svm",
      "randomForest", "randomForest", "randomForest", "randomForest",
      "randomForest", "randomForest", "randomForest", "randomForest",
      "randomForest", "randomForest", "nnet_multinom", "nnet_multinom",
      "nnet_multinom", "nnet_multinom", "nnet_multinom", "nnet_multinom",
      "nnet_multinom", "nnet_multinom", "nnet_multinom", "nnet_multinom",
      "nnet_multinom", "nnet_multinom", "nnet_multinom", "nnet_multinom",
      "nnet_multinom"),
    fixed = TRUE)
  expect_equal(
    xpectr::smpl(output_17191[["Fold Column"]], n = 30),
    c(".folds_1", ".folds_2", ".folds_2", ".folds_3", ".folds_3", ".folds_1",
      ".folds_1", ".folds_2", ".folds_2", ".folds_2", ".folds_2",
      ".folds_2", ".folds_2", ".folds_3", ".folds_3", ".folds_1",
      ".folds_1", ".folds_1", ".folds_2", ".folds_2", ".folds_2",
      ".folds_2", ".folds_3", ".folds_3", ".folds_3", ".folds_3",
      ".folds_3", ".folds_3", ".folds_3", ".folds_3"),
    fixed = TRUE)
  expect_equal(
    xpectr::smpl(output_17191[["Fold"]], n = 30),
    c(4, 1, 1, 2, 3, 2, 5, 1, 1, 1, 3, 4, 5, 4, 5, 2, 2, 3, 1, 3, 4,
      5, 1, 2, 3, 3, 4, 4, 5, 5),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_17191[["ID"]], n = 30),
    structure(c(35L, 5L, 54L, 15L, 48L, 42L, 6L, 14L, 18L, 35L, 3L,
      6L, 20L, 37L, 7L, 12L, 42L, 46L, 35L, 7L, 45L, 13L, 51L, 5L,
      13L, 43L, 37L, 56L, 26L, 59L), .Label = c("1", "2", "3", "4",
      "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15",
      "16", "17", "18", "19", "20", "21", "22", "23", "24", "25",
      "26", "27", "28", "29", "30", "31", "32", "33", "34", "35",
      "36", "37", "38", "39", "40", "41", "42", "43", "44", "45",
      "46", "47", "48", "49", "50", "51", "52", "53", "54", "55",
      "56", "57", "58", "59", "60"), class = "factor"))
  expect_equal(
    xpectr::smpl(output_17191[["Target"]], n = 30),
    c("C", "A", "D", "A", "D", "C", "A", "A", "B", "C", "A", "A", "B",
      "C", "A", "A", "C", "D", "C", "A", "C", "A", "D", "A", "A",
      "C", "C", "D", "B", "D"),
    fixed = TRUE)
  expect_equal(
    xpectr::smpl(output_17191[["A"]], n = 30),
    c(0.0895, 0.28609, 0.23448, 0.36709, 0.17322, 0.218, 0.31, 0.376,
      0.386, 0.014, 0.482, 0.356, 0.084, 0.566, 0.362, 0.88443, 0.01643,
      1e-05, 0.00757, 0.05587, 0.00282, 0.99545, 0.06017, 0.81, 0.90717,
      0.03895, 0.99829, 0.00625, 0.37754, 0.87035),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_17191[["B"]], n = 30),
    c(0.16704, 0.14521, 0.33288, 0.16154, 0.40645, 0.068, 0.328, 0.056,
      0.396, 0.158, 0.108, 0.346, 0.452, 0.076, 0.25, 0.08961, 0.00046,
      0.15984, 0.00299, 0.81576, 3e-05, 6e-05, 0.01259, 0.10164, 0.00246,
      0.0054, 0, 0, 0.61474, 0.0965),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_17191[["C"]], n = 30),
    c(0.34204, 0.31543, 0.16505, 0.32249, 0.21645, 0.506, 0.144, 0.5,
      0, 0.326, 0.284, 0.058, 0.286, 0.14, 0.092, 0, 0.93693, 0.00253,
      0.47326, 0.04522, 0.9958, 0, 0.88762, 0, 0.08359, 0, 0.00171,
      0.18888, 0, 0),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_17191[["D"]], n = 30),
    c(0.40141, 0.25326, 0.26759, 0.14887, 0.20387, 0.208, 0.218, 0.068,
      0.218, 0.502, 0.126, 0.24, 0.178, 0.218, 0.296, 0.02596, 0.04618,
      0.83762, 0.51618, 0.08315, 0.00135, 0.00449, 0.03962, 0.08836,
      0.00677, 0.95565, 1e-05, 0.80487, 0.00771, 0.03316),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_17191[["Predicted Class"]], n = 30),
    c("D", "C", "B", "A", "B", "C", "B", "C", "B", "D", "A", "A", "B",
      "A", "A", "A", "C", "D", "D", "B", "C", "A", "C", "A", "A",
      "D", "A", "D", "B", "A"),
    fixed = TRUE)
  expect_equal(
    xpectr::smpl(output_17191[["predicted_class_index"]], n = 30),
    c(4, 3, 2, 1, 2, 3, 2, 3, 2, 4, 1, 1, 2, 1, 1, 1, 3, 4, 4, 2, 3,
      1, 3, 1, 1, 4, 1, 4, 2, 1),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_17191[["predicted_class"]], n = 30),
    c("D", "C", "B", "A", "B", "C", "B", "C", "B", "D", "A", "A", "B",
      "A", "A", "A", "C", "D", "D", "B", "C", "A", "C", "A", "A",
      "D", "A", "D", "B", "A"),
    fixed = TRUE)
  expect_equal(
    xpectr::smpl(output_17191[["probability_of_target"]], n = 30),
    c(0.40141, 0.31543, 0.33288, 0.36709, 0.40645, 0.506, 0.328, 0.5,
      0.396, 0.502, 0.482, 0.356, 0.452, 0.566, 0.362, 0.88443, 0.93693,
      0.83762, 0.51618, 0.81576, 0.9958, 0.99545, 0.88762, 0.81, 0.90717,
      0.95565, 0.99829, 0.80487, 0.61474, 0.87035),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_17191),
    c("Classifier", "Fold Column", "Fold", "ID", "Target", "A", "B",
      "C", "D", "Predicted Class", "predicted_class_index", "predicted_class",
      "probability_of_target"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_17191),
    c("character", "character", "integer", "factor", "character", "numeric",
      "numeric", "numeric", "numeric", "character", "numeric", "character",
      "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_17191),
    c("character", "character", "integer", "integer", "character", "double",
      "double", "double", "double", "character", "double", "character",
      "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17191),
    c(540L, 13L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_17191)),
    character(0),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = multinom_data,...
  # Changed from baseline: target_col = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19346 <- xpectr::capture_side_effects(prepare_predictions_df(data = multinom_data, prediction_cols = c("A", "B", "C", "D"), target_col = NULL, cutoff = 0.5, type = "multinomial"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'target_col': Must be of type 'string', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = multinom_data,...
  # Changed from baseline: cutoff = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12554 <- xpectr::capture_side_effects(prepare_predictions_df(data = multinom_data, prediction_cols = c("A", "B", "C", "D"), target_col = "Target", cutoff = NULL, type = "multinomial"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12554[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'cutoff': Must be of type 'number', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12554[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = multinom_data,...
  # Changed from baseline: type = "binomial"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14622 <- xpectr::capture_side_effects(prepare_predictions_df(data = multinom_data, prediction_cols = c("A", "B", "C", "D"), target_col = "Target", cutoff = 0.5, type = "binomial"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14622[['error']]),
    xpectr::strip("1 assertions failed:\n * 'prediction_cols' can only have length > 1 when 'type' is 'multinomial'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14622[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = multinom_data,...
  # Changed from baseline: type = "gaussian"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19400 <- xpectr::capture_side_effects(prepare_predictions_df(data = multinom_data, prediction_cols = c("A", "B", "C", "D"), target_col = "Target", cutoff = 0.5, type = "gaussian"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19400[['error']]),
    xpectr::strip("1 assertions failed:\n * When 'type' is 'gaussian', 'data[[target_col]]' must be numeric."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19400[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = multinom_data,...
  # Changed from baseline: type = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19782 <- xpectr::capture_side_effects(prepare_predictions_df(data = multinom_data, prediction_cols = c("A", "B", "C", "D"), target_col = "Target", cutoff = 0.5, type = NA), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19782[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'type': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19782[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = multinom_data,...
  # Changed from baseline: type = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11174 <- xpectr::capture_side_effects(prepare_predictions_df(data = multinom_data, prediction_cols = c("A", "B", "C", "D"), target_col = "Target", cutoff = 0.5, type = NULL), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11174[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'type': Must be of type 'string', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11174[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  ## Finished testing 'prepare_predictions_df'                                ####
  #

  ### Binomial ####

  binom_data <- predicted.musicians %>%
    dplyr::filter(Target %in% c("A", "B")) %>%
    dplyr::rename(Prediction = B)


  xpectr::set_test_seed(42)
  # xpectr::gxs_function(
  #   fn = prepare_predictions_df,
  #   args_values = list(
  #     "data" = list(binom_data, NA),
  #     "prediction_cols" = list("Prediction", c("A","B","C","D"),
  #                              "Predicted Class", "O", "Target", NA),
  #     "target_col" = list("Target", "ID", "A", "O", "Predicted Class"),
  #     "cutoff" = list(0.5, 2, -1, NA, "0.5"),
  #     "type" = list("binomial", "multinomial", "gaussian", NA)
  #   ),
  #   indentation = 2
  # )


  ## Testing 'prepare_predictions_df'                                         ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing prepare_predictions_df(data = binom_data, pr...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- prepare_predictions_df(data = binom_data, prediction_cols = "Prediction", target_col = "Target", cutoff = 0.5, type = "binomial")
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    xpectr::smpl(output_19148[["Classifier"]], n = 30),
    c("e1071_svm", "e1071_svm", "e1071_svm", "e1071_svm", "e1071_svm",
      "e1071_svm", "randomForest", "randomForest", "randomForest",
      "randomForest", "randomForest", "randomForest", "randomForest",
      "randomForest", "randomForest", "nnet_multinom", "nnet_multinom",
      "nnet_multinom", "nnet_multinom", "nnet_multinom", "nnet_multinom",
      "nnet_multinom", "nnet_multinom", "nnet_multinom", "nnet_multinom",
      "nnet_multinom", "nnet_multinom", "nnet_multinom", "nnet_multinom",
      "nnet_multinom"),
    fixed = TRUE)
  expect_equal(
    xpectr::smpl(output_19148[["Fold Column"]], n = 30),
    c(".folds_1", ".folds_1", ".folds_2", ".folds_2", ".folds_3", ".folds_3",
      ".folds_1", ".folds_1", ".folds_1", ".folds_1", ".folds_2",
      ".folds_2", ".folds_2", ".folds_3", ".folds_3", ".folds_1",
      ".folds_1", ".folds_1", ".folds_1", ".folds_2", ".folds_2",
      ".folds_2", ".folds_2", ".folds_2", ".folds_3", ".folds_3",
      ".folds_3", ".folds_3", ".folds_3", ".folds_3"),
    fixed = TRUE)
  expect_equal(
    xpectr::smpl(output_19148[["Fold"]], n = 30),
    c(4, 5, 1, 1, 1, 3, 1, 4, 5, 5, 1, 3, 4, 4, 4, 1, 2, 3, 4, 2, 2,
      3, 4, 5, 1, 1, 2, 2, 3, 4),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_19148[["ID"]], n = 30),
    structure(c(11L, 24L, 21L, 30L, 28L, 24L, 28L, 3L, 23L, 24L, 30L,
      27L, 15L, 12L, 22L, 21L, 2L, 15L, 19L, 19L, 26L, 25L, 24L, 29L,
      8L, 28L, 1L, 15L, 2L, 9L), .Label = c("1", "2", "3", "4", "5",
      "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16",
      "17", "18", "19", "20", "21", "22", "23", "24", "25", "26",
      "27", "28", "29", "30", "31", "32", "33", "34", "35", "36",
      "37", "38", "39", "40", "41", "42", "43", "44", "45", "46",
      "47", "48", "49", "50", "51", "52", "53", "54", "55", "56",
      "57", "58", "59", "60"), class = "factor"))
  expect_equal(
    xpectr::smpl(output_19148[["Target"]], n = 30),
    c("A", "B", "B", "B", "B", "B", "B", "A", "B", "B", "B", "B", "A",
      "A", "B", "B", "A", "A", "B", "B", "B", "B", "B", "B", "A",
      "B", "A", "A", "A", "A"),
    fixed = TRUE)
  expect_equal(
    xpectr::smpl(output_19148[["A"]], n = 30),
    c(0.36393, 0.12083, 0.26534, 0.21885, 0.22152, 0.1307, 0.22, 0.506,
      0.22, 0.024, 0.216, 0.442, 0.43, 0.304, 0.28, 0, 0.24051, 0.8486,
      0.48301, 0.28305, 0, 0.06542, 0.00564, 0.82806, 0.54858, 0.00413,
      0, 0.76432, 0.1525, 0),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_19148[["Prediction"]], n = 30),
    c(0.14688, 0.38609, 0.41055, 0.27878, 0.37519, 0.37871, 0.494, 0.128,
      0.524, 0.486, 0.13, 0.312, 0.06, 0.23, 0.294, 1, 0.64448, 0.0137,
      0.24638, 0.59286, 1, 0.33989, 0.22409, 0.02586, 0.0214, 0.95377,
      0, 0.12655, 0.78244, 1),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_19148[["C"]], n = 30),
    c(0.1632, 0.16882, 0.08189, 0.20212, 0.06586, 0.18908, 0.002, 0.21,
      0.094, 0.152, 0.216, 0.21, 0.43, 0.036, 0.136, 0, 0, 0.05804,
      0.05163, 0.05449, 0, 0.04494, 0.00041, 0, 0.29328, 0.00066,
      1, 0, 0.01395, 0),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_19148[["D"]], n = 30),
    c(0.32598, 0.32426, 0.24222, 0.30025, 0.33743, 0.30151, 0.284, 0.156,
      0.162, 0.338, 0.438, 0.036, 0.08, 0.43, 0.29, 0, 0.115, 0.07967,
      0.21899, 0.06961, 0, 0.54975, 0.76986, 0.14607, 0.13674, 0.04144,
      0, 0.10913, 0.05111, 0),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_19148[["Predicted Class"]], n = 30),
    c("A", "B", "B", "D", "B", "B", "B", "A", "B", "B", "D", "A", "A",
      "D", "B", "B", "B", "A", "A", "B", "B", "D", "D", "A", "A",
      "B", "C", "A", "B", "B"),
    fixed = TRUE)
  expect_equal(
    xpectr::smpl(output_19148[["predicted_class"]], n = 30),
    c("A", "A", "A", "A", "A", "A", "A", "A", "B", "A", "A", "A", "A",
      "A", "A", "B", "B", "A", "A", "B", "B", "A", "A", "A", "A",
      "B", "A", "A", "B", "B"),
    fixed = TRUE)
  expect_equal(
    xpectr::smpl(output_19148[["probability_of_target"]], n = 30),
    c(0.85312, 0.38609, 0.41055, 0.27878, 0.37519, 0.37871, 0.494, 0.872,
      0.524, 0.486, 0.13, 0.312, 0.94, 0.77, 0.294, 1, 0.35552, 0.9863,
      0.24638, 0.59286, 1, 0.33989, 0.22409, 0.02586, 0.9786, 0.95377,
      1, 0.87345, 0.21756, 0),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("Classifier", "Fold Column", "Fold", "ID", "Target", "A", "Prediction",
      "C", "D", "Predicted Class", "predicted_class", "probability_of_target"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("character", "character", "integer", "factor", "character", "numeric",
      "numeric", "numeric", "numeric", "character", "character", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("character", "character", "integer", "integer", "character", "double",
      "double", "double", "double", "character", "character", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(270L, 12L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = NA, prediction...
  # Changed from baseline: data = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19370 <- xpectr::capture_side_effects(prepare_predictions_df(data = NA, prediction_cols = "Prediction", target_col = "Target", cutoff = 0.5, type = "binomial"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19370[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'data': Must be of type 'data.frame', not 'logical'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19370[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = NULL, predicti...
  # Changed from baseline: data = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12861 <- xpectr::capture_side_effects(prepare_predictions_df(data = NULL, prediction_cols = "Prediction", target_col = "Target", cutoff = 0.5, type = "binomial"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'data': Must be of type 'data.frame', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = binom_data, pr...
  # Changed from baseline: prediction_cols = c("...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18304 <- xpectr::capture_side_effects(prepare_predictions_df(data = binom_data, prediction_cols = c("A", "B", "C", "D"), target_col = "Target", cutoff = 0.5, type = "binomial"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error']]),
    xpectr::strip("1 assertions failed:\n * 'data' does not include all the prediction columns."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = binom_data, pr...
  # Changed from baseline: prediction_cols = "Pr...
  xpectr::set_test_seed(42)
  # Assigning output
  output_16417 <- prepare_predictions_df(data = binom_data, prediction_cols = "Predicted Class", target_col = "Target", cutoff = 0.5, type = "binomial")
  # Testing class
  expect_equal(
    class(output_16417),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    xpectr::smpl(output_16417[["Classifier"]], n = 30),
    c("e1071_svm", "e1071_svm", "e1071_svm", "e1071_svm", "e1071_svm",
      "e1071_svm", "randomForest", "randomForest", "randomForest",
      "randomForest", "randomForest", "randomForest", "randomForest",
      "randomForest", "randomForest", "nnet_multinom", "nnet_multinom",
      "nnet_multinom", "nnet_multinom", "nnet_multinom", "nnet_multinom",
      "nnet_multinom", "nnet_multinom", "nnet_multinom", "nnet_multinom",
      "nnet_multinom", "nnet_multinom", "nnet_multinom", "nnet_multinom",
      "nnet_multinom"),
    fixed = TRUE)
  expect_equal(
    xpectr::smpl(output_16417[["Fold Column"]], n = 30),
    c(".folds_1", ".folds_1", ".folds_2", ".folds_2", ".folds_3", ".folds_3",
      ".folds_1", ".folds_1", ".folds_1", ".folds_1", ".folds_2",
      ".folds_2", ".folds_2", ".folds_3", ".folds_3", ".folds_1",
      ".folds_1", ".folds_1", ".folds_1", ".folds_2", ".folds_2",
      ".folds_2", ".folds_2", ".folds_2", ".folds_3", ".folds_3",
      ".folds_3", ".folds_3", ".folds_3", ".folds_3"),
    fixed = TRUE)
  expect_equal(
    xpectr::smpl(output_16417[["Fold"]], n = 30),
    c(4, 5, 1, 1, 1, 3, 1, 4, 5, 5, 1, 3, 4, 4, 4, 1, 2, 3, 4, 2, 2,
      3, 4, 5, 1, 1, 2, 2, 3, 4),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_16417[["ID"]], n = 30),
    structure(c(11L, 24L, 21L, 30L, 28L, 24L, 28L, 3L, 23L, 24L, 30L,
      27L, 15L, 12L, 22L, 21L, 2L, 15L, 19L, 19L, 26L, 25L, 24L, 29L,
      8L, 28L, 1L, 15L, 2L, 9L), .Label = c("1", "2", "3", "4", "5",
      "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16",
      "17", "18", "19", "20", "21", "22", "23", "24", "25", "26",
      "27", "28", "29", "30", "31", "32", "33", "34", "35", "36",
      "37", "38", "39", "40", "41", "42", "43", "44", "45", "46",
      "47", "48", "49", "50", "51", "52", "53", "54", "55", "56",
      "57", "58", "59", "60"), class = "factor"))
  expect_equal(
    xpectr::smpl(output_16417[["Target"]], n = 30),
    c("A", "B", "B", "B", "B", "B", "B", "A", "B", "B", "B", "B", "A",
      "A", "B", "B", "A", "A", "B", "B", "B", "B", "B", "B", "A",
      "B", "A", "A", "A", "A"),
    fixed = TRUE)
  expect_equal(
    xpectr::smpl(output_16417[["A"]], n = 30),
    c(0.36393, 0.12083, 0.26534, 0.21885, 0.22152, 0.1307, 0.22, 0.506,
      0.22, 0.024, 0.216, 0.442, 0.43, 0.304, 0.28, 0, 0.24051, 0.8486,
      0.48301, 0.28305, 0, 0.06542, 0.00564, 0.82806, 0.54858, 0.00413,
      0, 0.76432, 0.1525, 0),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_16417[["Prediction"]], n = 30),
    c(0.14688, 0.38609, 0.41055, 0.27878, 0.37519, 0.37871, 0.494, 0.128,
      0.524, 0.486, 0.13, 0.312, 0.06, 0.23, 0.294, 1, 0.64448, 0.0137,
      0.24638, 0.59286, 1, 0.33989, 0.22409, 0.02586, 0.0214, 0.95377,
      0, 0.12655, 0.78244, 1),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_16417[["C"]], n = 30),
    c(0.1632, 0.16882, 0.08189, 0.20212, 0.06586, 0.18908, 0.002, 0.21,
      0.094, 0.152, 0.216, 0.21, 0.43, 0.036, 0.136, 0, 0, 0.05804,
      0.05163, 0.05449, 0, 0.04494, 0.00041, 0, 0.29328, 0.00066,
      1, 0, 0.01395, 0),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_16417[["D"]], n = 30),
    c(0.32598, 0.32426, 0.24222, 0.30025, 0.33743, 0.30151, 0.284, 0.156,
      0.162, 0.338, 0.438, 0.036, 0.08, 0.43, 0.29, 0, 0.115, 0.07967,
      0.21899, 0.06961, 0, 0.54975, 0.76986, 0.14607, 0.13674, 0.04144,
      0, 0.10913, 0.05111, 0),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_16417[["Predicted Class"]], n = 30),
    c("A", "B", "B", "D", "B", "B", "B", "A", "B", "B", "D", "A", "A",
      "D", "B", "B", "B", "A", "A", "B", "B", "D", "D", "A", "A",
      "B", "C", "A", "B", "B"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_16417),
    c("Classifier", "Fold Column", "Fold", "ID", "Target", "A", "Prediction",
      "C", "D", "Predicted Class"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_16417),
    c("character", "character", "integer", "factor", "character", "numeric",
      "numeric", "numeric", "numeric", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_16417),
    c("character", "character", "integer", "integer", "character", "double",
      "double", "double", "double", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_16417),
    c(270L, 10L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_16417)),
    character(0),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = binom_data, pr...
  # Changed from baseline: prediction_cols = "O"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15190 <- xpectr::capture_side_effects(prepare_predictions_df(data = binom_data, prediction_cols = "O", target_col = "Target", cutoff = 0.5, type = "binomial"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error']]),
    xpectr::strip("1 assertions failed:\n * 'data' does not include all the prediction columns."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = binom_data, pr...
  # Changed from baseline: prediction_cols = "Ta...
  xpectr::set_test_seed(42)
  # Assigning output
  output_17365 <- prepare_predictions_df(data = binom_data, prediction_cols = "Target", target_col = "Target", cutoff = 0.5, type = "binomial")
  # Testing class
  expect_equal(
    class(output_17365),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    xpectr::smpl(output_17365[["Classifier"]], n = 30),
    c("e1071_svm", "e1071_svm", "e1071_svm", "e1071_svm", "e1071_svm",
      "e1071_svm", "randomForest", "randomForest", "randomForest",
      "randomForest", "randomForest", "randomForest", "randomForest",
      "randomForest", "randomForest", "nnet_multinom", "nnet_multinom",
      "nnet_multinom", "nnet_multinom", "nnet_multinom", "nnet_multinom",
      "nnet_multinom", "nnet_multinom", "nnet_multinom", "nnet_multinom",
      "nnet_multinom", "nnet_multinom", "nnet_multinom", "nnet_multinom",
      "nnet_multinom"),
    fixed = TRUE)
  expect_equal(
    xpectr::smpl(output_17365[["Fold Column"]], n = 30),
    c(".folds_1", ".folds_1", ".folds_2", ".folds_2", ".folds_3", ".folds_3",
      ".folds_1", ".folds_1", ".folds_1", ".folds_1", ".folds_2",
      ".folds_2", ".folds_2", ".folds_3", ".folds_3", ".folds_1",
      ".folds_1", ".folds_1", ".folds_1", ".folds_2", ".folds_2",
      ".folds_2", ".folds_2", ".folds_2", ".folds_3", ".folds_3",
      ".folds_3", ".folds_3", ".folds_3", ".folds_3"),
    fixed = TRUE)
  expect_equal(
    xpectr::smpl(output_17365[["Fold"]], n = 30),
    c(4, 5, 1, 1, 1, 3, 1, 4, 5, 5, 1, 3, 4, 4, 4, 1, 2, 3, 4, 2, 2,
      3, 4, 5, 1, 1, 2, 2, 3, 4),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_17365[["ID"]], n = 30),
    structure(c(11L, 24L, 21L, 30L, 28L, 24L, 28L, 3L, 23L, 24L, 30L,
      27L, 15L, 12L, 22L, 21L, 2L, 15L, 19L, 19L, 26L, 25L, 24L, 29L,
      8L, 28L, 1L, 15L, 2L, 9L), .Label = c("1", "2", "3", "4", "5",
      "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16",
      "17", "18", "19", "20", "21", "22", "23", "24", "25", "26",
      "27", "28", "29", "30", "31", "32", "33", "34", "35", "36",
      "37", "38", "39", "40", "41", "42", "43", "44", "45", "46",
      "47", "48", "49", "50", "51", "52", "53", "54", "55", "56",
      "57", "58", "59", "60"), class = "factor"))
  expect_equal(
    xpectr::smpl(output_17365[["Target"]], n = 30),
    c("A", "B", "B", "B", "B", "B", "B", "A", "B", "B", "B", "B", "A",
      "A", "B", "B", "A", "A", "B", "B", "B", "B", "B", "B", "A",
      "B", "A", "A", "A", "A"),
    fixed = TRUE)
  expect_equal(
    xpectr::smpl(output_17365[["A"]], n = 30),
    c(0.36393, 0.12083, 0.26534, 0.21885, 0.22152, 0.1307, 0.22, 0.506,
      0.22, 0.024, 0.216, 0.442, 0.43, 0.304, 0.28, 0, 0.24051, 0.8486,
      0.48301, 0.28305, 0, 0.06542, 0.00564, 0.82806, 0.54858, 0.00413,
      0, 0.76432, 0.1525, 0),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_17365[["Prediction"]], n = 30),
    c(0.14688, 0.38609, 0.41055, 0.27878, 0.37519, 0.37871, 0.494, 0.128,
      0.524, 0.486, 0.13, 0.312, 0.06, 0.23, 0.294, 1, 0.64448, 0.0137,
      0.24638, 0.59286, 1, 0.33989, 0.22409, 0.02586, 0.0214, 0.95377,
      0, 0.12655, 0.78244, 1),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_17365[["C"]], n = 30),
    c(0.1632, 0.16882, 0.08189, 0.20212, 0.06586, 0.18908, 0.002, 0.21,
      0.094, 0.152, 0.216, 0.21, 0.43, 0.036, 0.136, 0, 0, 0.05804,
      0.05163, 0.05449, 0, 0.04494, 0.00041, 0, 0.29328, 0.00066,
      1, 0, 0.01395, 0),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_17365[["D"]], n = 30),
    c(0.32598, 0.32426, 0.24222, 0.30025, 0.33743, 0.30151, 0.284, 0.156,
      0.162, 0.338, 0.438, 0.036, 0.08, 0.43, 0.29, 0, 0.115, 0.07967,
      0.21899, 0.06961, 0, 0.54975, 0.76986, 0.14607, 0.13674, 0.04144,
      0, 0.10913, 0.05111, 0),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_17365[["Predicted Class"]], n = 30),
    c("A", "B", "B", "D", "B", "B", "B", "A", "B", "B", "D", "A", "A",
      "D", "B", "B", "B", "A", "A", "B", "B", "D", "D", "A", "A",
      "B", "C", "A", "B", "B"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_17365),
    c("Classifier", "Fold Column", "Fold", "ID", "Target", "A", "Prediction",
      "C", "D", "Predicted Class"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_17365),
    c("character", "character", "integer", "factor", "character", "numeric",
      "numeric", "numeric", "numeric", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_17365),
    c("character", "character", "integer", "integer", "character", "double",
      "double", "double", "double", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17365),
    c(270L, 10L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_17365)),
    character(0),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = binom_data, pr...
  # Changed from baseline: prediction_cols = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11346 <- xpectr::capture_side_effects(prepare_predictions_df(data = binom_data, prediction_cols = NA, target_col = "Target", cutoff = 0.5, type = "binomial"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11346[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'prediction_cols': Contains missing values (element 1)."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11346[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = binom_data, pr...
  # Changed from baseline: prediction_cols = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16569 <- xpectr::capture_side_effects(prepare_predictions_df(data = binom_data, prediction_cols = NULL, target_col = "Target", cutoff = 0.5, type = "binomial"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'prediction_cols': Must be of type 'character', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = binom_data, pr...
  # Changed from baseline: target_col = "Predict...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17050 <- xpectr::capture_side_effects(prepare_predictions_df(data = binom_data, prediction_cols = "Prediction", target_col = "Predicted Class", cutoff = 0.5, type = "binomial"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error']]),
    xpectr::strip("1 assertions failed:\n * found more than two target classes."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = binom_data, pr...
  # Changed from baseline: target_col = "ID"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14577 <- xpectr::capture_side_effects(prepare_predictions_df(data = binom_data, prediction_cols = "Prediction", target_col = "ID", cutoff = 0.5, type = "binomial"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14577[['error']]),
    xpectr::strip("The target column must maximally contain 2 levels."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14577[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = binom_data, pr...
  # Changed from baseline: target_col = "A"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17191 <- xpectr::capture_side_effects(prepare_predictions_df(data = binom_data, prediction_cols = "Prediction", target_col = "A", cutoff = 0.5, type = "binomial"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17191[['error']]),
    xpectr::strip("1 assertions failed:\n * When 'type' is 'binomial', 'data[[target_col]]' must either have type 'character' or 'factor'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17191[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = binom_data, pr...
  # Changed from baseline: target_col = "O"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19346 <- xpectr::capture_side_effects(prepare_predictions_df(data = binom_data, prediction_cols = "Prediction", target_col = "O", cutoff = 0.5, type = "binomial"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error']]),
    xpectr::strip("1 assertions failed:\n * 'data' does not include the target column."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = binom_data, pr...
  # Changed from baseline: target_col = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12554 <- xpectr::capture_side_effects(prepare_predictions_df(data = binom_data, prediction_cols = "Prediction", target_col = NULL, cutoff = 0.5, type = "binomial"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12554[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'target_col': Must be of type 'string', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12554[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = binom_data, pr...
  # Changed from baseline: cutoff = 2
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14622 <- xpectr::capture_side_effects(prepare_predictions_df(data = binom_data, prediction_cols = "Prediction", target_col = "Target", cutoff = 2, type = "binomial"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14622[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'cutoff': Element 1 is not <= 1."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14622[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = binom_data, pr...
  # Changed from baseline: cutoff = -1
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19400 <- xpectr::capture_side_effects(prepare_predictions_df(data = binom_data, prediction_cols = "Prediction", target_col = "Target", cutoff = -1, type = "binomial"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19400[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'cutoff': Element 1 is not >= 0."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19400[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = binom_data, pr...
  # Changed from baseline: cutoff = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19782 <- xpectr::capture_side_effects(prepare_predictions_df(data = binom_data, prediction_cols = "Prediction", target_col = "Target", cutoff = NA, type = "binomial"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19782[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'cutoff': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19782[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = binom_data, pr...
  # Changed from baseline: cutoff = "0.5"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11174 <- xpectr::capture_side_effects(prepare_predictions_df(data = binom_data, prediction_cols = "Prediction", target_col = "Target", cutoff = "0.5", type = "binomial"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11174[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'cutoff': Must be of type 'number', not 'character'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11174[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = binom_data, pr...
  # Changed from baseline: cutoff = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14749 <- xpectr::capture_side_effects(prepare_predictions_df(data = binom_data, prediction_cols = "Prediction", target_col = "Target", cutoff = NULL, type = "binomial"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14749[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'cutoff': Must be of type 'number', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14749[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = binom_data, pr...
  # Changed from baseline: type = "multinomial"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15603 <- xpectr::capture_side_effects(prepare_predictions_df(data = binom_data, prediction_cols = "Prediction", target_col = "Target", cutoff = 0.5, type = "multinomial"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15603[['error']]),
    xpectr::strip("1 assertions failed:\n * when 'type' is 'multinomial' and prediction_cols has length 1, 'data[[prediction_cols]]' must have\n * type 'character'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15603[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = binom_data, pr...
  # Changed from baseline: type = "gaussian"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19040 <- xpectr::capture_side_effects(prepare_predictions_df(data = binom_data, prediction_cols = "Prediction", target_col = "Target", cutoff = 0.5, type = "gaussian"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19040[['error']]),
    xpectr::strip("1 assertions failed:\n * When 'type' is 'gaussian', 'data[[target_col]]' must be numeric."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19040[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = binom_data, pr...
  # Changed from baseline: type = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11387 <- xpectr::capture_side_effects(prepare_predictions_df(data = binom_data, prediction_cols = "Prediction", target_col = "Target", cutoff = 0.5, type = NA), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11387[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'type': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11387[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = binom_data, pr...
  # Changed from baseline: type = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19888 <- xpectr::capture_side_effects(prepare_predictions_df(data = binom_data, prediction_cols = "Prediction", target_col = "Target", cutoff = 0.5, type = NULL), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19888[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'type': Must be of type 'string', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19888[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  ## Finished testing 'prepare_predictions_df'                                ####
  #

  ### Gaussian ####

  gaussian_data <- predicted.musicians %>%
    dplyr::select(-c(Target, `Predicted Class`, C, D)) %>%
    dplyr::rename(Prediction = B,
                  Target = A)


  xpectr::set_test_seed(42)
  # xpectr::gxs_function(
  #   fn = prepare_predictions_df,
  #   args_values = list(
  #     "data" = list(gaussian_data, NA),
  #     "prediction_cols" = list("Prediction", "O", NA),
  #     "target_col" = list("Target", "ID", "O"),
  #     "cutoff" = list(0.5),
  #     "type" = list("gaussian", "binomial", "multinomial", NA)
  #   ),
  #   indentation = 2
  # )


  ## Testing 'prepare_predictions_df'                                         ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing prepare_predictions_df(data = gaussian_data,...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- prepare_predictions_df(data = gaussian_data, prediction_cols = "Prediction", target_col = "Target", cutoff = 0.5, type = "gaussian")
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    xpectr::smpl(output_19148[["Classifier"]], n = 30),
    c("e1071_svm", "e1071_svm", "e1071_svm", "e1071_svm", "e1071_svm",
      "randomForest", "randomForest", "randomForest", "randomForest",
      "randomForest", "randomForest", "randomForest", "randomForest",
      "randomForest", "randomForest", "nnet_multinom", "nnet_multinom",
      "nnet_multinom", "nnet_multinom", "nnet_multinom", "nnet_multinom",
      "nnet_multinom", "nnet_multinom", "nnet_multinom", "nnet_multinom",
      "nnet_multinom", "nnet_multinom", "nnet_multinom", "nnet_multinom",
      "nnet_multinom"),
    fixed = TRUE)
  expect_equal(
    xpectr::smpl(output_19148[["Fold Column"]], n = 30),
    c(".folds_1", ".folds_2", ".folds_2", ".folds_3", ".folds_3", ".folds_1",
      ".folds_1", ".folds_2", ".folds_2", ".folds_2", ".folds_2",
      ".folds_2", ".folds_2", ".folds_3", ".folds_3", ".folds_1",
      ".folds_1", ".folds_1", ".folds_2", ".folds_2", ".folds_2",
      ".folds_2", ".folds_3", ".folds_3", ".folds_3", ".folds_3",
      ".folds_3", ".folds_3", ".folds_3", ".folds_3"),
    fixed = TRUE)
  expect_equal(
    xpectr::smpl(output_19148[["Fold"]], n = 30),
    c(4, 1, 1, 2, 3, 2, 5, 1, 1, 1, 3, 4, 5, 4, 5, 2, 2, 3, 1, 3, 4,
      5, 1, 2, 3, 3, 4, 4, 5, 5),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_19148[["ID"]], n = 30),
    structure(c(35L, 5L, 54L, 15L, 48L, 42L, 6L, 14L, 18L, 35L, 3L,
      6L, 20L, 37L, 7L, 12L, 42L, 46L, 35L, 7L, 45L, 13L, 51L, 5L,
      13L, 43L, 37L, 56L, 26L, 59L), .Label = c("1", "2", "3", "4",
      "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15",
      "16", "17", "18", "19", "20", "21", "22", "23", "24", "25",
      "26", "27", "28", "29", "30", "31", "32", "33", "34", "35",
      "36", "37", "38", "39", "40", "41", "42", "43", "44", "45",
      "46", "47", "48", "49", "50", "51", "52", "53", "54", "55",
      "56", "57", "58", "59", "60"), class = "factor"))
  expect_equal(
    xpectr::smpl(output_19148[["Target"]], n = 30),
    c(0.0895, 0.28609, 0.23448, 0.36709, 0.17322, 0.218, 0.31, 0.376,
      0.386, 0.014, 0.482, 0.356, 0.084, 0.566, 0.362, 0.88443, 0.01643,
      1e-05, 0.00757, 0.05587, 0.00282, 0.99545, 0.06017, 0.81, 0.90717,
      0.03895, 0.99829, 0.00625, 0.37754, 0.87035),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_19148[["Prediction"]], n = 30),
    c(0.16704, 0.14521, 0.33288, 0.16154, 0.40645, 0.068, 0.328, 0.056,
      0.396, 0.158, 0.108, 0.346, 0.452, 0.076, 0.25, 0.08961, 0.00046,
      0.15984, 0.00299, 0.81576, 3e-05, 6e-05, 0.01259, 0.10164, 0.00246,
      0.0054, 0, 0, 0.61474, 0.0965),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("Classifier", "Fold Column", "Fold", "ID", "Target", "Prediction"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("character", "character", "integer", "factor", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("character", "character", "integer", "integer", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(540L, 6L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = NA, prediction...
  # Changed from baseline: data = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19370 <- xpectr::capture_side_effects(prepare_predictions_df(data = NA, prediction_cols = "Prediction", target_col = "Target", cutoff = 0.5, type = "gaussian"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19370[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'data': Must be of type 'data.frame', not 'logical'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19370[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = NULL, predicti...
  # Changed from baseline: data = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12861 <- xpectr::capture_side_effects(prepare_predictions_df(data = NULL, prediction_cols = "Prediction", target_col = "Target", cutoff = 0.5, type = "gaussian"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'data': Must be of type 'data.frame', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = gaussian_data,...
  # Changed from baseline: prediction_cols = "O"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18304 <- xpectr::capture_side_effects(prepare_predictions_df(data = gaussian_data, prediction_cols = "O", target_col = "Target", cutoff = 0.5, type = "gaussian"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error']]),
    xpectr::strip("1 assertions failed:\n * 'data' does not include all the prediction columns."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = gaussian_data,...
  # Changed from baseline: prediction_cols = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16417 <- xpectr::capture_side_effects(prepare_predictions_df(data = gaussian_data, prediction_cols = NA, target_col = "Target", cutoff = 0.5, type = "gaussian"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'prediction_cols': Contains missing values (element 1)."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = gaussian_data,...
  # Changed from baseline: prediction_cols = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15190 <- xpectr::capture_side_effects(prepare_predictions_df(data = gaussian_data, prediction_cols = NULL, target_col = "Target", cutoff = 0.5, type = "gaussian"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'prediction_cols': Must be of type 'character', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = gaussian_data,...
  # Changed from baseline: target_col = "ID"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17365 <- xpectr::capture_side_effects(prepare_predictions_df(data = gaussian_data, prediction_cols = "Prediction", target_col = "ID", cutoff = 0.5, type = "gaussian"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17365[['error']]),
    xpectr::strip("1 assertions failed:\n * When 'type' is 'gaussian', 'data[[target_col]]' must be numeric."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17365[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = gaussian_data,...
  # Changed from baseline: target_col = "O"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11346 <- xpectr::capture_side_effects(prepare_predictions_df(data = gaussian_data, prediction_cols = "Prediction", target_col = "O", cutoff = 0.5, type = "gaussian"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11346[['error']]),
    xpectr::strip("1 assertions failed:\n * 'data' does not include the target column."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11346[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = gaussian_data,...
  # Changed from baseline: target_col = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16569 <- xpectr::capture_side_effects(prepare_predictions_df(data = gaussian_data, prediction_cols = "Prediction", target_col = NULL, cutoff = 0.5, type = "gaussian"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'target_col': Must be of type 'string', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = gaussian_data,...
  # Changed from baseline: cutoff = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17050 <- xpectr::capture_side_effects(prepare_predictions_df(data = gaussian_data, prediction_cols = "Prediction", target_col = "Target", cutoff = NULL, type = "gaussian"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'cutoff': Must be of type 'number', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = gaussian_data,...
  # Changed from baseline: type = "binomial"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14577 <- xpectr::capture_side_effects(prepare_predictions_df(data = gaussian_data, prediction_cols = "Prediction", target_col = "Target", cutoff = 0.5, type = "binomial"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14577[['error']]),
    xpectr::strip("1 assertions failed:\n * When 'type' is 'binomial', 'data[[target_col]]' must either have type 'character' or 'factor'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14577[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = gaussian_data,...
  # Changed from baseline: type = "multinomial"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17191 <- xpectr::capture_side_effects(prepare_predictions_df(data = gaussian_data, prediction_cols = "Prediction", target_col = "Target", cutoff = 0.5, type = "multinomial"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17191[['error']]),
    xpectr::strip("1 assertions failed:\n * When 'type' is 'multinomial', 'data[[target_col]]' must either have type 'character' or 'factor'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17191[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = gaussian_data,...
  # Changed from baseline: type = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19346 <- xpectr::capture_side_effects(prepare_predictions_df(data = gaussian_data, prediction_cols = "Prediction", target_col = "Target", cutoff = 0.5, type = NA), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'type': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing prepare_predictions_df(data = gaussian_data,...
  # Changed from baseline: type = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12554 <- xpectr::capture_side_effects(prepare_predictions_df(data = gaussian_data, prediction_cols = "Prediction", target_col = "Target", cutoff = 0.5, type = NULL), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12554[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'type': Must be of type 'string', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12554[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  ## Finished testing 'prepare_predictions_df'                                ####
  #
})

test_that("MAE and Cross-Entropy metrics are correctly calculated in most_challenging()", {
  xpectr::set_test_seed(42)

  # Binomial
  binom_data <- predicted.musicians %>%
    dplyr::filter(Target %in% c("A", "B")) %>%
    dplyr::mutate(Prob = A,
                  Targ = ifelse(Target == "A", 1, 0),
                  Targ_chr = as.character(Targ)) %>%
    dplyr::select(Classifier, ID, Prob, Targ, Targ_chr)

  most_challenging_binom <- binom_data %>%
    dplyr::group_by(Classifier) %>%
    most_challenging(
      type = "binomial",
      obs_id_col = "ID",
      target_col = "Targ_chr",
      prediction_cols = "Prob",
      threshold = 0.9999
    )

  expected_binom_metrics <- binom_data %>%
    dplyr::mutate(Prob = Prob + .Machine$double.eps) %>%
    dplyr::group_by(Classifier, ID) %>%
    dplyr::summarise(
      MAE = mean(abs(Targ - Prob)),
      CEP = mean(-Targ*log(Prob) - (1-Targ)*log(1-Prob))
    )
  expected_binom_metrics <- most_challenging_binom %>%
    dplyr::select(Classifier, ID) %>%
    dplyr::left_join(expected_binom_metrics, by = c("Classifier", "ID"))

  expect_equal(expected_binom_metrics$Classifier, most_challenging_binom$Classifier)
  expect_equal(expected_binom_metrics$ID, most_challenging_binom$ID)
  expect_equal(expected_binom_metrics$MAE, most_challenging_binom$MAE)
  expect_equal(expected_binom_metrics$CEP, most_challenging_binom$`Cross Entropy`)

  ## Testing 'most_challenging_binom'                                       ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(most_challenging_binom),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    xpectr::smpl(most_challenging_binom[["Classifier"]], n = 30),
    c("e1071_svm", "e1071_svm", "e1071_svm", "e1071_svm", "e1071_svm",
      "e1071_svm", "e1071_svm", "e1071_svm", "nnet_multinom", "nnet_multinom",
      "nnet_multinom", "nnet_multinom", "nnet_multinom", "nnet_multinom",
      "nnet_multinom", "nnet_multinom", "nnet_multinom", "nnet_multinom",
      "randomForest", "randomForest", "randomForest", "randomForest",
      "randomForest", "randomForest", "randomForest", "randomForest",
      "randomForest", "randomForest", "randomForest", "randomForest"),
    fixed = TRUE)
  expect_equal(
    xpectr::smpl(most_challenging_binom[["ID"]], n = 30),
    structure(c(11L, 14L, 5L, 15L, 26L, 25L, 21L, 20L, 7L, 29L, 2L,
      4L, 11L, 6L, 30L, 3L, 23L, 18L, 11L, 1L, 2L, 8L, 12L, 4L, 3L,
      27L, 19L, 18L, 28L, 25L), .Label = c("1", "2", "3", "4", "5",
      "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16",
      "17", "18", "19", "20", "21", "22", "23", "24", "25", "26",
      "27", "28", "29", "30", "31", "32", "33", "34", "35", "36",
      "37", "38", "39", "40", "41", "42", "43", "44", "45", "46",
      "47", "48", "49", "50", "51", "52", "53", "54", "55", "56",
      "57", "58", "59", "60"), class = "factor"))
  expect_equal(
    xpectr::smpl(most_challenging_binom[["Correct"]], n = 30),
    c(0, 0, 0, 0, 3, 3, 3, 3, 0, 0, 0, 0, 1, 2, 3, 3, 3, 3, 0, 0, 0,
      0, 0, 0, 1, 3, 3, 3, 3, 3),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(most_challenging_binom[["Incorrect"]], n = 30),
    c(3, 3, 3, 3, 0, 0, 0, 0, 3, 3, 3, 3, 2, 1, 0, 0, 0, 0, 3, 3, 3,
      3, 3, 3, 2, 0, 0, 0, 0, 0),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(most_challenging_binom[["Accuracy"]], n = 30),
    c(0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0.33333, 0.66667, 1, 1, 1,
      1, 0, 0, 0, 0, 0, 0, 0.33333, 1, 1, 1, 1, 1),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(most_challenging_binom[["MAE"]], n = 30),
    c(0.6841, 0.65354, 0.65199, 0.62608, 0.34973, 0.19011, 0.18335,
      0.17775, 0.92822, 0.88341, 0.84085, 0.69853, 0.63301, 0.41821,
      0.06499, 0.02796, 0.00626, 0.0055, 0.802, 0.74867, 0.704, 0.642,
      0.63867, 0.56467, 0.524, 0.41467, 0.32733, 0.296, 0.26267, 0.18333),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(most_challenging_binom[["Cross Entropy"]], n = 30),
    c(1.15884, 1.07172, 1.0647, 0.98399, 0.43354, 0.21299, 0.20842,
      0.19584, 2.70825, 2.35013, 1.92574, 1.3643, 1.041, 0.56474,
      0.06732, 0.02838, 0.00629, 0.00553, 1.64567, 1.44839, 1.22412,
      1.04058, 1.03159, 0.83835, 0.744, 0.53855, 0.39652, 0.37442,
      0.30556, 0.20339),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(most_challenging_binom[["<="]], n = 30),
    c(0.09199, 0.09199, 0.09199, 0.09199, 0.09199, 0.09199, 0.09199,
      0.09199, 0.00145, 0.00145, 0.00145, 0.00145, 0.00145, 0.00145,
      0.00145, 0.00145, 0.00145, 0.00145, 0.02602, 0.02602, 0.02602,
      0.02602, 0.02602, 0.02602, 0.02602, 0.02602, 0.02602, 0.02602,
      0.02602, 0.02602),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(most_challenging_binom),
    c("Classifier", "ID", "Correct", "Incorrect", "Accuracy", "MAE",
      "Cross Entropy", "<="),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(most_challenging_binom),
    c("character", "factor", "integer", "integer", "numeric", "numeric",
      "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(most_challenging_binom),
    c("character", "integer", "integer", "integer", "double", "double",
      "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(most_challenging_binom),
    c(87L, 8L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(most_challenging_binom)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'most_challenging_binom'                              ####


  # Multinomial

  multinom_data <- predicted.musicians %>%
    dplyr::mutate(ProbOfTarget = dplyr::case_when(
      Target == "A" ~ A,
      Target == "B" ~ B,
      Target == "C" ~ C,
      Target == "D" ~ D,
      TRUE ~ -1
    ), Target_dbl = 1)

  most_challenging_multinom <- multinom_data %>%
    dplyr::group_by(Classifier) %>%
    most_challenging(
      type = "multinomial",
      obs_id_col = "ID",
      target_col = "Target",
      prediction_cols = c("A", "B", "C", "D"),
      threshold = 0.99999
    )

  expected_multinom_metrics <- multinom_data %>%
    dplyr::mutate(ProbOfTarget = ProbOfTarget + .Machine$double.eps) %>%
    dplyr::group_by(Classifier, ID) %>%
    dplyr::summarise(
      MAE = mean(abs(1 - ProbOfTarget)),
      CEP = mean(-log(ProbOfTarget))
    )
  expected_multinom_metrics <- most_challenging_multinom %>%
    dplyr::select(Classifier, ID) %>%
    dplyr::left_join(expected_multinom_metrics, by = c("Classifier", "ID"))

  expect_equal(expected_multinom_metrics$Classifier, most_challenging_multinom$Classifier)
  expect_equal(expected_multinom_metrics$ID, most_challenging_multinom$ID)
  expect_equal(expected_multinom_metrics$MAE, most_challenging_multinom$MAE)
  expect_equal(expected_multinom_metrics$CEP, most_challenging_multinom$`Cross Entropy`)


  ## Testing 'most_challenging_multinom'                                    ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(most_challenging_multinom),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    xpectr::smpl(most_challenging_multinom[["Classifier"]], n = 30),
    c("e1071_svm", "e1071_svm", "e1071_svm", "e1071_svm", "e1071_svm",
      "e1071_svm", "e1071_svm", "nnet_multinom", "nnet_multinom",
      "nnet_multinom", "nnet_multinom", "nnet_multinom", "nnet_multinom",
      "nnet_multinom", "randomForest", "randomForest", "randomForest",
      "randomForest", "randomForest", "randomForest", "randomForest",
      "randomForest", "randomForest", "randomForest", "randomForest",
      "randomForest", "randomForest", "randomForest", "randomForest",
      "randomForest"),
    fixed = TRUE)
  expect_equal(
    xpectr::smpl(most_challenging_multinom[["ID"]], n = 30),
    structure(c(59L, 2L, 44L, 39L, 31L, 18L, 45L, 22L, 2L, 39L, 58L,
      31L, 35L, 46L, 9L, 51L, 30L, 16L, 29L, 2L, 25L, 35L, 39L, 14L,
      34L, 4L, 3L, 45L, 41L, 55L), .Label = c("1", "2", "3", "4",
      "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15",
      "16", "17", "18", "19", "20", "21", "22", "23", "24", "25",
      "26", "27", "28", "29", "30", "31", "32", "33", "34", "35",
      "36", "37", "38", "39", "40", "41", "42", "43", "44", "45",
      "46", "47", "48", "49", "50", "51", "52", "53", "54", "55",
      "56", "57", "58", "59", "60"), class = "factor"))
  expect_equal(
    xpectr::smpl(most_challenging_multinom[["Correct"]], n = 30),
    c(0, 0, 1, 3, 3, 3, 3, 0, 0, 1, 0, 2, 1, 3, 0, 0, 0, 0, 0, 0, 0,
      0, 2, 0, 2, 2, 3, 1, 1, 3),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(most_challenging_multinom[["Incorrect"]], n = 30),
    c(3, 3, 2, 0, 0, 0, 0, 3, 3, 2, 3, 1, 2, 0, 3, 3, 3, 3, 3, 3, 3,
      3, 1, 3, 1, 1, 0, 2, 2, 0),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(most_challenging_multinom[["Accuracy"]], n = 30),
    c(0, 0, 0.33333, 1, 1, 1, 1, 0, 0, 0.33333, 0, 0.66667, 0.33333,
      1, 0, 0, 0, 0, 0, 0, 0, 0, 0.66667, 0, 0.66667, 0.66667, 1,
      0.33333, 0.33333, 1),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(most_challenging_multinom[["MAE"]], n = 30),
    c(0.73663, 0.70442, 0.68708, 0.68657, 0.62123, 0.54004, 0.45296,
      0.94263, 0.84085, 0.82611, 0.75131, 0.60734, 0.57579, 0.0761,
      0.96533, 0.948, 0.852, 0.83467, 0.74667, 0.704, 0.67933, 0.66467,
      0.63333, 0.61867, 0.60267, 0.56467, 0.524, 0.522, 0.50867, 0.422),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(most_challenging_multinom[["Cross Entropy"]], n = 30),
    c(1.34786, 1.21968, 1.16408, 1.16089, 0.973, 0.79923, 0.61219, 3.87839,
      1.92574, 6.1247, 1.50762, 0.95519, 0.88109, 0.08152, 3.88637,
      3.01404, 1.91605, 1.83304, 1.38103, 1.22412, 1.13882, 1.09287,
      1.05492, 0.96566, 0.92832, 0.83835, 0.744, 0.75197, 0.77721,
      0.54978),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(most_challenging_multinom[["<="]], n = 30),
    c(0.42038, 0.42038, 0.42038, 0.42038, 0.42038, 0.42038, 0.42038,
      0.01457, 0.01457, 0.01457, 0.01457, 0.01457, 0.01457, 0.01457,
      0.26336, 0.26336, 0.26336, 0.26336, 0.26336, 0.26336, 0.26336,
      0.26336, 0.26336, 0.26336, 0.26336, 0.26336, 0.26336, 0.26336,
      0.26336, 0.26336),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(most_challenging_multinom),
    c("Classifier", "ID", "Correct", "Incorrect", "Accuracy", "MAE",
      "Cross Entropy", "<="),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(most_challenging_multinom),
    c("character", "factor", "integer", "integer", "numeric", "numeric",
      "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(most_challenging_multinom),
    c("character", "integer", "integer", "integer", "double", "double",
      "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(most_challenging_multinom),
    c(177L, 8L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(most_challenging_multinom)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'most_challenging_multinom'                           ####


})
