% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/journey.R
\name{json2sf_cs}
\alias{json2sf_cs}
\title{Convert output from CycleStreets.net into sf object}
\usage{
json2sf_cs(obj, cols = NULL)
}
\arguments{
\item{obj}{Object from CycleStreets.net read-in with}

\item{cols}{Columns to be included in the result, a character vector or \code{NULL} for all available columns (see details for default)}
}
\description{
Convert output from CycleStreets.net into sf object
}
\examples{
from = "Leeds Rail Station"
to = "University of Leeds"
# save result from the API call to journey.json
# res_json = stplanr::route_cyclestreet(from, to, silent = FALSE, save_raw = TRUE)
# jsonlite::write_json(res_json, "inst/extdata/journey.json")
f = system.file(package = "cyclestreets", "extdata/journey.json")
obj = jsonlite::read_json(f, simplifyVector = TRUE)
rsf = json2sf_cs(obj)
sf:::plot.sf(rsf)
json2sf_cs(obj, cols = c("time", "busynance", "elevations"))
}
