% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch.R
\name{batch}
\alias{batch}
\title{Interface to CycleStreets Batch Routing API}
\usage{
batch(
  desire_lines,
  directory = tempdir(),
  wait_time = NULL,
  name = "test batch",
  serverId = 21,
  strategies = "quietest",
  bothDirections = 0,
  minDistance = 50,
  maxDistance = 5000,
  filename = "test",
  includeJsonOutput = 1,
  emailOnCompletion = "you@example.com",
  username = "yourname",
  password = Sys.getenv("CYCLESTREETS_PW"),
  base_url = "https://api.cyclestreets.net/v2/batchroutes.createjob",
  id = NULL,
  pat = Sys.getenv("CYCLESTREETS_BATCH"),
  silent = TRUE
)
}
\arguments{
\item{desire_lines}{Geographic desire lines representing origin-destination data}

\item{directory}{Where to save the data? \code{tempdir()} by default}

\item{wait_time}{How long to wait before getting the data in seconds?
NULL by default, meaning it will be calculated by the private function
\code{wait_s()}.}

\item{name}{The name of the batch routing job for CycleStreets}

\item{serverId}{The server ID to use (21 by default)}

\item{strategies}{Route plan types, e.g. \code{"fastest"}}

\item{bothDirections}{int (1|0)
Whether to plan in both directions, i.e. A-B as well as B-A.
0, meaning only one way routes, is the default in the R default.}

\item{minDistance}{Min Euclidean distance of routes to be calculated}

\item{maxDistance}{Maximum Euclidean distance of routes to be calculated}

\item{filename}{Character string}

\item{includeJsonOutput}{int (1|0)
Whether to include a column in the resulting CSV data giving the full JSON output from the API, rather than just summary
information like distance and time.}

\item{emailOnCompletion}{Email on completion?}

\item{username}{string
Your CycleStreets account username. In due course this will be replaced with an OAuth token.}

\item{password}{string
Your CycleStreets account password. You can set it with
Sys.setenv(CYCLESTREETS_PW="xxxxxx")}

\item{base_url}{The base url from which to construct API requests
(with default set to main server)}

\item{id}{int
Batch job ID, as returned from batchroutes.createjob.
action string (start|pause|continue|terminate)
Action to take. Available actions are:
start: Start (open) job
pause: Pause job
continue: Continue (re-open) job
terminate: Terminate job and delete data}

\item{pat}{The API key used. By default this uses \code{Sys.getenv("CYCLESTREETS")}.}

\item{silent}{Logical (default is FALSE). TRUE hides request sent.}
}
\description{
Note: set \code{CYCLESTREETS_BATCH} and \code{CYCLESTREETS_PW}
environment variables, e.g. with \code{usethis::edit_r_environ()}
before trying this.
}
\examples{
if(FALSE) {
library(sf)
desire_lines = od::od_to_sf(od::od_data_df, od::od_data_zones)[4:5, 1:3]
u = paste0("https://github.com/cyclestreets/cyclestreets-r/",
  "releases/download/v0.5.3/od-longford-10-test.Rds")
desire_lines = readRDS(url(u))
routes = batch(desire_lines, username = "robinlovelace")
names(routes)
plot(routes$geometry)
plot(desire_lines$geometry, add = TRUE, col = "red")
routes = batch(desire_lines, username = "robinlovelace", wait_time = 5)
}
}
