% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cyl_quadsec.R
\docType{class}
\name{cyl_quadsec-class}
\alias{cyl_quadsec-class}
\title{An S4 Class of Bivariate Copulas with Quadratic Sections}
\description{
This class contains bivariate circular-linear copulas with quadratic sections
 in the linear dimension. They are periodic in the circular dimension, u,
 and symmetric with respect to u=0.5. I.e the can capture correlation in data
 where there is symmetry between positive and negative angles. These copulas
 are described by one parameter, \code{a}.
}
\section{Slots}{

\describe{
\item{\code{name}}{\link[base]{character} string holding the name of the copula.}

\item{\code{parameters}}{\link[base]{numeric} \link[base]{vector} holding the
parameter value.}

\item{\code{param.names}}{\link[base]{character} \link[base]{vector} holding the
parameter name.}

\item{\code{param.lowbnd}}{\link[base]{numeric} \link[base]{vector} holding the lower
bound of the parameter.}

\item{\code{param.upbnd}}{\link[base]{numeric} \link[base]{vector} holding the upper
bound of the parameter.}
}}

\section{Objects from the Class}{

Objects are created by \code{\link{cyl_quadsec}()}.
}

\section{Extends}{

Class '\code{cyl_quadsec}' extends class '\code{\linkS4class{cyl_copula}}'.
}

\references{
\insertRef{Quesada-Molina1995}{cylcop}

\insertRef{Hodelappl}{cylcop}

\insertRef{Hodelmethod}{cylcop}
}
