% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/density.R
\name{dens}
\alias{dens}
\alias{ddens}
\alias{pdens}
\alias{qdens}
\alias{rdens}
\title{Density, Distribution, Random Number Generation and Quantiles of Kernel Density Estimates}
\usage{
rdens(n, density)

ddens(x, density)

pdens(x, density)

qdens(p, density)
}
\arguments{
\item{n}{\link[base]{integer} value, the number of random samples to be
generated with \code{rdens()}.}

\item{density}{\link[base]{list} containing information about the kernel density
estimate. The structure of the list must be as returned by
\code{\link{fit_angle}()} or \code{\link{fit_steplength}()}.}

\item{x}{\link[base]{numeric} \link[base]{vector} giving the points where
the density or distribution function is evaluated.}

\item{p}{\link[base]{numeric} \link[base]{vector} giving the probabilities where
the quantile function is evaluated.}
}
\value{
\code{ddens()} and \code{pdens()} give a \link[base]{vector} of length \code{length(x)} containing
the density or distribution function at the corresponding values of \code{x}.
\code{qdens()} gives a \link[base]{vector} of length \code{length(p)} containing
the quantiles at the corresponding values of \code{p}. The function \code{rdens()}
generates a \link[base]{vector} of length \code{n} containing the random samples.
}
\description{
Calculate the density (\code{ddens()}), the distribution (\code{pdens()}),
 the quantiles (\code{qdens()}) and generate random
samples (\code{rdens()}) of a kernel density estimate as returned by
\code{\link{fit_angle}()} or \code{\link{fit_steplength}()}.
}
\examples{
set.seed(123)

steps <- rweibull(10, shape=3)
dens <- fit_steplength(x = steps, parametric = FALSE)
ddens(c(0.1,0.3), dens)
pdens(c(0.1,0.3), dens)
qdens(c(0.1,0.3), dens)
rdens(4, dens)

}
\seealso{
\code{\link{fit_angle}()}, \code{\link{fit_steplength}()},
\code{\link{fit_steplength}()}.
}
