% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d3po.R
\name{d3po-shiny}
\alias{d3po-shiny}
\alias{d3po_output}
\alias{render_d3po}
\alias{d3po_proxy}
\title{Shiny bindings for 'd3po'}
\usage{
d3po_output(output_id, width = "100\%", height = "400px")

render_d3po(expr, env = parent.frame(), quoted = FALSE)

d3po_proxy(id, session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{output_id}{output variable to read from}

\item{width, height}{Must be a valid CSS unit (like \code{'100\%'},
\code{'400px'}, \code{'auto'}) or a number, which will be coerced to a
string and have \code{'px'} appended.}

\item{expr}{An expression that generates a d3po object}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
is useful if you want to save an expression in a variable.}

\item{id}{Id of plot to create a proxy of.}

\item{session}{A valid shiny session.}
}
\value{
Creates a basic 'htmlwidget' object for 'Shiny' and interactive documents
}
\description{
Output and render functions for using d3po within Shiny
applications and interactive Rmd documents.
}
