% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/generateEquations.R
\name{generateEquations}
\alias{generateEquations}
\title{Generate equations from data.frame(s)}
\usage{
generateEquations(..., volumes = NULL)
}
\arguments{
\item{...}{one or more \code{data.frame}s with columns "Description" (character), "Rate" (character),
and one column per ODE state with the state names. The state columns correspond to the stoichiometric
matrix.}

\item{volumes}{Named character, volume parameters for species. Names must be a subset of the species.
Values can be either characters, e.g. "V1", or numeric values for the volume. If \code{volumes} is not
\code{NULL}, missing species are treated like 1.}
}
\value{
An object of class \code{eqnList}, a named vector with the equations. Contains attributes "SMatrix"
(the stoichiometric matrix), "species" (the state names), "rates" (the rate expressions) and "description".
}
\description{
Generate equations from data.frame(s)
}
\details{
This function is supposed to translate a reaction network as being defined in a csv file
into the raw equations.
}
\examples{
#######################################
# Example 1
#######################################
reactions <- data.frame(Description = c("Activation", "Deactivation"),
                        Rate = c("act*A", "deact*pA"), A=c(-1,1), pA=c(1, -1) )
f <- generateEquations(reactions)
f

#######################################
# Example 2
#######################################
reactions <- data.frame(Description = c("Activation", "Deactivation", "Production", "Degradation"),
                        Rate = c("act*A", "deact*pA", "prod", "degrad*pA"),
                        A=c(-1,1, 1, NA),
                        pA=c(1, -1, NA, -1))
volumes <- c(A = "V1", pA = "V2")
f <- generateEquations(reactions, volumes = volumes)
f[1:length(f)]
}

