% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotArray}
\alias{plotArray}
\title{Plot an array of model predictions for a list of parameters}
\usage{
plotArray(parframe, x, times, data = NULL, ..., fixed = NULL,
  deriv = FALSE, scales = "free", facet = "wrap")
}
\arguments{
\item{parframe}{Object of class \code{parframe}, e.g. returned by \link{mstrust} or \link{profile}}

\item{x}{The model prediction function \code{x(times, pars, fixed, ...)}}

\item{times}{Numeric vector of time points for the model prediction}

\item{data}{Named list of data.frames as being used in \link{res}, i.e. with columns \code{name}, \code{time}, 
\code{value} and \code{sigma}.}

\item{...}{Further arguments going to \code{subset}.}

\item{fixed}{Named numeric vector with fixed parameters}

\item{deriv}{Logical. If \code{x} supports the argument \code{deriv}, it is used.}

\item{scales}{The scales argument of \code{facet_wrap} or \code{facet_grid}, i.e. \code{"free"}, \code{"fixed"}, 
\code{"free_x"} or \code{"free_y"}}

\item{facet}{Either \code{"wrap"} or \code{"grid"}}
}
\value{
A plot object of class \code{ggplot}.
}
\description{
Plot an array of model predictions for a list of parameters
}
\details{
The data.frame being plotted has columns \code{time}, \code{value}, \code{sigma},
\code{name} and \code{condition}.
}
\examples{
## Generate a prediction function
regfn <- c(y = "sin(a*time)")

g <- Y(regfn, parameters = "a")
x <- Xt(condition = "C1")

## Generate data
data <- datalist(
  C1 = data.frame(
    name = "y",
    time = 1:5,
    value = sin(1:5) + rnorm(5, 0, .1),
    sigma = .1
  )
)

## Initialize parameters and time 
pars <- c(a = 1)
times <- seq(0, 5, .1)

plot((g*x)(times, pars), data)

## Do many fits from random positions and store them into parlist
out <- as.parlist(lapply(1:50, function(i) {
  trust(normL2(data, g*x), pars + rnorm(length(pars), 0, 1), rinit = 1, rmax = 10)
}))

summary(out)

## Reduce parlist to parframe
parframe <- as.parframe(out)
plotValues(parframe)

## Reduce parframe to best fit
bestfit <- as.parvec(parframe)
plot((g*x)(times, bestfit), data)

## Plot array with all solutions
plotArray(parframe, g*x, times, data)
}

