% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{compare}
\alias{compare}
\alias{compare.list}
\alias{compare.character}
\alias{compare.eqnvec}
\alias{compare.data.frame}
\title{Compare two objects and return differences}
\usage{
compare(vec1, ...)

\method{compare}{list}(vec1, vec2 = NULL, reference = 1, ...)

\method{compare}{character}(vec1, vec2 = NULL, ...)

\method{compare}{eqnvec}(vec1, vec2 = NULL, ...)

\method{compare}{data.frame}(vec1, vec2 = NULL, ...)
}
\arguments{
\item{vec1}{object of class \link{eqnvec}, \code{character} or
\code{data.frame}. Alternatively, a list of such objects.}

\item{...}{arguments going to the corresponding methods}

\item{vec2}{same as vec1. Not used if vec1 is a list.}

\item{reference}{numeric of length one, the reference entry.}
}
\value{
\code{data.frame} or list of data.frames with the differences.
}
\description{
Works eigher on a list or on two arguments. In case of a list,
comparison is done with respect to a reference entry. Besides the
objects themselves also some of their attributes are compared,
i.e. "equations", "parameters" and "events" and "forcings".
}
\examples{
## Compare equation vectors
eq1 <- eqnvec(a = "-k1*a + k2*b", b = "k2*a - k2*b")
eq2 <- eqnvec(a = "-k1*a", b = "k2*a - k2*b", c = "k2*b")
compare(eq1, eq2)

## Compare character vectors
c1 <- c("a", "b")
c2 <- c("b", "c")
compare(c1, c2)

## Compare data.frames
d1 <- data.frame(var = "a", time = 1, value = 1:3, method = "replace")
d2 <- data.frame(var = "a", time = 1, value = 2:4, method = "replace")
compare(d1, d2)

## Compare structures like prediction functions
fn1 <- function(x) x^2
attr(fn1, "equations") <- eq1
attr(fn1, "parameters") <- c1
attr(fn1, "events") <- d1

fn2 <- function(x) x^3
attr(fn2, "equations") <- eq2
attr(fn2, "parameters") <- c2
attr(fn2, "events") <- d2

mylist <- list(f1 = fn1, f2 = fn2)
compare(mylist)
}
