% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eqnClass.R
\name{getReactions}
\alias{getReactions}
\title{Generate a table of reactions (data.frame) from an equation list}
\usage{
getReactions(eqnlist)
}
\arguments{
\item{eqnlist}{object of class \link{eqnlist}}
}
\value{
\code{data.frame} with educts, products, rate and description. The first
column is a check if the reactions comply with reaction kinetics.
}
\description{
Generate a table of reactions (data.frame) from an equation list
}
\examples{

  # Write your example here. You can also add more Start..End blocks if needed.
  # Please mask all output such as print() with the special tag
  #    
  # such that the test is not littered. Statements guarded by  are enabled
  # in the example file which is extracted from this test file. To extract the
  # example run
  #    extractExamples()
  # on the R command line.
    
    ## Generate another equation list
    eq <- eqnlist()
    eq <- addReaction(eq, "A", "pA", "act_A * A * stimulus", "Phosphorylation of A")
    eq <- addReaction(eq, "pA", "A", "deact_A * pA", "Deposphorylation of pA")
    eq <- addReaction(eq, "2*pA", "pA_pA", "form_complex_pA * pA^2", "Complex formation of pA")
    eq <- addReaction(eq, "B", "pB", "act_B * B * pA_pA", "Phosphorylation of B")
    eq <- addReaction(eq, "pB", "B", "deact_B * pB", "Deposphorylation of pB")
    
    ## Extract data.frame of reactions
    reactions <- getReactions(eq)
     print(reactions)
    
    ## Get conserved quantities
    cq <- conservedQuantities(eq$smatrix)
     print(cq)
    
    ## Get fluxes
    fluxes <- getFluxes(eq)
     print(fluxes)
    
    ## Subsetting of equation list
    subeq1 <- subset(eq, "pB" \%in\% Product)
     print(subeq1)
    subeq2 <- subset(eq, grepl("not_available", Description))
     print(subeq2)
    
    ## Time derivatives of observables
    observables <- eqnvec(pA_obs = "s1*pA", tA_obs = "s2*(A + pA)")
    dobs <- dot(observables, eq)
    
    ## Combined equation vector for ODE and observables
    f <- c(as.eqnvec(eq), dobs)
     print(f)
    
    
  
}
