% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processors.R
\name{create_processor}
\alias{create_processor}
\title{Create processor}
\usage{
create_processor(
  name,
  type = "OCR_PROCESSOR",
  proj_id = get_project_id(),
  loc = "eu",
  token = dai_token()
)
}
\arguments{
\item{name}{a string; the proposed display name of the processor.}

\item{type}{a string; one of "OCR_PROCESSOR",
"FORM_PARSER_PROCESSOR", "INVOICE_PROCESSOR", or
"US_DRIVER_LICENSE_PROCESSOR".}

\item{proj_id}{a GCS project id.}

\item{loc}{a two-letter region code; "eu" or "us".}

\item{token}{an authentication token generated by \code{dai_auth()} or
another auth function.}
}
\value{
a processor id if successful, otherwise NULL.
}
\description{
Create processor
}
\details{
Creates a Document AI processor and returns the id of the
newly created processor. Note that the proposed processor name may
already be taken; if so, try again with another name. Consider
storing the processor id in an environment variable named
DAI_PROCESSOR_ID. For more information about processors, see the
Google Document AI documentation at
\url{https://cloud.google.com/document-ai/docs/}.
}
\examples{
\dontrun{
proc_id <- create_processor("my-processor-123")
}
}
