% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_fil_ema.R
\name{ts_fil_ema}
\alias{ts_fil_ema}
\title{Time Series Exponential Moving Average}
\usage{
ts_fil_ema(ema = 3)
}
\arguments{
\item{ema}{exponential moving average size}
}
\value{
a \code{ts_fil_ema} object.
}
\description{
Used to smooth out fluctuations, while giving more weight to
recent observations. Particularly useful when the data has a trend or
seasonality component.
}
\examples{
# time series with noise
data(sin_data)
sin_data$y[9] <- 2*sin_data$y[9]
# convert to sliding windows
ts <- ts_data(sin_data$y, 10)
ts_head(ts, 3)
summary(ts[,10])

# filter
filter <- ts_fil_ema(ema = 3)
filter <- fit(filter, sin_data$y)
y <- transform(filter, sin_data$y)

# plot
plot_ts_pred(y=sin_data$y, yadj=y)
}
