% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cla_dtree.R
\name{cla_dtree}
\alias{cla_dtree}
\title{Decision Tree for classification}
\usage{
cla_dtree(attribute, slevels)
}
\arguments{
\item{attribute}{attribute target to model building}

\item{slevels}{the possible values for the target classification}
}
\value{
returns a classification object
}
\description{
Creates a classification object that
uses the Decision Tree algorithm for classification.
It wraps the tree library.
}
\examples{
data(iris)
slevels <- levels(iris$Species)
model <- cla_dtree("Species", slevels)

# preparing dataset for random sampling
sr <- sample_random()
sr <- train_test(sr, iris)
train <- sr$train
test <- sr$test

model <- fit(model, train)

prediction <- predict(model, test)
predictand <- adjust_class_label(test[,"Species"])
test_eval <- evaluate(model, predictand, prediction)
test_eval$metrics
}
