% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotOBOS.R
\name{plotOBOS}
\alias{plotOBOS}
\title{Plot Overbought/Oversold Regions for A Stock or ETF}
\usage{
plotOBOS(symbol, n = 50, type = c("sma", "ema", "zlema", "hma"),
  years = 1, blue = TRUE, current = TRUE, title = symbol,
  ticks = TRUE, axes = TRUE)
}
\arguments{
\item{symbol}{A (required) character string for stock symbol, or
alternatively a \code{xts} or \code{zoo} object with data}

\item{n}{An optional integer for the moving average length,
defaults to 50}

\item{type}{An optional character string for the type of moving
average; currently supported are \sQuote{SMA}, \sQuote{EMA},
\sQuote{ZLEMA}, and \sQuote{HMA}.}

\item{years}{An optional numeric or integer value for the number
of years of data to display, defaults to one}

\item{blue}{An optional boolean determining whether blue or gray
tones are used, defaults to true implying blue tones}

\item{current}{An optional boolean determining whether the current
date is the end date}

\item{title}{An optional character string for the plot title, defaults
to the symbol}

\item{ticks}{An optional boolean indicating whether ticks are plotted,
passed on to \code{plot.xts}, defaults to true}

\item{axes}{An optional boolean indicating whether axes are plotted,
passed on to \code{plot.xts}, defaults to true}
}
\value{
\code{NULL} as the function is invoked for the side effect of
the plot
}
\description{
Compute and display overbought and oversold regions
}
\details{
This function computes a smoothed version of the price using a
moving average (with one of several possible methods) as well as a
standard deviation band, and displays one and two standard
deviations around the smoothed price.
}
\author{
Dirk Eddelbuettel
}
