% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sub_dann.R
\name{sub_dann.recipe}
\alias{sub_dann.recipe}
\title{Discriminant Adaptive Nearest Neighbor With Subspace Reduction}
\usage{
\method{sub_dann}{recipe}(
  x,
  data,
  k = 5,
  neighborhood_size = max(floor(nrow(data)/5), 50),
  epsilon = 1,
  weighted = FALSE,
  sphere = "mcd",
  numDim = ceiling(ncol(data)/2),
  ...
)
}
\arguments{
\item{x}{A recipe from recipes library.}

\item{data}{A data frame.}

\item{k}{The number of data points used for final classification.}

\item{neighborhood_size}{The number of data points used to calculate between and within class covariance.}

\item{epsilon}{Diagonal elements of a diagonal matrix. 1 is the identity matrix.}

\item{weighted}{weighted argument to ncoord. See \code{\link[fpc:ncoord]{fpc::ncoord()}} for details.}

\item{sphere}{One of "mcd", "mve", "classical", or "none" See \code{\link[fpc:ncoord]{fpc::ncoord()}} for details.}

\item{numDim}{Dimension of subspace used by dann. See \code{\link[fpc:ncoord]{fpc::ncoord()}} for details.}

\item{...}{Additional parameters passed to methods.}
}
\value{
An S3 class of type sub_dann
}
\description{
Discriminant Adaptive Nearest Neighbor With Subspace Reduction
}
\details{
An implementation of Hastie and Tibshirani's sub-dann in section 4.1 of
\href{https://web.stanford.edu/~hastie/Papers/dann_IEEE.pdf}{Discriminant Adaptive Nearest Neighbor Classification publication.}.

dann's performance suffers when noise variables are included in the model. Simulations show sub_dann
will generally be more performant in this scenario.
}
\examples{
library(dann)
library(mlbench)
library(magrittr)
library(dplyr)
library(recipes)

set.seed(1)
train <- mlbench.circle(300, 2) \%>\%
  tibble::as_tibble()
colnames(train) <- c("X1", "X2", "Y")

rec_obj <- recipe(Y ~ X1 + X2, data = train)

sub_dann(rec_obj, train)
}
