% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-current-forecast.r
\name{get_current_forecast}
\alias{get_current_forecast}
\title{Retrieve the current forecast (for the next week)}
\usage{
get_current_forecast(latitude, longitude, units = "us", language = "en",
  exclude = NULL, extend = NULL, add_json = FALSE, add_headers = FALSE,
  ...)
}
\arguments{
\item{latitude}{forecast latitude (character, decimal format)}

\item{longitude}{forecast longitude (character, decimal format)}

\item{units}{return the API response in units other than the default Imperial unit}

\item{language}{return text summaries in the desired language}

\item{exclude}{exclude some number of data blocks from the API response. This is useful
for reducing latency and saving cache space. This should be a comma-separated string
(without spaces) including one or more of the following: (\code{currently},
\code{minutely}, \code{hourly}, \code{daily}, \code{alerts}, \code{flags}). Crafting
a request with all of the above blocks excluded is exceedingly silly and not
recommended. Setting this parameter to \code{NULL} (the default) does not exclude any
parameters from the results.}

\item{extend}{setting this parameter to \code{hourly} the API will return hourly data
for the next seven days, rather than the next two.}

\item{add_json}{add the raw JSON response to the object?}

\item{add_headers}{add the return headers to the object?}

\item{...}{pass through parameters to \code{httr::GET} (e.g. to configure ssl options
or proxies)}
}
\value{
an \code{darksky} object that contains the original JSON response object
  (optionally), a list of  named `tbl_df` `data.frame` objects corresponding to what
  was returned by the API and (optionally) relevant response headers (\code{cache-control},
  \code{expires}, \code{x-forecast-api-calls}, \code{x-response-time}).
}
\description{
The Dark Sky API lets you query for most locations on the globe, and returns:
\enumerate{ \item{current conditions} \item{minute-by-minute forecasts out to 1 hour
(where available)} \item{hour-by-hour forecasts out to 48 hours} \item{day-by-day
forecasts out to 7 days} }
}
\details{
If you wish to have results in something besides Imperial units, set \code{units} to
one of (\code{si}, \code{ca}, \code{uk}). Setting \code{units} to \code{auto} will have
the API select the relevant units automatically, based on geographic location. This
value is set to \code{us} (Imperial) units by default.

If you wish to have text summaries presented in a different language, set
\code{language} to one of (\code{ar}, \code{bs}, \code{de}, \code{es}, \code{fr},
\code{it}, \code{nl}, \code{pl}, \code{pt}, \code{ru}, \code{sv}, \code{tet},
\code{tr}, \code{x-pig-latin}, \code{zh}). This value is set to \code{en} (English) by
default.

See the Options section of the official
\href{https://darksky.net/dev/docs}{Dark Sky API documentation} for more
information.
}
\examples{
\dontrun{
tmp <- get_current_forecast(37.8267, -122.423)
}
}

