% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.report.rdepth.r
\name{gl.report.rdepth}
\alias{gl.report.rdepth}
\title{Report summary of Read Depth for each locus}
\usage{
gl.report.rdepth(x, boxplot = "adjusted", range = 1.5, verbose = NULL)
}
\arguments{
\item{x}{-- name of the genlight object containing the SNP data [required]}

\item{boxplot}{-- if 'standard', plots a standard box and whisker plot; if 'adjusted',
plots a boxplot adjusted for skewed distributions [default 'adjusted']}

\item{range}{-- specifies the range for delimiting outliers [default = 1.5 interquartile ranges]}

\item{verbose}{-- verbosity: 0, silent or fatal errors; 1, begin and end; 2, progress log ; 3, progress and results summary; 5, full report [default 2 or as specified using gl.set.verbosity]}
}
\value{
-- dataframe with loci that are outliers
}
\description{
SNP datasets generated by DArT report AvgCountRef and AvgCountSnp as counts of sequence tags for the reference and alternate alleles respectively.
These can be used to backcalculate Read Depth. Fragment presence/absence datasets as provided by DArT (SilicoDArT) provide Average Read Depth and 
Standard Deviation of Read Depth as stanard columns in their report.
}
\details{
Filtering on Read Depth using the companion script gl.filter.rdepth can be on the basis of loci with exceptionally low counts, 
or loci with exceptionally high counts.

The minimum, maximum and mean read depth are provided. Output also is a histogram of read depth, accompanied by a box and 
whisker plot presented either in standard (boxplot="standard") or adjusted for skewness (boxplot=adjusted). 

Refer to Tukey (1977, Exploratory Data Analysis. Addison-Wesley) for standard
Box and Whisker Plots and Hubert & Vandervieren (2008), An Adjusted Boxplot for Skewed
Distributions, Computational Statistics & Data Analysis 52:5186-5201) for adjusted
Box and Whisker Plots.
}
\examples{
# SNP data
out <- gl.report.rdepth(testset.gl)
}
\author{
Arthur Georges (Post to \url{https://groups.google.com/d/forum/dartr})
}
