% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.pa.ind.r
\name{utils.pa.ind}
\alias{utils.pa.ind}
\title{Report number of private alleles possessed by an individual of unknown provenance}
\usage{
utils.pa.ind(x, unknown, nmin = 10, threshold = 0, verbose = NULL)
}
\arguments{
\item{x}{-- name of the input genlight object [required]}

\item{unknown}{-- identity label of the focal individual whose provenance is unknown [required]}

\item{nmin}{-- minimum sample size for a target population to be included in the analysis [default 10]}

\item{threshold}{-- retain those populations for which the focal individual has private alleles less or equal in number than the threshold [default 0]}

\item{verbose}{-- verbosity: 0, silent or fatal errors; 1, begin and end; 2, progress log ; 3, progress and results summary; 5, full report [default 2]}
}
\value{
returns a genlight object containing the focal individual (assigned to population "unknown") and 
populations for which the focal individual is not distinctive (number of loci with private alleles less than or equal to 'thresold').
}
\description{
This script calculates the number of private alleles possessed by a focal individual of unknown
provenance when compared to a series of target populations.
}
\details{
A private allele is an allele possessed by the focal individual, but absent from the target population. It differs from a fixed allelic difference in that the focal individual
may be heterozygous, in which case can share one but not both of its alleles with the target population.
}
\examples{
# Test run with a focal individual from the Macleay River (EmmacMaclGeor)
#dartR:::utils.pa.ind(testset.gl, unknown="UC_00146", nmin=10, threshold=1, verbose=2)
}
\author{
Arthur Georges (Post to \url{https://groups.google.com/d/forum/dartr})
}
