% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.reassign.pop.r
\name{gl.reassign.pop}
\alias{gl.reassign.pop}
\title{Assign a individual metric as pop in a genlight \{adegenet\} object}
\usage{
gl.reassign.pop(x, as.pop, verbose = NULL)
}
\arguments{
\item{x}{-- name of the genlight object containing SNP genotypes [required]}

\item{as.pop}{-- specify the name of the individual metric to set as the pop variable. [required]}

\item{verbose}{-- verbosity: 0, silent or fatal errors; 1, begin and end; 2, progress log ; 3, progress and results summary; 5, full report [default 2 or as specified using gl.set.verbosity]}
}
\value{
A genlight object with the reassigned populations
}
\description{
Individuals are assigned to populations based on the individual/sample/specimen metrics file (csv)
 used with gl.read.dart().
}
\details{
One might want to define the population structure in accordance with another classification, such as
using an individual metric (e.g. sex, male or female). This script discards the current population 
assignments and replaces them with new population assignments defined by a specified individual metric.

The script returns a genlight object with the new population assignments Note that the original population
assigments are lost.
}
\examples{
# SNP data
   popNames(testset.gl)
   gl <- gl.reassign.pop(testset.gl, as.pop='sex',verbose=3)
   popNames(gl)
# Tag P/A data
   popNames(testset.gs)
   gs <- gl.reassign.pop(testset.gs, as.pop='sex',verbose=3)
   popNames(gs)
}
\author{
Arthur Georges (Post to \url{https://groups.google.com/d/forum/dartr})
}
