% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/node.R
\name{Get}
\alias{Get}
\title{Traverse a Tree and Collect Values}
\usage{
Get(attribute, ..., traversal = "pre-order", filterFun = function(x) TRUE,
  assign = NULL, format = NULL)
}
\arguments{
\item{attribute}{determines what is collected during traversal. The attribute can be
     \itemize{
       \item a.) the name of a field of each \code{Node} in the tree
       \item b.) the name of a Method of each \code{Node}.
       \item c.) a function, whose first argument must be a node. In that case, the \code{Get} method calls the function by
       passing \code{...} to the function.
      }}

\item{traversal}{determines the traversal order. It can be either "pre-order", "post-order", or "ancestor"}

\item{filterFun}{allows providing a a filter, i.e. a function taking a \code{Node} as an input, and returning \code{TRUE} or \code{FALSE}.
Note that if filter returns \code{FALSE}, then the node and its entire subtree are ignored and neither traversed nor returned.}

\item{assign}{can be the name of a variable to which we assign the collected values before \code{format} is called.}

\item{format}{can be a function that transforms the collected values, e.g. for printing}
}
\value{
a vector containing the \code{atrributes} collected during traversal, in traversal order. \code{NULL} is converted
 to NA, such that \code{length(Node$Get) == Node$totalCount}
}
\description{
The \code{Get} function is one of the most important ones of the \code{data.tree} package. It lets you traverse a tree
and collect values along the way. Alternatively, you can call a method or a function on each \code{Node}.
}
\examples{
data(acme)
acme$Get("level")
acme$Get("totalCount")

calculateAggregateChildCost <- function(node, fun) {
 if (node$isLeaf) return(node$cost)
 fun(sapply(node$children, function(x) x$averageCost))
}

myFormat <- function(x) {
 format(x, nsmall=2, scientific = FALSE)
}

acme$Get(calculateAggregateChildCost,
        mean,
        traversal = "post-order",
        assign = "averageCost",
        format = myFormat)
}
\seealso{
\code{\link{Node}}
}
\keyword{internal}

