% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node_conversion_igraph.R
\name{as.igraph.Node}
\alias{as.igraph.Node}
\title{Convert a \code{data.tree} structure to an igraph network}
\usage{
as.igraph.Node(node, vertexAttributes = character(),
  edgeAttributes = character(), directed = FALSE, direction = c("climb",
  "descend"))
}
\arguments{
\item{node}{The root \code{Node} to convert}

\item{vertexAttributes}{A vector of strings, representing the attributes 
in the \code{data.tree} structure to add as attributes to the vertices of the igraph}

\item{edgeAttributes}{A vector of strings, representing the attributes
in the \code{data.tree} structure to add as edge attributes of the igraph}

\item{directed}{Logical scalar, whether or not to create a directed graph.}

\item{direction}{when converting to a network, should the edges point from root to children ("climb") or from child to parent ("descend")?}
}
\value{
an \code{igraph} object
}
\description{
This requires the igraph package to be installed.
Also, this requires the names of the \code{Nodes} to be unique within
the \code{data.tree} structure.
}
\examples{
data(acme)
library(igraph)
ig <- as.igraph(acme, "p", c("level", "isLeaf"))
plot(ig)

}
\seealso{
AreNamesUnique
}
