% Generated by roxygen2 (4.0.2): do not edit by hand
\name{mergeReport}
\alias{mergeReport}
\title{Merge Sample and Daily Data for WRTDS}
\usage{
mergeReport(Daily, Sample, interactive = TRUE)
}
\arguments{
\item{Daily}{dataframe containing the daily data, default is Daily}

\item{Sample}{dataframe containing the sample data, default is Sample}

\item{interactive}{logical Option for interactive mode.  If true, there is user interaction for error handling and data checks.}
}
\value{
newSample dataframe with merged flow information
}
\description{
Merges the flow data from the daily record into the sample record.
}
\examples{
# These examples require an internet connection to run
Daily <- getNWISDaily('01594440','00060', '1985-01-01', '1985-03-31')
Sample <- getNWISSample('01594440','01075', '1985-01-01', '1985-03-31')
Sample <- mergeReport(Daily, Sample)
}
\seealso{
\code{\link{getNWISDaily}}, \code{\link{getNWISSample}}
}
\keyword{USGS}
\keyword{WRTDS}
\keyword{data}
\keyword{import}

