% Generated by roxygen2 (4.0.2): do not edit by hand
\name{populateParameterINFO}
\alias{populateParameterINFO}
\title{Populate Parameter Information Columns}
\usage{
populateParameterINFO(parameterCd, INFO, interactive = TRUE)
}
\arguments{
\item{parameterCd}{string USGS parameter code}

\item{INFO}{dataframe with value and code columns. Default is INFO}

\item{interactive}{logical Option for interactive mode.  If true, there is user interaction for error handling and data checks.}
}
\value{
INFO dataframe
}
\description{
Populates INFO data frame with additional user-supplied information concerning the measured parameter.
}
\examples{
#This example requires an internet connection to run
INFO <- getNWISSiteInfo('01594440')
parameterCd <- "01075"
parameterData <- getNWISPcodeInfo(parameterCd)
INFO$param.nm <- parameterData$parameter_nm
INFO$param.units <- parameterData$parameter_units
INFO$paramShortName <- parameterData$srsname
INFO$paramNumber <- parameterData$parameter_cd
INFO <- populateParameterINFO(parameterCd, INFO)
}

