% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataops_sample.R
\name{drSample}
\alias{drSample}
\title{Take a Sample of Key-Value Pairs
Take a sample of key-value Pairs}
\usage{
drSample(x, fraction, output = NULL, overwrite = FALSE, control = NULL)
}
\arguments{
\item{x}{a 'ddo' or 'ddf' object}

\item{fraction}{fraction of key-value pairs to keep (between 0 and 1)}

\item{output}{a "kvConnection" object indicating where the output data should reside (see \code{\link{localDiskConn}}, \code{\link{hdfsConn}}).  If \code{NULL} (default), output will be an in-memory "ddo" object.}

\item{overwrite}{logical; should existing output location be overwritten? (also can specify \code{overwrite = "backup"} to move the existing output to _bak)}

\item{control}{parameters specifying how the backend should handle things (most-likely parameters to \code{rhwatch} in RHIPE) - see \code{\link{rhipeControl}} and \code{\link{localDiskControl}}}
}
\description{
Take a Sample of Key-Value Pairs
Take a sample of key-value Pairs
}
\examples{
bySpecies <- divide(iris, by = "Species")
set.seed(234)
sampleRes <- drSample(bySpecies, fraction = 0.25)
}

