% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recombine_transforms.R
\name{drGLM}
\alias{drGLM}
\title{GLM Transformation Method}
\usage{
drGLM(...)
}
\arguments{
\item{\ldots}{arguments you would pass to the \code{\link{glm}} function}
}
\value{
An object of class \code{drCoef} that contains the glm coefficients and other data needed by \code{\link{combMeanCoef}}
}
\description{
GLM transformation method -- Fit a generalized linear model to each subset
}
\details{
This provides a transformation function to be called for each subset in a recombination MapReduce job that applies R's glm method and outputs the coefficients in a way that \code{\link{combMeanCoef}} knows how to deal with.  It can be applied to a ddf with \code{\link{addTransform}} prior to calling \code{\link{recombine}}.
}
\examples{
# Artificially dichotomize the Sepal.Lengths of the iris data to
# demonstrate a GLM model
irisD <- iris
irisD$Sepal <- as.numeric(irisD$Sepal.Length > median(irisD$Sepal.Length))

# Divide the data
bySpecies <- divide(irisD, by = "Species")

# A function to fit a logistic regression model to each species
logisticReg <- function(x)
  drGLM(Sepal ~ Sepal.Width + Petal.Length + Petal.Width,
        data = x, family = binomial())

# Apply the transform and combine using 'combMeanCoef'
bySpecies \%>\%
  addTransform(logisticReg) \%>\%
  recombine(combMeanCoef)

}
\author{
Ryan Hafen
}
\seealso{
\code{\link{divide}}, \code{\link{recombine}}, \code{\link{rrDiv}}
}

