% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evolve_model.R
\name{performance}
\alias{performance}
\title{Measure Model Performance}
\usage{
performance(results, outcome, measure)
}
\arguments{
\item{results}{Numeric vector with predictions}

\item{outcome}{Numeric vector same length as results with real data to compare to.}

\item{measure}{Optional length one character vector that is either:
"accuracy", "sens", "spec", or "ppv". This specifies what measure of
predictive performance to use for training and evaluating the model. The
default measure is \code{"accuracy"}. However, accuracy can be a problematic
measure when the classes are imbalanced in the samples, i.e. if a class the
model is trying to predict is very rare. Alternatives to accuracy are
available that illuminate different aspects of predictive power. Sensitivity
answers the question, `` given that a result is truly an event, what is the
probability that the model will predict an event?'' Specificity answers the
question, ``given that a result is truly not an event, what is the
probability that the model will predict a negative?'' Positive predictive
value answers, ``what is the percent of predicted positives that are
actually positive?''}
}
\value{
Returns a numeric vector length one.
}
\description{
\code{performance} measures difference between predictions and data
}
\details{
This is the function of the \strong{datafsm} package used to measure the fsm model performance. It uses the caret package.
}
