% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WeatherReading.R
\name{weather_reading}
\alias{weather_reading}
\title{Weather Reading}
\usage{
weather_reading(date_time = "", simplify = FALSE)
}
\arguments{
\item{date_time}{Defaults to current (SGD) time. Format: YYYY-MM-DDTHH:MM:SS}

\item{simplify}{Defaults to FALSE. Otherwise, simplify = TRUE would return a
data frame where all 5 metrics are joined according to weather stations, but
return several NAs, as most weather stations collect rainfall data only.}
}
\value{
A dataframe containing various weather readings from weather stations
}
\description{
This functions calls upon the weather reading API from data.gov.sg
and returns a list containing the air temperature, rainfall, relative humidity,
wind direction and speed across Singapore. Data is updated every 5 minutes for the
rainfall API, and every half minute for the other 4 API from NEA.
}
\details{
This API takes slighlty longer than the other APIs in the package as 5 APIs are
wrapped within this function.
}
\examples{
weather_reading()
weather_reading(date = "2019-11-08T17:30:00")
weather_reading(date = "2018-01-04T09:16:17", simplify = TRUE)
}
\keyword{weather}
