% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_datas.R
\docType{data}
\name{pinusContorta}
\alias{pinusContorta}
\title{Contains information of invasive of Pinus contorta.}
\format{
Contains 8 variables, as follows:
\describe{
  \item{plot.id}{Plot sample ID.}
  \item{tree.id}{Tree identificator number in each plot. Same indv/id for multi-stem trees.}
\item{y.coord}{coordinate of S latitude.}
\item{x.coord}{coordinate of W longitude.}
\item{substrate}{Ground cover in which each pine grow. Bare soil, Festuca pallescens, Baccharis magellanica, 
Oreopulus glacialis, Acaena integerrima and others species.}
\item{drc}{Diameter at the root collar on trees, in mm.}
\item{h}{Height of trees, in cm.}
\item{canopy.area}{Proyection of canopy area of each tree, in square meters.}
}
}
\source{
The data are provided courtesy of Drs. Anibal Pauchard and Rafael Garcia at the Laboratorio de Invasiones Biologicas,
 Universidad de Concepcion (Chile).
}
\usage{
data(pinusContorta)
}
\description{
These are tree-lavel measurement data, with x,y location of each tree, from Pinus contorta invasion in 
Patagonian steppe in Coyhaique in southhern Chile, measured in 2011. The plots area was 10000 square meters.
}
\examples{
data(pinusContorta)    
head(pinusContorta) 
}
\references{
Pauchard A, Escudero A, Garcia RA, de la Cruz M, Langdon B, Cavieres LA, Esquivel J. 2016.
 Pine invasions in treeless environments: dispersal overruns microsite heterogeneity. 
 Ecology and Evolution. 6(2): 447 - 459
}
\keyword{datasets}
