% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xyHist.R
\name{xyHist}
\alias{xyHist}
\title{xyHist: Function for a scatter-plot with marginal histograms}
\usage{
xyHist(
  x = x,
  y = y,
  col.x = "blue",
  col.y = "red",
  xlab = NULL,
  ylab = NULL,
  x.lim = NULL,
  y.lim = NULL
)
}
\arguments{
\item{x}{A numeric vector representing the X-axis variable}

\item{y}{A numeric vector representing the Y-axis variable}

\item{col.x}{(optional) A string specifying the color of the histogram of the X-variable. Default is "blue".}

\item{col.y}{(optional) A string specifying the color of the histogram of the Y-variable. Default is "red".}

\item{xlab}{(optional) A string specifying X-axis label. Default is "xvar".}

\item{ylab}{(optional) A string specifying Y-axis label. Default is "yvar".}

\item{x.lim}{(optional) A vector of two elements with the limits of the Y-axis. Default is the range of the X-variable.}

\item{y.lim}{(optional) A vector of two elements with the limits of the Y-axis. Default is the range of the Y-variable.}
}
\value{
Result of calculation
}
\description{
It creates a scattter-plot with histograms in both axys.
}
\examples{
library(datana)
data(treevolroble)
df <- treevolroble
head(df)
xyHist(x=df$dbh,y=df$htot) 
xyHist(x=df$dbh,y=df$htot, xlab="Variable X",  ylab="Variable Y") 
xyHist(x=df$dbh,y=df$htot, xlab="Variable X", ylab="Variable Y", 
  col.x = "gray",col.y="white")
}
