/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.GraphRDB;
import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.RDFRDBException;
import com.hp.hpl.jena.db.impl.DBQuery;
import com.hp.hpl.jena.db.impl.DBQueryHandler;
import com.hp.hpl.jena.db.impl.DBQueryStageCompiler;
import com.hp.hpl.jena.db.impl.ResultSetIterator;
import com.hp.hpl.jena.db.impl.SpecializedGraph;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.query.BufferPipe;
import com.hp.hpl.jena.graph.query.Domain;
import com.hp.hpl.jena.graph.query.ExpressionSet;
import com.hp.hpl.jena.graph.query.Pipe;
import com.hp.hpl.jena.graph.query.Stage;
import com.hp.hpl.jena.shared.JenaException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class DBQueryStage
extends Stage {
    protected Graph graph;
    protected DBQuery compiled;
    private static final DBQueryStageCompiler compiler = new DBQueryStageCompiler();

    public DBQueryStage(GraphRDB graph, SpecializedGraph sg, List varList, List dbPat, ExpressionSet constraints) {
        this.graph = graph;
        this.compiled = this.compile(sg, varList, dbPat, constraints);
    }

    protected DBQuery compile(SpecializedGraph sg, List varList, List dbPat, ExpressionSet constraints) {
        return this.compile(compiler, sg, varList, dbPat, constraints);
    }

    protected DBQuery compile(DBQueryStageCompiler compiler, SpecializedGraph sg, List varList, List dbPat, ExpressionSet constraints) {
        return DBQueryStageCompiler.compile(compiler, (DBQueryHandler)this.graph.queryHandler(), sg, varList, dbPat, constraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run(Pipe source, Pipe sink) {
        PreparedStatement ps = null;
        try {
            if (!this.compiled.isEmpty) {
                ps = this.getPreparedStatement();
            }
            if (ps != null) {
                while (source.hasNext()) {
                    this.extendSourceBinding(source.get(), sink, ps);
                }
            }
        }
        finally {
            if (ps != null) {
                this.closePreparedStatement(ps);
            }
            if (sink != null) {
                sink.close();
            }
        }
    }

    private void extendSourceBinding(Domain current, Pipe sink, PreparedStatement ps) {
        ResultSet rs = null;
        ResultSetIterator it = null;
        this.setArgs(current, ps);
        try {
            it = new ResultSetIterator();
            ps.execute();
            rs = ps.getResultSet();
            it.reset(rs, ps);
            while (it.hasNext()) {
                Domain useme = current.copy();
                List row = (List)it.next();
                for (int i = 0; i < this.compiled.resList.length; ++i) {
                    int j = this.compiled.resList[i];
                    String o = (String)row.get(i);
                    Node n = this.compiled.driver.RDBStringToNode(o);
                    useme.setElement(j, n);
                }
                sink.put(useme);
            }
            if (it != null) {
                it.close();
            }
            if (rs != null) {
                this.closeResultSet(rs);
            }
        }
        catch (Exception e) {
            try {
                throw new JenaException("Query execute failed: " + e);
            }
            catch (Throwable throwable) {
                if (it != null) {
                    it.close();
                }
                if (rs != null) {
                    this.closeResultSet(rs);
                }
                throw throwable;
            }
        }
    }

    private void closePreparedStatement(PreparedStatement ps) {
        try {
            ps.close();
        }
        catch (Exception e) {
            throw new JenaException("Close on prepared stmt failed: " + e);
        }
    }

    private void closeResultSet(ResultSet rs) {
        try {
            rs.close();
        }
        catch (SQLException e) {
            throw new RDFRDBException("Failed to get last inserted ID: " + e);
        }
    }

    private PreparedStatement getPreparedStatement() {
        try {
            IDBConnection conn = this.compiled.driver.getConnection();
            return conn.getConnection().prepareStatement(this.compiled.stmt);
        }
        catch (Exception e) {
            throw new JenaException("Query prepare failed: " + e);
        }
    }

    protected void setArgs(Domain args, PreparedStatement ps) {
        try {
            for (int i = 0; i < this.compiled.argCnt; ++i) {
                int ix = (Integer)this.compiled.argIndex.get(i);
                Node arg = (Node)args.get(ix);
                if (arg == null) {
                    throw new JenaException("Null query argument");
                }
                String val = this.compiled.driver.nodeToRDBString(arg, false);
                ps.setString(i + 1, val);
            }
        }
        catch (SQLException e) {
            throw new JenaException("Bad query argument", e);
        }
    }

    public Pipe deliver(final Pipe result) {
        final Pipe stream = this.previous.deliver(new BufferPipe());
        new Thread(){

            public void run() {
                DBQueryStage.this.run(stream, result);
            }
        }.start();
        return result;
    }
}

