/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVisitorBase;
import com.hp.hpl.jena.sparql.algebra.OpWalker;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;

public class OpPrefixesUsed {
    public static PrefixMapping used(Op op, PrefixMapping pmap) {
        PrefixMappingImpl pmap2 = new PrefixMappingImpl();
        PrefixFinder finder = new PrefixFinder((PrefixMapping)pmap2, pmap.getNsPrefixMap());
        OpWalker.walk(op, finder);
        return pmap2;
    }

    static class PrefixFinder
    extends OpVisitorBase {
        Map pmap;
        PrefixMapping usedPMap;

        public PrefixFinder(PrefixMapping pmap2, Map pmap) {
            this.pmap = pmap;
            this.usedPMap = pmap2;
        }

        public void visit(OpGraph opGraph) {
            this.node(opGraph.getNode());
        }

        public void visit(OpQuadPattern quadPattern) {
            this.node(quadPattern.getGraphNode());
            this.visit(quadPattern.getBasicPattern());
        }

        public void visit(OpBGP opBGP) {
            BasicPattern p = opBGP.getPattern();
            this.visit(opBGP.getPattern());
        }

        private void visit(BasicPattern pattern) {
            ListIterator iter = pattern.iterator();
            while (iter.hasNext()) {
                Triple t = (Triple)iter.next();
                this.node(t.getSubject());
                this.node(t.getPredicate());
                this.node(t.getObject());
            }
        }

        public void visit(OpFilter opFilter) {
        }

        private void node(Node n) {
            if (!n.isURI()) {
                return;
            }
            String uri = n.getURI();
            if (this.usedPMap.shortForm(uri) != uri) {
                return;
            }
            Iterator iter = this.pmap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry e2 = iter.next();
                String k = (String)e2.getKey();
                String v = (String)e2.getValue();
                if (!uri.startsWith(v)) continue;
                this.usedPMap.setNsPrefix(k, v);
                return;
            }
        }
    }
}

