/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.shared.Lock;
import com.hp.hpl.jena.sparql.core.DataSourceGraphImpl;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.MapFilter;
import com.hp.hpl.jena.util.iterator.MapFilterIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DatasetImpl
implements Dataset {
    protected DatasetGraph dsg = null;
    private Map cache = new HashMap();

    public DatasetImpl(Model model) {
        this.addToCache(model);
        this.dsg = new DataSourceGraphImpl(model.getGraph());
    }

    public DatasetImpl(DatasetGraph dsg) {
        this.dsg = dsg;
    }

    public Model getDefaultModel() {
        return this.graph2model(this.dsg.getDefaultGraph());
    }

    public Lock getLock() {
        return this.dsg.getLock();
    }

    public DatasetGraph asDatasetGraph() {
        return this.dsg;
    }

    public Model getNamedModel(String uri) {
        return this.graph2model(this.dsg.getGraph(Node.createURI((String)uri)));
    }

    public boolean containsNamedModel(String uri) {
        return this.dsg.containsGraph(Node.createURI((String)uri));
    }

    public Iterator listNames() {
        ArrayList x = new ArrayList(this.dsg.size());
        MapFilter mapper = new MapFilter(){

            public Object accept(Object x) {
                Node n = (Node)x;
                return n.getURI();
            }
        };
        ExtendedIterator eIter = WrappedIterator.create((Iterator)this.dsg.listGraphNodes());
        MapFilterIterator conv = new MapFilterIterator(mapper, eIter);
        return conv;
    }

    private void removeFromCache(Graph graph) {
        if (graph == null) {
            return;
        }
        this.cache.remove(graph);
    }

    private void addToCache(Model model) {
        this.cache.put(model.getGraph(), model);
    }

    private Model graph2model(Graph graph) {
        Model model = (Model)this.cache.get(graph);
        if (model == null) {
            model = ModelFactory.createModelForGraph((Graph)graph);
            this.cache.put(graph, model);
        }
        return model;
    }
}

