/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.client;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import org.apache.commons.io.input.CountingInputStream;
import org.dataone.client.ObjectFormatCache;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.AccessPolicy;
import org.dataone.service.types.v1.AccessRule;
import org.dataone.service.types.v1.Checksum;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.ObjectFormat;
import org.dataone.service.types.v1.ObjectFormatIdentifier;
import org.dataone.service.types.v1.Permission;
import org.dataone.service.types.v1.Replica;
import org.dataone.service.types.v1.ReplicationPolicy;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v1.SystemMetadata;
import org.dataone.service.types.v1.util.AccessUtil;
import org.dataone.service.types.v1.util.ChecksumUtil;

public class D1TypeBuilder {
    public static NodeReference buildNodeReference(String value) {
        NodeReference id = new NodeReference();
        id.setValue(value);
        return id;
    }

    public static ObjectFormatIdentifier buildFormatIdentifier(String value) {
        ObjectFormatIdentifier fid = new ObjectFormatIdentifier();
        fid.setValue(value);
        return fid;
    }

    public static Identifier buildIdentifier(String value) {
        Identifier id = new Identifier();
        id.setValue(value);
        return id;
    }

    public static Subject buildSubject(String value) {
        Subject s = new Subject();
        s.setValue(value);
        return s;
    }

    public static AccessRule buildAccessRule(String subjectString, Permission permission) {
        if (subjectString == null || permission == null) {
            return null;
        }
        AccessRule ar = new AccessRule();
        ar.addSubject(D1TypeBuilder.buildSubject(subjectString));
        ar.addPermission(permission);
        return ar;
    }

    public static AccessRule buildAccessRule(String subjectString, Permission[] permissions) {
        if (subjectString == null || permissions == null) {
            return null;
        }
        AccessRule ar = new AccessRule();
        ar.addSubject(D1TypeBuilder.buildSubject(subjectString));
        for (Permission p : permissions) {
            ar.addPermission(p);
        }
        return ar;
    }

    public static SystemMetadata buildMinimalSystemMetadata(Identifier id, InputStream data, ObjectFormatIdentifier formatId, Subject rightsHolder) throws NoSuchAlgorithmException, IOException, NotFound, ServiceFailure {
        ObjectFormat fmt;
        SystemMetadata sm = new SystemMetadata();
        sm.setIdentifier(id);
        try {
            fmt = ObjectFormatCache.getInstance().getFormat(formatId);
        }
        catch (BaseException be) {
            formatId.setValue("application/octet-stream");
            fmt = ObjectFormatCache.getInstance().getFormat(formatId);
        }
        sm.setFormatId(fmt.getFormatId());
        CountingInputStream cis = new CountingInputStream(data);
        Checksum checksum = ChecksumUtil.checksum((InputStream)cis, (String)"MD5");
        sm.setChecksum(checksum);
        sm.setSize(new BigInteger(String.valueOf(cis.getByteCount())));
        cis.close();
        sm.setSerialVersion(BigInteger.ONE);
        sm.setSubmitter(rightsHolder);
        sm.setRightsHolder(rightsHolder);
        Date dateCreated = new Date();
        sm.setDateUploaded(dateCreated);
        Date dateUpdated = new Date();
        sm.setDateSysMetadataModified(dateUpdated);
        return sm;
    }

    public static SystemMetadata cloneSystemMetadata(SystemMetadata sm) {
        SystemMetadata clone = new SystemMetadata();
        clone.setAccessPolicy(AccessUtil.cloneAccessPolicy((AccessPolicy)sm.getAccessPolicy()));
        if (sm.getArchived() != null) {
            clone.setArchived(new Boolean(sm.getArchived()));
        }
        clone.setAuthoritativeMemberNode(D1TypeBuilder.cloneNodeReference(sm.getAuthoritativeMemberNode()));
        clone.setChecksum(D1TypeBuilder.cloneChecksum(sm.getChecksum()));
        clone.setDateSysMetadataModified((Date)sm.getDateSysMetadataModified().clone());
        clone.setDateUploaded((Date)sm.getDateUploaded().clone());
        clone.setFormatId(D1TypeBuilder.cloneFormatIdentifier(sm.getFormatId()));
        clone.setIdentifier(D1TypeBuilder.cloneIdentifier(sm.getIdentifier()));
        clone.setObsoletedBy(D1TypeBuilder.cloneIdentifier(sm.getObsoletedBy()));
        clone.setObsoletes(D1TypeBuilder.cloneIdentifier(sm.getObsoletes()));
        clone.setOriginMemberNode(D1TypeBuilder.cloneNodeReference(sm.getOriginMemberNode()));
        if (sm.getReplicaList() != null) {
            for (Replica rep : sm.getReplicaList()) {
                Replica newRep = new Replica();
                newRep.setReplicaMemberNode(D1TypeBuilder.cloneNodeReference(rep.getReplicaMemberNode()));
                newRep.setReplicationStatus(rep.getReplicationStatus());
                newRep.setReplicaVerified(rep.getReplicaVerified());
                clone.addReplica(newRep);
            }
        }
        if (sm.getReplicationPolicy() != null) {
            ReplicationPolicy rp = new ReplicationPolicy();
            rp.setNumberReplicas(sm.getReplicationPolicy().getNumberReplicas());
            rp.setReplicationAllowed(Boolean.valueOf(sm.getReplicationPolicy().getReplicationAllowed()));
            if (sm.getReplicationPolicy().getBlockedMemberNodeList() != null) {
                for (NodeReference blockedMN : sm.getReplicationPolicy().getBlockedMemberNodeList()) {
                    rp.addBlockedMemberNode(D1TypeBuilder.cloneNodeReference(blockedMN));
                }
            }
            if (sm.getReplicationPolicy().getPreferredMemberNodeList() != null) {
                for (NodeReference preferredMN : sm.getReplicationPolicy().getPreferredMemberNodeList()) {
                    rp.addPreferredMemberNode(D1TypeBuilder.cloneNodeReference(preferredMN));
                }
            }
        }
        clone.setRightsHolder(D1TypeBuilder.cloneSubject(sm.getSubmitter()));
        clone.setSubmitter(D1TypeBuilder.cloneSubject(sm.getSubmitter()));
        if (sm.getSize() != null) {
            clone.setSize(new BigInteger(String.valueOf(sm.getSize().longValue())));
        }
        if (sm.getSerialVersion() != null) {
            clone.setSerialVersion(new BigInteger(String.valueOf(sm.getSerialVersion().longValue())));
        }
        return clone;
    }

    public static Identifier cloneIdentifier(Identifier orig) {
        if (orig == null) {
            return null;
        }
        return D1TypeBuilder.buildIdentifier(orig.getValue());
    }

    public static Subject cloneSubject(Subject orig) {
        if (orig == null) {
            return null;
        }
        return D1TypeBuilder.buildSubject(orig.getValue());
    }

    public static ObjectFormatIdentifier cloneFormatIdentifier(ObjectFormatIdentifier orig) {
        if (orig == null) {
            return null;
        }
        return D1TypeBuilder.buildFormatIdentifier(orig.getValue());
    }

    public static NodeReference cloneNodeReference(NodeReference orig) {
        if (orig == null) {
            return null;
        }
        return D1TypeBuilder.buildNodeReference(orig.getValue());
    }

    public static Checksum cloneChecksum(Checksum cs) {
        if (cs == null) {
            return null;
        }
        Checksum clone = new Checksum();
        if (cs.getAlgorithm() != null) {
            clone.setAlgorithm(cs.getAlgorithm());
        }
        if (cs.getValue() != null) {
            clone.setValue(cs.getValue());
        }
        return clone;
    }
}

