/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.dataone.client.D1Client;
import org.dataone.client.D1Object;
import org.dataone.ore.ResourceMapFactory;
import org.dataone.service.exceptions.InsufficientResources;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.SystemMetadata;
import org.dspace.foresite.OREException;
import org.dspace.foresite.OREParserException;
import org.dspace.foresite.ORESerialiserException;
import org.dspace.foresite.ResourceMap;

public class DataPackage {
    private Identifier packageId;
    private Map<Identifier, List<Identifier>> metadataMap;
    private HashMap<Identifier, D1Object> objectStore = new HashMap();
    private ResourceMap map = null;
    private SystemMetadata systemMetadata = null;

    public DataPackage() {
        this(null);
    }

    public DataPackage(Identifier id) {
        this.metadataMap = new HashMap<Identifier, List<Identifier>>();
        this.setPackageId(id);
    }

    public void addAndDownloadData(Identifier id) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented, InsufficientResources, InvalidRequest {
        if (!this.contains(id)) {
            D1Object o = D1Object.download(id);
            this.objectStore.put(id, o);
        }
    }

    public void addData(D1Object obj) {
        Identifier id = obj.getIdentifier();
        if (!this.contains(id) && obj != null) {
            this.objectStore.put(id, obj);
        }
    }

    public void insertRelationship(Identifier metadataID, List<Identifier> dataIDList) {
        List<Object> associatedData = null;
        associatedData = this.metadataMap.containsKey(metadataID) ? this.metadataMap.get(metadataID) : new ArrayList();
        for (Identifier dataId : dataIDList) {
            if (associatedData.contains(dataId)) continue;
            associatedData.add(dataId);
        }
        if (!this.metadataMap.containsKey(metadataID)) {
            this.metadataMap.put(metadataID, associatedData);
        }
    }

    public int size() {
        return this.objectStore.size();
    }

    public boolean contains(Identifier id) {
        return this.objectStore.containsKey(id);
    }

    public D1Object get(Identifier id) {
        return this.objectStore.get(id);
    }

    public void remove(Identifier id) {
        this.removeData(id);
    }

    public void removeData(Identifier id) {
        this.objectStore.remove(id);
    }

    public Set<Identifier> identifiers() {
        return this.objectStore.keySet();
    }

    public Identifier getPackageId() {
        return this.packageId;
    }

    public void setPackageId(Identifier packageId) {
        if (null != packageId) {
            this.packageId = packageId;
        }
    }

    public ResourceMap getMap() throws OREException, URISyntaxException {
        this.updateResourceMap();
        return this.map;
    }

    public String serializePackage() throws OREException, URISyntaxException, ORESerialiserException {
        ResourceMap rm = this.getMap();
        String rdfXml = ResourceMapFactory.getInstance().serializeResourceMap(rm);
        return rdfXml;
    }

    public static DataPackage download(Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented, InsufficientResources, InvalidRequest, OREException, URISyntaxException, OREParserException, IOException {
        D1Object packageObject = D1Object.download(pid);
        if (packageObject.getFormatId().getValue().equals("http://www.openarchives.org/ore/terms")) {
            String resourceMap = IOUtils.toString((InputStream)packageObject.getDataSource().getInputStream());
            return DataPackage.deserializePackage(resourceMap);
        }
        throw new InvalidRequest("0000", "The identifier does not represent a DataPackage (is not an ORE resource map)");
    }

    public static DataPackage deserializePackage(String resourceMap) throws UnsupportedEncodingException, OREException, URISyntaxException, OREParserException, InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented, InsufficientResources, InvalidRequest {
        Map<Identifier, Map<Identifier, List<Identifier>>> packageMap = ResourceMapFactory.getInstance().parseResourceMap(resourceMap);
        DataPackage dp = null;
        if (packageMap != null && !packageMap.isEmpty()) {
            Identifier pid = packageMap.keySet().iterator().next();
            dp = new DataPackage(pid);
            Map<Identifier, List<Identifier>> mdMap = packageMap.get(pid);
            dp.setMetadataMap(mdMap);
            for (Identifier scienceMetadataId : mdMap.keySet()) {
                dp.addAndDownloadData(scienceMetadataId);
                List<Identifier> dataIdentifiers = mdMap.get(scienceMetadataId);
                for (Identifier dataId : dataIdentifiers) {
                    dp.addAndDownloadData(dataId);
                }
            }
        }
        return dp;
    }

    public Map<Identifier, List<Identifier>> getMetadataMap() {
        return this.metadataMap;
    }

    public Identifier getDocumentedBy(Identifier dataObject) {
        Map<Identifier, List<Identifier>> mdMap = this.getMetadataMap();
        Set<Identifier> metadataMembers = mdMap.keySet();
        Identifier documenter = null;
        for (Identifier md : metadataMembers) {
            if (!mdMap.get(md).contains(dataObject)) continue;
            documenter = md;
            break;
        }
        return documenter;
    }

    public void setMetadataMap(Map<Identifier, List<Identifier>> metadataMap) {
        this.metadataMap = metadataMap;
    }

    public void setSystemMetadata(SystemMetadata systemMetadata) {
        this.systemMetadata = systemMetadata;
    }

    public SystemMetadata getSystemMetadata() {
        return this.systemMetadata;
    }

    private void updateResourceMap() throws OREException, URISyntaxException {
        try {
            this.map = ResourceMapFactory.getInstance().createResourceMap(this.packageId, this.metadataMap);
        }
        catch (OREException e) {
            this.map = null;
            throw e;
        }
        catch (URISyntaxException e) {
            this.map = null;
            throw e;
        }
    }

    public Set<Identifier> getUncharacterizedMembers() {
        HashSet<Identifier> unmappedMembers = new HashSet<Identifier>();
        for (Identifier pid : this.objectStore.keySet()) {
            if (this.getMetadataMap().containsKey(pid) || this.getDocumentedBy(pid) != null) continue;
            unmappedMembers.add(pid);
        }
        return unmappedMembers;
    }

    public Set<Identifier> getUnresolvableMembers() throws InvalidToken, ServiceFailure, NotImplemented {
        Set<Identifier> unresolvedItems = this.getPackageResources();
        unresolvedItems.removeAll(this.objectStore.keySet());
        for (Identifier item : unresolvedItems) {
            try {
                D1Client.getCN().resolve(item);
                unresolvedItems.remove(item);
            }
            catch (NotAuthorized e) {
                unresolvedItems.remove(item);
            }
            catch (NotFound e) {}
        }
        return unresolvedItems;
    }

    private Set<Identifier> getPackageResources() {
        HashSet<Identifier> packageResources = new HashSet<Identifier>();
        for (Identifier pid : this.getMetadataMap().keySet()) {
            packageResources.add(pid);
            packageResources.addAll((Collection<Identifier>)this.getMetadataMap().get(pid));
        }
        return packageResources;
    }
}

