% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataObject.R
\name{updateXML}
\alias{updateXML}
\alias{updateXML,DataObject-method}
\title{Update selected elements of the XML content of a DataObject}
\usage{
updateXML(x, ...)

\S4method{updateXML}{DataObject}(x, xpath = NA_character_, replacement = NA_character_, ...)
}
\arguments{
\item{x}{A DataObject instance}

\item{...}{Additional parameters (not yet used)}

\item{xpath}{A \code{character} value specifying the location in the XML to update.}

\item{replacement}{A \code{character} value that will replace the elements found with the \code{xpath}.}
}
\value{
The modified DataObject
}
\description{
The data content of the DataObject is updated by using the \code{xpath} 
argument to locate the elements to update with the character value specified in the 
\code{replacement} argument.
}
\examples{
\dontrun{
library(datapack)
dataObj <- new("DataObject", format="text/csv", file=sampleData)
sampleEML <- system.file("extdata/sample-eml.xml", package="datapack")
dataObj <- updateMetadata(dataObj, xpath="", replacement=)
}
library(datapack)
# Create the metadata object with a sample EML file
sampleMeta <- system.file("./extdata/sample-eml.xml", package="datapack")
metaObj <- new("DataObject", format="eml://ecoinformatics.org/eml-2.1.1", file=sampleMeta)
# In the metadata object, replace "sample-data.csv" with 'sample-data.csv.zip'
xp <- sprintf("//dataTable/physical/objectName[text()=\"\%s\"]", "sample-data.csv")
metaObj <- updateXML(metaObj, xpath=xp, replacement="sample-data.csv.zip")
}
\seealso{
\code{\link{DataObject-class}}
}
